/*
 * Decompiled with CFR 0.152.
 */
package com.vengeancehelper;

import com.vengeancehelper.VengeanceHelperConfig;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;

public class VengeanceHelperOverlay
extends OverlayPanel {
    private static final Color FOCUS = new Color(255, 0, 0, 150);
    private final VengeanceHelperConfig config;
    private final Client client;

    @Inject
    private VengeanceHelperOverlay(VengeanceHelperConfig config, Client client) {
        this.config = config;
        this.client = client;
    }

    public Dimension render(Graphics2D graphics) {
        this.panelComponent.getChildren().clear();
        this.panelComponent.getChildren().add(LineComponent.builder().left("Cast Vengeance!").build());
        if (this.config.shouldFlash()) {
            if (this.client.getGameCycle() % 40 >= 20) {
                this.panelComponent.setBackgroundColor(this.getPreferredColor());
            } else {
                this.panelComponent.setBackgroundColor(FOCUS);
            }
        } else {
            this.panelComponent.setBackgroundColor(FOCUS);
        }
        this.setPosition(OverlayPosition.ABOVE_CHATBOX_RIGHT);
        return this.panelComponent.render(graphics);
    }
}

