/*
 * Decompiled with CFR 0.152.
 */
package xyz.cecchetti.clearunsentmessages;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.widgets.Widget;
import net.runelite.client.input.KeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.cecchetti.clearunsentmessages.ClearUnsentConfig;

public class ChatMessageManager {
    private static final Logger log = LoggerFactory.getLogger(ChatMessageManager.class);
    private static final Pattern PATTERN_ONLY_SPACES_AND_NUMBERS = Pattern.compile("^[ |\\d]*$");
    private static final Pattern PATTERN_CHATBOX_TEXT_PREFIX = Pattern.compile("(.*?): <col=(.*?)>");
    private static final String CHATBOX_TEXT_EMPTY_MESSAGE_FORMAT = "%s: <col=%s></col><col=%<s>*</col>";
    private static final Component STUB_COMPONENT = new Component(){};
    private final AtomicReference<Widget> chatboxWidgetHolder = new AtomicReference();
    private final Client client;
    private final ClearUnsentConfig config;
    private final KeyManager keyManager;
    private final ScheduledExecutorService executorService;
    private ScheduledFuture<?> future = null;

    @Inject
    ChatMessageManager(Client client, ClearUnsentConfig config, KeyManager keyManager, ScheduledExecutorService executorService) {
        this.client = client;
        this.config = config;
        this.keyManager = keyManager;
        this.executorService = executorService;
    }

    public void onMessageChanged() {
        Optional.ofNullable(this.future).ifPresent(f -> f.cancel(true));
        this.future = this.executorService.schedule(() -> {
            String typedText = this.client.getVarcStrValue(335);
            if (!this.shouldClearMessage(typedText)) {
                log.debug("No update needed: [" + typedText + "]");
                return;
            }
            log.debug("(executed) Clearing: [" + typedText + "]");
            this.clearMessage();
            this.sendBackspace();
        }, (long)this.config.delay(), TimeUnit.MILLISECONDS);
    }

    public void releaseChatboxWidget() {
        this.chatboxWidgetHolder.set(null);
    }

    private boolean shouldClearMessage(String msg) {
        return !this.config.onlySpacesNumbers() || PATTERN_ONLY_SPACES_AND_NUMBERS.matcher(msg).matches();
    }

    private void clearMessage() {
        this.client.setVarcStrValue(335, "");
        Widget chatboxWidget = this.chatboxWidgetHolder.updateAndGet(w -> w != null ? w : this.client.getWidget(162, 55));
        if (chatboxWidget == null) {
            return;
        }
        String widgetText = chatboxWidget.getText();
        if (widgetText == null) {
            return;
        }
        Matcher matcher = PATTERN_CHATBOX_TEXT_PREFIX.matcher(widgetText);
        if (!matcher.find()) {
            return;
        }
        chatboxWidget.setText(String.format(CHATBOX_TEXT_EMPTY_MESSAGE_FORMAT, matcher.group(1), matcher.group(2)));
        chatboxWidget.setXTextAlignment(0);
    }

    private void sendBackspace() {
        KeyEvent fakeKeyEvent = new KeyEvent(STUB_COMPONENT, 1, System.currentTimeMillis(), 0, 8, '\b');
        this.keyManager.processKeyPressed(fakeKeyEvent);
        this.keyManager.processKeyReleased(fakeKeyEvent);
        this.keyManager.processKeyTyped(fakeKeyEvent);
    }
}

