/*
 * Decompiled with CFR 0.152.
 */
package com.barrowspotential;

import com.barrowspotential.AStar;
import com.barrowspotential.Monster;
import com.barrowspotential.RewardPlan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;

public class RewardPlanner
extends AStar<RewardPlan, Integer> {
    public Mode mode = Mode.NEAREST;
    public Set<Monster> monstersToTarget = Monster.cryptMonsters;

    public RewardPlanner() {
        super(Integer.MIN_VALUE, Comparator.reverseOrder());
    }

    @Override
    protected int getHScore(RewardPlan current, Integer target) {
        return current.GetRewardPotential();
    }

    @Override
    protected int getDScore(RewardPlan current, RewardPlan neighbor) {
        return neighbor.GetRewardPotential() - current.GetRewardPotential();
    }

    @Override
    protected boolean isGoal(RewardPlan current, Integer target) {
        return current.GetRewardPotential() >= target;
    }

    @Override
    protected Collection<RewardPlan> getNeighbors(RewardPlan current, Integer target) {
        assert (this.monstersToTarget != null);
        ArrayList<RewardPlan> neighbors = new ArrayList<RewardPlan>();
        int currentValue = current.GetRewardPotential();
        for (Monster monster : this.monstersToTarget) {
            if (this.mode == Mode.NEAREST && currentValue + monster.getCombatLevel() > target) continue;
            neighbors.add(current.Append(monster));
        }
        return neighbors;
    }

    public static enum Mode {
        NEAREST,
        ANY;

    }
}

