/*
 * Decompiled with CFR 0.152.
 */
package com.barrowspotential;

import com.barrowspotential.Monster;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class RewardPlan {
    public static final RewardPlan Default = new RewardPlan(new HashMap<Monster, Integer>());
    public final Map<Monster, Integer> monsters;

    public static RewardPlan Create(Monster ... monsters) {
        HashMap<Monster, Integer> map = new HashMap<Monster, Integer>();
        for (Monster monster : monsters) {
            map.put(monster, map.getOrDefault((Object)monster, 0) + 1);
        }
        return new RewardPlan(map);
    }

    public RewardPlan(Map<Monster, Integer> monsters) {
        this.monsters = Collections.unmodifiableMap(monsters);
    }

    public RewardPlan Append(Monster monster) {
        HashMap<Monster, Integer> monsters = new HashMap<Monster, Integer>(this.monsters);
        monsters.put(monster, this.monsters.getOrDefault((Object)monster, 0) + 1);
        return new RewardPlan(monsters);
    }

    public int GetRewardPotential() {
        int rewardPotential = 0;
        for (Map.Entry<Monster, Integer> entry : this.monsters.entrySet()) {
            rewardPotential += entry.getKey().getCombatLevel() * entry.getValue();
            if (!entry.getKey().isBrother()) continue;
            rewardPotential += 2;
        }
        return rewardPotential;
    }

    public int hashCode() {
        return this.monsters.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != RewardPlan.class) {
            return false;
        }
        RewardPlan other = (RewardPlan)obj;
        return this.monsters.equals(other.monsters);
    }

    public String toString() {
        return String.format("Potential: %d", this.GetRewardPotential());
    }
}

