/*
 * Decompiled with CFR 0.152.
 */
package com.barrowspotential;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class Monster
extends Enum<Monster> {
    public static final /* enum */ Monster Ahrim = new Monster("Ahrim the Blighted", 98, 1672, 457);
    public static final /* enum */ Monster Dharok = new Monster("Dharok the Wretched", 115, 1673, 458);
    public static final /* enum */ Monster Guthan = new Monster("Guthan the Infested", 115, 1674, 459);
    public static final /* enum */ Monster Karil = new Monster("Karil the Tainted", 98, 1675, 460);
    public static final /* enum */ Monster Torag = new Monster("Torag the Corrupted", 115, 1676, 461);
    public static final /* enum */ Monster Verac = new Monster("Verac the Defiled", 115, 1677, 462);
    public static final /* enum */ Monster CryptRat = new Monster("Crypt rat", 43, 1679);
    public static final /* enum */ Monster Bloodworm = new Monster("Bloodworm", 52, 1678);
    public static final /* enum */ Monster CryptSpider = new Monster("Crypt spider", 56, 1683);
    public static final /* enum */ Monster GiantCryptRat = new Monster("Giant crypt rat", 76, new int[]{1680, 1681, 1682});
    public static final /* enum */ Monster Skeleton = new Monster("Skeleton", 77, new int[]{1685, 1686, 1687, 1688});
    public static final /* enum */ Monster GiantCryptSpider = new Monster("Giant crypt spider", 79, 1684);
    private final String displayName;
    private final int combatLevel;
    private final int[] npcIDs;
    private final int varbit;
    public static final Set<Monster> brothers;
    public static final Set<Monster> cryptMonsters;
    public static final Map<Integer, Monster> cryptMonsterByNpcID;
    public static final Map<Integer, Monster> brothersByVarbit;
    private static final /* synthetic */ Monster[] $VALUES;

    public static Monster[] values() {
        return (Monster[])$VALUES.clone();
    }

    public static Monster valueOf(String name) {
        return Enum.valueOf(Monster.class, name);
    }

    private Monster(String displayName, int combatLevel, int npcID) {
        this(displayName, combatLevel, npcID, 0);
    }

    private Monster(String displayName, int combatLevel, int[] npcIDs) {
        this(displayName, combatLevel, npcIDs, 0);
    }

    private Monster(String displayName, int combatLevel, int npcID, int varbit) {
        this(displayName, combatLevel, new int[]{npcID}, varbit);
    }

    public String toString() {
        return this.displayName;
    }

    public final boolean isBrother() {
        return this.getVarbit() != 0;
    }

    private static Map<Integer, Monster> getCryptMonstersByNpcID() {
        HashMap<Integer, Monster> map = new HashMap<Integer, Monster>();
        for (Monster monster : cryptMonsters) {
            assert (!monster.isBrother());
            for (int npcID : monster.getNpcIDs()) {
                map.put(npcID, monster);
            }
        }
        return ImmutableMap.copyOf(map);
    }

    private static Map<Integer, Monster> getBrothersByVarbit() {
        HashMap<Integer, Monster> map = new HashMap<Integer, Monster>();
        for (Monster monster : brothers) {
            assert (monster.isBrother());
            map.put(monster.getVarbit(), monster);
        }
        return ImmutableMap.copyOf(map);
    }

    private Monster(String displayName, int combatLevel, int[] npcIDs, int varbit) {
        this.displayName = displayName;
        this.combatLevel = combatLevel;
        this.npcIDs = npcIDs;
        this.varbit = varbit;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int getCombatLevel() {
        return this.combatLevel;
    }

    public int[] getNpcIDs() {
        return this.npcIDs;
    }

    public int getVarbit() {
        return this.varbit;
    }

    static {
        $VALUES = new Monster[]{Ahrim, Dharok, Guthan, Karil, Torag, Verac, CryptRat, Bloodworm, CryptSpider, GiantCryptRat, Skeleton, GiantCryptSpider};
        brothers = ImmutableSet.of((Object)((Object)Ahrim), (Object)((Object)Dharok), (Object)((Object)Guthan), (Object)((Object)Karil), (Object)((Object)Torag), (Object)((Object)Verac), (Object[])new Monster[0]);
        cryptMonsters = ImmutableSet.of((Object)((Object)CryptRat), (Object)((Object)Bloodworm), (Object)((Object)CryptSpider), (Object)((Object)GiantCryptRat), (Object)((Object)Skeleton), (Object)((Object)GiantCryptSpider), (Object[])new Monster[0]);
        cryptMonsterByNpcID = Monster.getCryptMonstersByNpcID();
        brothersByVarbit = Monster.getBrothersByVarbit();
    }
}

