/*
 * Decompiled with CFR 0.152.
 */
package com.barrowspotential;

import com.barrowspotential.BarrowsPotentialConfig;
import com.barrowspotential.BarrowsPotentialOverlay;
import com.barrowspotential.Monster;
import com.barrowspotential.RewardPlan;
import com.barrowspotential.RewardPlanner;
import com.barrowspotential.RewardTarget;
import com.google.inject.Provides;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.npcoverlay.HighlightedNpc;
import net.runelite.client.game.npcoverlay.NpcOverlayService;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Barrows Potential", description="Highlights optimal NPCs in the Barrows Crypts", tags={"barrows", "overlay", "pve", "pvm"})
public class BarrowsPotentialPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(BarrowsPotentialPlugin.class);
    private static final int CRYPT_REGION_ID = 14231;
    private static final int PLANNER_ITERATIONS_MAX = 20;
    private static final int REWARD_POTENTIAL_MAX = 1012;
    private static final int PLUGIN_VERSION = 2;
    private static final int PLUGIN_VERSION_RELEASE = 1;
    @Inject
    private Client client;
    @Inject
    private ConfigManager configManager;
    @Inject
    private BarrowsPotentialConfig config;
    @Inject
    private BarrowsPotentialOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private NpcOverlayService npcOverlayService;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private ClientThread clientThread;
    private boolean updateQueued = false;
    private final RewardPlanner planner = new RewardPlanner();
    private final HashSet<Monster> npcTargets = new HashSet();
    private final Map<Monster, Integer> optimalNpcTargets = new HashMap<Monster, Integer>();
    private final HighlightedNpc.HighlightedNpcBuilder npcBuilder = HighlightedNpc.builder().hull(true);

    private HighlightedNpc getHighlightForNpc(NPC npc) {
        Monster monster = Monster.cryptMonsterByNpcID.get(npc.getId());
        if (monster == null) {
            assert (!Monster.cryptMonsterByNpcID.containsKey(npc.getId()));
            return null;
        }
        if (this.optimalNpcTargets.containsKey((Object)monster)) {
            return this.npcBuilder.highlightColor(this.config.optimalColor()).npc(npc).build();
        }
        if (this.npcTargets.contains((Object)monster)) {
            return this.npcBuilder.highlightColor(this.config.highlightColor()).npc(npc).build();
        }
        return null;
    }

    protected void startUp() {
        this.npcOverlayService.registerHighlighter(this::getHighlightForNpc);
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
        this.npcOverlayService.unregisterHighlighter(this::getHighlightForNpc);
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        boolean wantsUpdate;
        boolean bl = wantsUpdate = event.getVarbitId() == 463;
        if (event.getVarbitId() == 463) {
            log.debug("reward potential changed");
            wantsUpdate = true;
        } else {
            Monster monster = Monster.brothersByVarbit.get(event.getVarbitId());
            if (monster != null) {
                log.debug("killed {}", (Object)monster.getDisplayName());
                wantsUpdate = true;
            }
        }
        if (wantsUpdate) {
            this.queueUpdate();
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGGED_IN) {
            this.updateCheck();
            if (this.isInCrypt()) {
                log.debug("entered crypt");
                this.queueUpdate();
                return;
            }
            this.overlayManager.remove((Overlay)this.overlay);
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("barrowspotential")) {
            log.debug("config changed");
            this.queueUpdate();
        }
    }

    private boolean isBrotherDefeated(Monster target) {
        assert (target.isBrother());
        return this.client.getVarbitValue(target.getVarbit()) == 1;
    }

    private RewardPlan getBasePlan() {
        Set<Monster> configPlan = this.config.rewardPlan();
        HashMap<Monster, Integer> monsters = new HashMap<Monster, Integer>();
        for (Monster brother : Monster.brothers) {
            if (!configPlan.contains((Object)brother) || this.isBrotherDefeated(brother)) continue;
            monsters.put(brother, 1);
        }
        return new RewardPlan(monsters);
    }

    private Set<Monster> getMonstersToTarget() {
        HashSet<Monster> monsters = new HashSet<Monster>(this.config.rewardPlan());
        monsters.retainAll(Monster.cryptMonsters);
        return monsters;
    }

    private void queueUpdate() {
        if (!this.updateQueued) {
            this.clientThread.invokeLater(this::updatePlan);
        }
        this.updateQueued = true;
    }

    private void updatePlan() {
        boolean rewardPotentialMet;
        assert (this.client.isClientThread());
        this.updateQueued = false;
        this.npcTargets.clear();
        this.optimalNpcTargets.clear();
        this.overlayManager.remove((Overlay)this.overlay);
        this.planner.monstersToTarget = this.getMonstersToTarget();
        RewardTarget rewardTarget = this.config.rewardTarget();
        log.debug("reward target {}", (Object)rewardTarget.getDisplayName());
        int rewardPotential = this.getRewardPotential();
        int requiredPotential = rewardTarget.getMinValue();
        int targetPotential = rewardTarget.getMaxValue();
        int targetPotentialClamped = Math.min(1012, targetPotential);
        log.debug("reward potential {}", (Object)rewardPotential);
        RewardPlan basePlan = this.getBasePlan();
        int basePotential = basePlan.GetRewardPotential();
        boolean bl = rewardPotentialMet = rewardPotential + basePotential >= targetPotentialClamped;
        if (rewardPotentialMet) {
            this.npcOverlayService.rebuild();
            return;
        }
        if (this.config.highlightNpc()) {
            for (Monster monster : this.planner.monstersToTarget) {
                if (rewardPotential + basePotential + monster.getCombatLevel() > targetPotential) continue;
                this.npcTargets.add(monster);
            }
        }
        if (this.config.highlightOptimal() || this.config.overlayOptimal()) {
            int iteration;
            log.debug("planner mode {}", (Object)this.planner.mode);
            if (targetPotential < Integer.MAX_VALUE) {
                this.planner.mode = RewardPlanner.Mode.NEAREST;
                this.planner.reset(basePlan, targetPotential - rewardPotential);
            } else {
                this.planner.mode = RewardPlanner.Mode.ANY;
                this.planner.reset(basePlan, requiredPotential - rewardPotential);
            }
            RewardPlan plan = null;
            for (iteration = 0; iteration < 20 && (plan = (RewardPlan)this.planner.search()) == null; ++iteration) {
            }
            log.debug("planner ran for {} iterations", (Object)iteration);
            if (plan == null) {
                log.debug("taking partial plan");
                plan = (RewardPlan)this.planner.takeBest();
            }
            if (plan == null) {
                log.error("plan was null");
            } else {
                int planValue = plan.GetRewardPotential() + rewardPotential;
                if (planValue < requiredPotential) {
                    log.warn("plan does not meet target");
                }
                log.debug("planned reward potential: {}", (Object)planValue);
                if (this.config.highlightOptimal()) {
                    this.optimalNpcTargets.putAll(plan.monsters);
                }
                if (this.config.overlayOptimal() && !plan.equals(basePlan)) {
                    this.overlay.setOptimalMonsters(plan.monsters);
                    this.overlay.setRewardDisplay(rewardPotential, this.config.rewardTarget());
                    this.overlayManager.add((Overlay)this.overlay);
                }
                for (Map.Entry<Monster, Integer> entry : plan.monsters.entrySet()) {
                    int count = entry.getValue();
                    String name = entry.getKey().getDisplayName();
                    int value = entry.getKey().getCombatLevel() * count;
                    log.debug("x{} {} ({})", new Object[]{count, name, value});
                }
            }
        }
        this.npcOverlayService.rebuild();
    }

    public int getRegionID() {
        Player localPlayer = this.client.getLocalPlayer();
        if (localPlayer == null) {
            return 0;
        }
        return localPlayer.getWorldLocation().getRegionID();
    }

    public boolean isInCrypt() {
        return this.getRegionID() == 14231;
    }

    public int getRewardPotential() {
        int value = this.client.getVarbitValue(463);
        for (Monster brother : Monster.brothers) {
            if (!this.isBrotherDefeated(brother)) continue;
            value += 2;
        }
        return value;
    }

    private void updateCheck() {
        Integer version = (Integer)this.configManager.getRSProfileConfiguration("barrowspotential", "version", Integer.TYPE);
        if (version == null) {
            log.debug("last plugin version unknown. assuming release.");
            version = 1;
        }
        log.debug("last plugin version: {}", (Object)version);
        log.debug("latest plugin version: {}", (Object)2);
        if (version >= 2) {
            return;
        }
        log.debug("plugin version changed. queuing update message.");
        String message = "Barrows Potential has been updated. See Github page for details.";
        String chatMessage = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append("Barrows Potential has been updated. See Github page for details.").build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(chatMessage).build());
        this.configManager.setRSProfileConfiguration("barrowspotential", "version", (Object)2);
    }

    @Provides
    BarrowsPotentialConfig provideConfig(ConfigManager configManager) {
        return (BarrowsPotentialConfig)configManager.getConfig(BarrowsPotentialConfig.class);
    }
}

