/*
 * Decompiled with CFR 0.152.
 */
package com.barrowspotential;

import com.barrowspotential.Monster;
import com.barrowspotential.RewardTarget;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.Map;
import java.util.TreeMap;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.components.ProgressBarComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class BarrowsPotentialOverlay
extends Overlay {
    private static final int REWARD_POTENTIAL_MAX = 1012;
    private final Map<Monster, Integer> optimalMonsters = new TreeMap<Monster, Integer>();
    private final PanelComponent panelComponent = new PanelComponent();
    private final ProgressBarComponent progressBarComponent = new ProgressBarComponent();

    public BarrowsPotentialOverlay() {
        this.progressBarComponent.setMinimum(0L);
        this.progressBarComponent.setForegroundColor(Color.blue);
        this.progressBarComponent.setLabelDisplayMode(ProgressBarComponent.LabelDisplayMode.TEXT_ONLY);
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.setPriority(OverlayPriority.HIGHEST);
    }

    public Dimension render(Graphics2D graphics) {
        this.panelComponent.getChildren().clear();
        String panelTitle = "Optimal Barrows";
        this.panelComponent.getChildren().add(TitleComponent.builder().text(panelTitle).color(Color.white).build());
        this.panelComponent.setPreferredSize(new Dimension(150, 0));
        this.panelComponent.getChildren().add(this.progressBarComponent);
        for (Map.Entry<Monster, Integer> entry : this.optimalMonsters.entrySet()) {
            if (entry.getKey().isBrother()) continue;
            this.panelComponent.getChildren().add(LineComponent.builder().left(String.format("x%d:", entry.getValue())).right(entry.getKey().getDisplayName()).build());
        }
        return this.panelComponent.render(graphics);
    }

    public final void setOptimalMonsters(Map<Monster, Integer> monsters) {
        this.optimalMonsters.clear();
        this.optimalMonsters.putAll(monsters);
    }

    public final void setRewardDisplay(int rewardPotential, RewardTarget rewardTarget) {
        this.progressBarComponent.setMaximum((long)Math.min(1012, rewardTarget.getMaxValue()));
        this.progressBarComponent.setValue((double)rewardPotential);
        this.progressBarComponent.setCenterLabel(Integer.toString(rewardPotential));
        if (rewardPotential > rewardTarget.getMaxValue()) {
            this.progressBarComponent.setFontColor(Color.red);
        } else if (rewardPotential >= rewardTarget.getMinValue()) {
            this.progressBarComponent.setFontColor(Color.white);
        } else {
            this.progressBarComponent.setFontColor(Color.yellow);
        }
    }
}

