/*
 * Decompiled with CFR 0.152.
 */
package com.barrowspotential;

import java.util.Collection;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.PriorityQueue;

public abstract class AStar<TNode, TGoal> {
    private final PriorityQueue<TNode> _openSet;
    private final Hashtable<TNode, Integer> _gScore;
    private final Hashtable<TNode, Integer> _fScore;
    private final Hashtable<TNode, Integer> _hScore;
    private final int _gScoreInfinite;
    private final Comparator<Integer> _comparator;
    private TGoal _goal;
    private TNode _best;

    protected AStar(int gScoreInfinite, Comparator<Integer> comparer) {
        assert (comparer != null);
        this._gScoreInfinite = gScoreInfinite;
        this._comparator = comparer;
        NodeCompare nodeCompare = new NodeCompare(this);
        this._openSet = new PriorityQueue(nodeCompare);
        this._gScore = new Hashtable();
        this._fScore = new Hashtable();
        this._hScore = new Hashtable();
        this._goal = null;
        this._best = null;
    }

    protected AStar() {
        this(Integer.MAX_VALUE, Comparator.naturalOrder());
    }

    public final void reset(TNode start, TGoal goal) {
        assert (start != null);
        assert (goal != null);
        this._openSet.clear();
        this._gScore.clear();
        this._fScore.clear();
        this._hScore.clear();
        int score = this.getHScore(start, goal);
        this._openSet.add(start);
        this._gScore.put(start, 0);
        this._hScore.put(start, score);
        this._fScore.put(start, score);
        this._goal = goal;
        this._best = start;
    }

    public TNode search() {
        assert (this._goal != null);
        assert (this._best != null);
        if (this._openSet.isEmpty()) {
            return this._best;
        }
        Object current = this._openSet.remove();
        if (this.isGoal(current, this._goal)) {
            return (TNode)current;
        }
        if (this._comparator.compare(this._hScore.get(this._best), this._hScore.get(current)) > 0) {
            this._best = current;
        }
        for (Object neighbor : this.getNeighbors(current, this._goal)) {
            int gScoreTemp = this._gScore.get(current) + this.getDScore(current, neighbor);
            int gScoreOld = this._gScore.getOrDefault(neighbor, this._gScoreInfinite);
            if (this._comparator.compare(gScoreTemp, gScoreOld) >= 0) continue;
            int hScore = this.getHScore(neighbor, this._goal);
            this._gScore.put(neighbor, gScoreTemp);
            this._hScore.put(neighbor, hScore);
            this._fScore.put(neighbor, gScoreTemp + hScore);
            this._openSet.remove(neighbor);
            this._openSet.add(neighbor);
        }
        return null;
    }

    public TNode takeBest() {
        return this._best;
    }

    protected abstract int getHScore(TNode var1, TGoal var2);

    protected abstract int getDScore(TNode var1, TNode var2);

    protected abstract boolean isGoal(TNode var1, TGoal var2);

    protected abstract Collection<TNode> getNeighbors(TNode var1, TGoal var2);

    private class NodeCompare
    implements Comparator<TNode> {
        private final AStar<TNode, TGoal> _planner;

        public NodeCompare(AStar<TNode, TGoal> planner) {
            this._planner = planner;
        }

        @Override
        public int compare(TNode lhs, TNode rhs) {
            assert (this._planner._fScore.containsKey(lhs));
            assert (this._planner._fScore.containsKey(rhs));
            int l = this._planner._fScore.get(lhs);
            int r = this._planner._fScore.get(rhs);
            return this._planner._comparator.compare(l, r);
        }
    }
}

