/*
 * Decompiled with CFR 0.152.
 */
package trevor.raidreloader;

import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import trevor.raidreloader.RaidReloaderConfig;
import trevor.raidreloader.RaidReloaderPanel;

@PluginDescriptor(name="RaidReloader", description="Reloads the raid instance")
public class RaidReloaderPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(RaidReloaderPlugin.class);
    private static final int RAIDS_LOBBY_REGION = 4919;
    @Inject
    private Client client;
    @Inject
    private ClientToolbar clientToolbar;
    private RaidReloaderPanel panel;
    private NavigationButton navButton;
    private boolean buttonAttatched;

    protected void startUp() throws Exception {
        this.panel = (RaidReloaderPanel)((Object)this.injector.getInstance(RaidReloaderPanel.class));
        this.panel.init();
        BufferedImage icon = ImageUtil.getResourceStreamFromClass(((Object)((Object)this)).getClass(), (String)"/util/raidreloader.png");
        this.navButton = NavigationButton.builder().tooltip("Raid Reloader").icon(icon).priority(6).panel((PluginPanel)this.panel).build();
    }

    protected void shutDown() throws Exception {
        this.buttonAttatched = false;
        this.clientToolbar.removeNavigation(this.navButton);
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        boolean inParty;
        boolean inRaidLobby;
        boolean isInRaid = this.client.getVar(5432) == 1;
        boolean shouldShow = isInRaid | (inRaidLobby = this.client.getLocalPlayer().getWorldLocation().getRegionID() == 4919) | (inParty = this.client.getVar(1427) != -1);
        if (shouldShow != this.buttonAttatched) {
            SwingUtilities.invokeLater(() -> {
                if (shouldShow) {
                    this.clientToolbar.addNavigation(this.navButton);
                } else {
                    this.clientToolbar.removeNavigation(this.navButton);
                }
            });
            this.buttonAttatched = shouldShow;
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGIN_SCREEN) {
            SwingUtilities.invokeLater(() -> {
                this.clientToolbar.removeNavigation(this.navButton);
                this.buttonAttatched = false;
            });
        }
    }

    @Provides
    RaidReloaderConfig provideConfig(ConfigManager configManager) {
        return (RaidReloaderConfig)configManager.getConfig(RaidReloaderConfig.class);
    }
}

