/*
 * Decompiled with CFR 0.152.
 */
package com.snakemanmode;

import com.google.inject.Inject;
import com.snakemanmode.SnakemanModeAreas;
import com.snakemanmode.SnakemanModeChunk;
import com.snakemanmode.SnakemanModeConfig;
import com.snakemanmode.SnakemanModePlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.util.List;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.api.coords.WorldArea;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.worldmap.WorldMapOverlay;

public class SnakemanModeWorldMapOverlay
extends Overlay {
    private final Client client;
    private final SnakemanModeConfig config;
    private final SnakemanModePlugin plugin;
    @Inject
    private WorldMapOverlay worldMapOverlay;

    @Inject
    SnakemanModeWorldMapOverlay(Client client, SnakemanModeConfig config, SnakemanModePlugin plugin) {
        this.client = client;
        this.config = config;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.MANUAL);
        this.drawAfterLayer(WidgetInfo.WORLD_MAP_VIEW);
    }

    public Dimension render(Graphics2D graphics) {
        Widget worldMapView = this.client.getWidget(WidgetInfo.WORLD_MAP_VIEW);
        if (worldMapView == null || worldMapView.isHidden() || worldMapView.getBounds() == null) {
            return null;
        }
        Area lockedArea = this.getWorldMapClipArea(worldMapView.getBounds());
        graphics.setClip(lockedArea);
        List<SnakemanModeChunk> chunks = this.plugin.getChunks();
        boolean fillUnlocked = this.config.unlockedFillColourWorldmap().getAlpha() > 0;
        boolean fillLocked = this.config.lockedFillColourWorldmap().getAlpha() > 0;
        boolean fillFruitChunk = this.config.fruitChunkFillColourWorldmap().getAlpha() > 0;
        boolean outlineUnlocked = this.config.unlockedBorderColourWorldmap().getAlpha() > 0;
        boolean outlineFruitChunk = this.config.fruitChunkBorderColourWorldmap().getAlpha() > 0;
        Area chunkArea = new Area();
        for (SnakemanModeChunk chunk : chunks) {
            this.drawChunk(graphics, chunk.getBottomLeft(), chunk.getSize(), chunkArea, this.config.unlockedFillColourWorldmap(), this.config.unlockedBorderColourWorldmap(), chunks.indexOf(chunk));
        }
        if (this.config.drawOutlineOnly()) {
            if (fillUnlocked) {
                graphics.setColor(this.config.unlockedFillColourWorldmap());
                graphics.fill(chunkArea);
            }
            if (outlineUnlocked) {
                graphics.setColor(this.config.unlockedBorderColourWorldmap());
                graphics.draw(chunkArea);
            }
        }
        lockedArea.subtract(chunkArea);
        for (WorldArea worldArea : SnakemanModeAreas.WHITELISTED_AREA) {
            lockedArea.subtract(this.getArea(worldArea.toWorldPoint(), worldArea.getWidth(), worldArea.getHeight()));
        }
        SnakemanModeChunk fruitChunk = this.plugin.getFruitChunk();
        if (fruitChunk != null) {
            Area fruitChunkArea = new Area();
            this.drawChunk(graphics, fruitChunk.getBottomLeft(), fruitChunk.getSize(), fruitChunkArea, this.config.fruitChunkFillColourWorldmap(), this.config.fruitChunkBorderColourWorldmap(), -1);
            if (this.config.drawOutlineOnly()) {
                if (fillFruitChunk) {
                    graphics.setColor(this.config.fruitChunkFillColourWorldmap());
                    graphics.fill(fruitChunkArea);
                }
                if (outlineFruitChunk) {
                    graphics.setColor(this.config.fruitChunkBorderColourWorldmap());
                    graphics.draw(fruitChunkArea);
                }
            }
            lockedArea.subtract(fruitChunkArea);
        }
        if (fillLocked) {
            graphics.setColor(this.config.lockedFillColourWorldmap());
            graphics.fill(lockedArea);
        }
        return null;
    }

    private void drawChunk(Graphics2D graphics, WorldPoint bottomLeft, int diameter, Area outline, Color fillColour, Color borderColour, int idx) {
        if (this.client.getPlane() != bottomLeft.getPlane()) {
            return;
        }
        boolean drawFill = fillColour.getAlpha() > 0;
        boolean drawOutline = borderColour.getAlpha() > 0;
        Area chunk = this.getArea(bottomLeft, diameter, diameter);
        if (!this.config.drawOutlineOnly()) {
            if (drawFill) {
                graphics.setColor(fillColour);
                graphics.fill(chunk);
            }
            if (drawOutline) {
                graphics.setColor(borderColour);
                graphics.draw(chunk);
            }
        }
        if (this.config.showChunkNumber() && idx >= 0) {
            String s = "" + (idx + 1);
            int x = (int)(chunk.getBounds().getCenterX() - graphics.getFontMetrics().getStringBounds(s, graphics).getWidth() / 2.0 + 1.0);
            int y = (int)(chunk.getBounds().getCenterY() + graphics.getFontMetrics().getStringBounds(s, graphics).getHeight() / 2.0);
            graphics.setColor(Color.WHITE);
            graphics.drawString(s, x, y);
        }
        outline.add(chunk);
    }

    private Area getArea(WorldPoint bottomLeft, int width, int height) {
        Point start = this.worldMapOverlay.mapWorldPointToGraphicsPoint(bottomLeft.dy(height));
        Point end = this.worldMapOverlay.mapWorldPointToGraphicsPoint(bottomLeft.dx(width));
        if (start == null || end == null) {
            return new Area();
        }
        int tileSize = (int)this.client.getRenderOverview().getWorldMapZoom();
        int x = start.getX();
        int y = start.getY();
        int rectWidth = end.getX() - x;
        int rectHeight = end.getY() - y;
        return new Area(new Rectangle(x -= tileSize / 2, y += tileSize / 2, rectWidth, rectHeight));
    }

    private Area getWorldMapClipArea(Rectangle baseRectangle) {
        Widget overview = this.client.getWidget(WidgetInfo.WORLD_MAP_OVERVIEW_MAP);
        Widget surfaceSelector = this.client.getWidget(WidgetInfo.WORLD_MAP_SURFACE_SELECTOR);
        Area clipArea = new Area(baseRectangle);
        if (overview != null && !overview.isHidden()) {
            clipArea.subtract(new Area(overview.getBounds()));
        }
        if (surfaceSelector != null && !surfaceSelector.isHidden()) {
            clipArea.subtract(new Area(surfaceSelector.getBounds()));
        }
        return clipArea;
    }
}

