/*
 * Decompiled with CFR 0.152.
 */
package com.snakemanmode;

import com.google.inject.Inject;
import com.snakemanmode.SnakemanModeChunk;
import com.snakemanmode.SnakemanModeConfig;
import com.snakemanmode.SnakemanModePlugin;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.GeneralPath;
import java.util.List;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.Tile;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;

public class SnakemanModeSceneOverlay
extends Overlay {
    private static final int MAX_DRAW_DISTANCE = 32;
    private static final int LOCAL_TILE_SIZE = 128;
    private final Client client;
    private final SnakemanModeConfig config;
    private final SnakemanModePlugin plugin;

    @Inject
    SnakemanModeSceneOverlay(Client client, SnakemanModeConfig config, SnakemanModePlugin plugin) {
        this.client = client;
        this.config = config;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        SnakemanModeChunk fruitChunk;
        boolean outlineFruitChunk;
        boolean fillFruitChunk;
        List<SnakemanModeChunk> chunks = this.plugin.getChunks();
        if (chunks.isEmpty()) {
            return null;
        }
        boolean fillUnlocked = this.config.unlockedFillColourScene().getAlpha() > 0;
        boolean fillLocked = this.config.lockedFillColourScene().getAlpha() > 0;
        boolean bl = fillFruitChunk = this.config.fruitChunkFillColourScene().getAlpha() > 0;
        if (fillUnlocked || fillLocked || fillFruitChunk) {
            Tile[][] tiles;
            Tile[][] tileArray = tiles = this.client.getScene().getTiles()[this.client.getPlane()];
            int n = tileArray.length;
            for (int i = 0; i < n; ++i) {
                Tile[] tileRow;
                for (Tile tile : tileRow = tileArray[i]) {
                    Polygon tilePolygon;
                    if (tile == null || tile.getLocalLocation() == null || (tilePolygon = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)tile.getLocalLocation())) == null) continue;
                    SnakemanModeChunk chunk = new SnakemanModeChunk(this.client, tile.getWorldLocation());
                    boolean isUnlocked = chunks.contains(chunk);
                    boolean isFruitChunk = chunk.equals(this.plugin.getFruitChunk());
                    if (!isUnlocked && this.plugin.isUnlockedChunk(tile.getWorldLocation(), true)) continue;
                    if (fillUnlocked && isUnlocked) {
                        graphics.setColor(this.config.unlockedFillColourScene());
                        graphics.fill(tilePolygon);
                        continue;
                    }
                    if (fillLocked && !isUnlocked && !isFruitChunk) {
                        graphics.setColor(this.config.lockedFillColourScene());
                        graphics.fill(tilePolygon);
                        continue;
                    }
                    if (!fillFruitChunk || !isFruitChunk) continue;
                    graphics.setColor(this.config.fruitChunkFillColourScene());
                    graphics.fill(tilePolygon);
                }
            }
        }
        graphics.setStroke(new BasicStroke((float)this.config.chunkBorderWidth()));
        boolean outlineUnlocked = this.config.unlockedBorderColourScene().getAlpha() > 0;
        boolean bl2 = outlineFruitChunk = this.config.fruitChunkBorderColourScene().getAlpha() > 0;
        if (outlineUnlocked) {
            for (SnakemanModeChunk chunk : chunks) {
                List<SnakemanModeChunk> neighbourChunks = chunk.getNeighbourChunks(this.client);
                boolean[] neighbours = new boolean[]{chunks.contains(neighbourChunks.get(6)), chunks.contains(neighbourChunks.get(4)), chunks.contains(neighbourChunks.get(1)), chunks.contains(neighbourChunks.get(3))};
                this.drawChunk(graphics, chunk.getBottomLeft(), chunk.getSize(), this.config.unlockedBorderColourScene(), neighbours);
            }
        }
        if (outlineFruitChunk && (fruitChunk = this.plugin.getFruitChunk()) != null) {
            List<SnakemanModeChunk> neighbourChunks = fruitChunk.getNeighbourChunks(this.client);
            boolean[] neighbours = new boolean[]{chunks.contains(neighbourChunks.get(6)), chunks.contains(neighbourChunks.get(4)), chunks.contains(neighbourChunks.get(1)), chunks.contains(neighbourChunks.get(3))};
            this.drawChunk(graphics, fruitChunk.getBottomLeft(), fruitChunk.getSize(), this.config.fruitChunkBorderColourScene(), neighbours);
        }
        return null;
    }

    private void drawChunk(Graphics2D graphics, WorldPoint bottomLeft, int diameter, Color borderColour, boolean[] neighbours) {
        LocalPoint localPoint;
        if (this.client.getPlane() != bottomLeft.getPlane() || this.client.getLocalPlayer() == null) {
            return;
        }
        GeneralPath path = new GeneralPath();
        int startX = bottomLeft.getX();
        int startY = bottomLeft.getY();
        int z = bottomLeft.getPlane();
        WorldPoint playerLocation = this.client.getLocalPlayer().getWorldLocation();
        if (this.client.isInInstancedRegion() && (localPoint = LocalPoint.fromWorld((Client)this.client, (WorldPoint)playerLocation)) != null) {
            WorldPoint templatePlayerLocation = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)localPoint);
            startX += playerLocation.getX() - templatePlayerLocation.getX();
            startY += playerLocation.getY() - templatePlayerLocation.getY();
        }
        int x = startX;
        int y = startY;
        int[] xs = new int[4 * diameter + 1];
        int[] ys = new int[xs.length];
        for (int i = 0; i < xs.length; ++i) {
            int side;
            if (i < diameter) {
                xs[0 * diameter + i] = startX + i;
                xs[1 * diameter + i] = startX + diameter;
                xs[2 * diameter + i] = startX + diameter - i;
                xs[3 * diameter + i] = startX;
                ys[0 * diameter + i] = startY;
                ys[1 * diameter + i] = startY + i;
                ys[2 * diameter + i] = startY + diameter;
                ys[3 * diameter + i] = startY + diameter - i;
            } else if (i == diameter) {
                xs[xs.length - 1] = xs[0];
                ys[ys.length - 1] = ys[0];
            }
            boolean hasFirst = false;
            if (playerLocation.distanceTo(new WorldPoint(x, y, z)) < 32) {
                hasFirst = this.moveTo(path, x, y, z);
            }
            x = xs[i];
            y = ys[i];
            if (this.config.drawOutlineOnly() && ((side = (i - 1) / diameter) == 0 && neighbours[0] || side == 1 && neighbours[1] || side == 2 && neighbours[2] || side == 3 && neighbours[3]) || !hasFirst || playerLocation.distanceTo(new WorldPoint(x, y, z)) >= 32) continue;
            this.lineTo(path, x, y, z);
        }
        graphics.setColor(borderColour);
        graphics.draw(path);
    }

    private boolean moveTo(GeneralPath path, int x, int y, int z) {
        Point point = this.XYToPoint(x, y, z);
        if (point != null) {
            path.moveTo(point.getX(), point.getY());
            return true;
        }
        return false;
    }

    private void lineTo(GeneralPath path, int x, int y, int z) {
        Point point = this.XYToPoint(x, y, z);
        if (point != null) {
            path.lineTo(point.getX(), point.getY());
        }
    }

    private Point XYToPoint(int x, int y, int z) {
        LocalPoint localPoint = LocalPoint.fromWorld((Client)this.client, (int)x, (int)y);
        if (localPoint == null) {
            return null;
        }
        return Perspective.localToCanvas((Client)this.client, (LocalPoint)new LocalPoint(localPoint.getX() - 64, localPoint.getY() - 64), (int)z);
    }
}

