/*
 * Decompiled with CFR 0.152.
 */
package com.snakemanmode;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.snakemanmode.SnakemanModeAreas;
import com.snakemanmode.SnakemanModeChunk;
import com.snakemanmode.SnakemanModeConfig;
import com.snakemanmode.SnakemanModeInfoOverlay;
import com.snakemanmode.SnakemanModeMinimapOverlay;
import com.snakemanmode.SnakemanModeSceneOverlay;
import com.snakemanmode.SnakemanModeWorldMapOverlay;
import com.snakemanmode.SnakemanModeWorldMapPoint;
import java.awt.Color;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.Model;
import net.runelite.api.RuneLiteObject;
import net.runelite.api.Skill;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldArea;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.StatChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.JagexColors;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.worldmap.WorldMapPoint;
import net.runelite.client.ui.overlay.worldmap.WorldMapPointManager;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.ImageUtil;

@PluginDescriptor(name="Snakeman Mode", description="The snake game with chunks. Find fruits to grow bigger, or get stuck", tags={"snake", "game", "mode", "chunk", "fruit"})
public class SnakemanModePlugin
extends Plugin {
    public static final String CONFIG_GROUP = "snakemanmode";
    public static final String CONFIG_RESET_KEY = "lastUnlockXp";
    public static final int CONFIG_RESET_VALUE = 0;
    private static final String CONFIG_KEY_FRUIT_CHUNK = "fruit_chunk";
    private static final String CONFIG_KEY_CHUNKS = "chunks";
    private static final String CHUNK = ColorUtil.wrapWithColorTag((String)"Chunk", (Color)JagexColors.MENU_TARGET);
    private static final String PATH_FRUIT_IMAGE = "fruit_image.png";
    private static final String PATH_FRUIT_IMAGE_ICON = "fruit_image_icon.png";
    private static final String UNLOCK = "Unlock";
    private static final String WALK_HERE = "Walk here";
    private static final int FRUIT_MODEL_ID = 30124;
    private static final WorldPoint FIRST_FRUIT_LOCATION = new WorldPoint(3227, 3244, 0);
    private static final WorldPoint LUMBRIDGE_SPAWN_POINT = new WorldPoint(3221, 3219, 0);
    private final List<SnakemanModeChunk> chunks = new ArrayList<SnakemanModeChunk>();
    private SnakemanModeChunk fruitChunk;
    private BufferedImage fruitImage;
    private BufferedImage fruitImageIcon;
    private BufferedImage minimapSpriteFixed;
    private BufferedImage minimapSpriteResizeable;
    private Area minimapClipFixed;
    private Area minimapClipResizeable;
    private RuneLiteObject fruit;
    private long lastOverallExperience;
    private int startTickCount;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private SnakemanModeConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private Gson gson;
    @Inject
    private SnakemanModeInfoOverlay infoOverlay;
    @Inject
    private ItemManager itemManager;
    @Inject
    private SnakemanModeMinimapOverlay minimapOverlay;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private SnakemanModeSceneOverlay sceneOverlay;
    @Inject
    private SpriteManager spriteManager;
    @Inject
    private SnakemanModeWorldMapOverlay worldMapOverlay;
    @Inject
    private WorldMapPointManager worldMapPointManager;

    @Provides
    SnakemanModeConfig provideConfig(ConfigManager configManager) {
        return (SnakemanModeConfig)configManager.getConfig(SnakemanModeConfig.class);
    }

    protected void startUp() throws Exception {
        this.loadChunks();
        this.loadFruitChunk();
        this.clientThread.invokeLater(this::showFruit);
        this.overlayManager.add((Overlay)this.infoOverlay);
        this.overlayManager.add((Overlay)this.minimapOverlay);
        this.overlayManager.add((Overlay)this.sceneOverlay);
        this.overlayManager.add((Overlay)this.worldMapOverlay);
        if (this.lastOverallExperience == 0L) {
            this.lastOverallExperience = this.client.getOverallExperience();
        }
        this.startTickCount = this.client.getTickCount();
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.infoOverlay);
        this.overlayManager.remove((Overlay)this.minimapOverlay);
        this.overlayManager.remove((Overlay)this.sceneOverlay);
        this.overlayManager.remove((Overlay)this.worldMapOverlay);
        this.worldMapPointManager.removeIf(SnakemanModeWorldMapPoint.class::isInstance);
        this.clientThread.invokeLater(this::removeFruit);
        this.chunks.clear();
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        if (this.client.isKeyPressed(81) && event.getOption().equals(WALK_HERE) && event.getTarget().isEmpty() && this.getAvailableUnlocks() >= 1L && this.isNearbyChunk() && !this.isUnlockedChunk()) {
            this.client.createMenuEntry(-1).setOption(UNLOCK).setTarget(CHUNK).setParam0(event.getActionParam0()).setParam1(event.getActionParam1()).setIdentifier(event.getIdentifier()).setType(MenuAction.RUNELITE).onClick(this::unlockChunk);
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (GameState.LOGGED_IN.equals((Object)event.getGameState())) {
            this.showFruit();
            if (this.lastOverallExperience == 0L) {
                this.lastOverallExperience = this.client.getOverallExperience();
            }
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.client.getLocalPlayer() == null || this.fruitChunk == null) {
            return;
        }
        SnakemanModeChunk chunk = new SnakemanModeChunk(this.client, this.client.getLocalPlayer().getWorldLocation());
        if (this.getAvailableUnlocks() >= 1L) {
            this.addChunk(chunk);
        }
    }

    @Subscribe
    public void onStatChanged(StatChanged event) {
        if (this.client.getLocalPlayer() == null || !GameState.LOGGED_IN.equals((Object)this.client.getGameState())) {
            return;
        }
        Skill skill = event.getSkill();
        long xpGained = this.client.getOverallExperience() - this.lastOverallExperience;
        if (xpGained > 0L && this.startTickCount != this.client.getTickCount() && (Skill.AGILITY.equals((Object)skill) && !this.config.excludeAgility() || Skill.ATTACK.equals((Object)skill) && !this.config.excludeAttack() || Skill.CONSTRUCTION.equals((Object)skill) && !this.config.excludeConstruction() || Skill.COOKING.equals((Object)skill) && !this.config.excludeCooking() || Skill.CRAFTING.equals((Object)skill) && !this.config.excludeCrafting() || Skill.DEFENCE.equals((Object)skill) && !this.config.excludeDefence() || Skill.FARMING.equals((Object)skill) && !this.config.excludeFarming() || Skill.FIREMAKING.equals((Object)skill) && !this.config.excludeFiremaking() || Skill.FISHING.equals((Object)skill) && !this.config.excludeFishing() || Skill.FLETCHING.equals((Object)skill) && !this.config.excludeFletching() || Skill.HERBLORE.equals((Object)skill) && !this.config.excludeHerblore() || Skill.HITPOINTS.equals((Object)skill) && !this.config.excludeHitpoints() || Skill.HUNTER.equals((Object)skill) && !this.config.excludeHunter() || Skill.MAGIC.equals((Object)skill) && !this.config.excludeMagic() || Skill.MINING.equals((Object)skill) && !this.config.excludeMining() || Skill.PRAYER.equals((Object)skill) && !this.config.excludePrayer() || Skill.RANGED.equals((Object)skill) && !this.config.excludeRanged() || Skill.RUNECRAFT.equals((Object)skill) && !this.config.excludeRunecraft() || Skill.SLAYER.equals((Object)skill) && !this.config.excludeSlayer() || Skill.SMITHING.equals((Object)skill) && !this.config.excludeSmithing() || Skill.STRENGTH.equals((Object)skill) && !this.config.excludeStrength() || Skill.THIEVING.equals((Object)skill) && !this.config.excludeThieving() || Skill.WOODCUTTING.equals((Object)skill) && !this.config.excludeWoodcutting()) && this.chunks.contains(new SnakemanModeChunk(this.client, this.client.getLocalPlayer().getWorldLocation()))) {
            this.config.unlockProgress(this.config.unlockProgress() + xpGained);
        }
        this.lastOverallExperience = this.client.getOverallExperience();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!CONFIG_GROUP.equals(event.getGroup())) {
            return;
        }
        this.worldMapPointManager.removeIf(SnakemanModeWorldMapPoint.class::isInstance);
        if (this.config.showFruitIndicator() && this.fruitChunk != null) {
            this.worldMapPointManager.add((WorldMapPoint)new SnakemanModeWorldMapPoint(this.fruitChunk.getCenter(), this.getFruitImage()));
        }
        if (CONFIG_RESET_KEY.equals(event.getKey()) && Integer.toString(0).equals(event.getNewValue())) {
            this.lastOverallExperience = this.client.getOverallExperience();
            this.config.unlockProgress(0L);
            this.config.lastUnlockXp(this.lastOverallExperience);
            this.chunks.clear();
            this.saveChunks(null);
            this.loadChunks();
            this.removeFruit();
            this.saveFruitChunk();
            this.loadFruitChunk();
            this.showFruit();
        }
    }

    public long getXpToUnlock() {
        int unlockXp = this.config.unlockXp();
        long unlockProgress = this.config.unlockProgress();
        return Math.min(Math.max((long)unlockXp - unlockProgress, 0L), (long)this.config.unlockXp());
    }

    public long getAvailableUnlocks() {
        long unlockProgress = this.config.unlockProgress();
        int unlockXp = this.config.unlockXp();
        if (unlockXp <= 0) {
            return Integer.MAX_VALUE;
        }
        return unlockProgress / (long)unlockXp;
    }

    public BufferedImage getFruitImageIcon() {
        if (this.fruitImageIcon != null) {
            return this.fruitImageIcon;
        }
        this.fruitImageIcon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)PATH_FRUIT_IMAGE_ICON);
        return this.fruitImageIcon;
    }

    public Widget getMinimapDrawWidget() {
        if (this.client.isResized()) {
            if (this.client.getVar(4607) == 1) {
                return this.client.getWidget(WidgetInfo.RESIZABLE_MINIMAP_DRAW_AREA);
            }
            return this.client.getWidget(WidgetInfo.RESIZABLE_MINIMAP_STONES_DRAW_AREA);
        }
        return this.client.getWidget(WidgetInfo.FIXED_VIEWPORT_MINIMAP_DRAW_AREA);
    }

    public Area getMinimapClipArea() {
        if (this.client.isResized()) {
            if (this.minimapClipResizeable != null) {
                return this.minimapClipResizeable;
            }
            this.minimapClipResizeable = new Area(this.bufferedImageToPolygon(this.getMinimapSprite()));
            return this.minimapClipResizeable;
        }
        if (this.minimapClipFixed != null) {
            return this.minimapClipFixed;
        }
        this.minimapClipFixed = new Area(this.bufferedImageToPolygon(this.getMinimapSprite()));
        return this.minimapClipFixed;
    }

    public boolean isUnlockedChunk(WorldPoint worldPoint, boolean includeWhitelistedAreas) {
        if (includeWhitelistedAreas) {
            WorldArea area;
            WorldArea[] worldAreaArray = SnakemanModeAreas.WHITELISTED_AREA;
            int n = worldAreaArray.length;
            for (int i = 0; i < n && !(includeWhitelistedAreas = (area = worldAreaArray[i]).distanceTo(worldPoint) == 0); ++i) {
            }
        }
        return includeWhitelistedAreas || this.chunks.contains(new SnakemanModeChunk(this.client, worldPoint));
    }

    private void loadChunks() {
        this.chunks.clear();
        this.chunks.addAll(this.getChunkIds().stream().map(SnakemanModeChunk::new).collect(Collectors.toList()));
        if (this.chunks.isEmpty()) {
            this.chunks.add(new SnakemanModeChunk(this.client, LUMBRIDGE_SPAWN_POINT));
        }
    }

    private void saveChunks() {
        this.saveChunks(this.getChunkIds());
    }

    private void saveChunks(List<Integer> chunkIds) {
        if (chunkIds == null || chunkIds.isEmpty()) {
            this.configManager.unsetConfiguration(CONFIG_GROUP, CONFIG_KEY_CHUNKS);
            return;
        }
        this.configManager.setConfiguration(CONFIG_GROUP, CONFIG_KEY_CHUNKS, this.gson.toJson(chunkIds));
    }

    private void loadFruitChunk() {
        String json = this.configManager.getConfiguration(CONFIG_GROUP, CONFIG_KEY_FRUIT_CHUNK);
        if (Strings.isNullOrEmpty((String)json)) {
            this.fruitChunk = new SnakemanModeChunk(this.client, FIRST_FRUIT_LOCATION);
            this.saveFruitChunk();
            return;
        }
        this.fruitChunk = (SnakemanModeChunk)this.gson.fromJson(json, new TypeToken<SnakemanModeChunk>(){}.getType());
    }

    private void saveFruitChunk() {
        if (this.fruitChunk == null) {
            this.configManager.unsetConfiguration(CONFIG_GROUP, CONFIG_KEY_FRUIT_CHUNK);
            return;
        }
        this.configManager.setConfiguration(CONFIG_GROUP, CONFIG_KEY_FRUIT_CHUNK, this.gson.toJson((Object)this.fruitChunk));
    }

    private void unlockChunk(MenuEntry menuEntry) {
        if (this.client.getSelectedSceneTile() == null) {
            return;
        }
        this.addChunk(new SnakemanModeChunk(this.client, this.client.getSelectedSceneTile().getWorldLocation()));
    }

    private void addChunk(SnakemanModeChunk chunk) {
        if (this.chunks.contains(chunk)) {
            return;
        }
        this.chunks.add(0, chunk);
        this.config.unlockProgress(0L);
        this.config.lastUnlockXp(this.client.getOverallExperience());
        if (chunk.equals(this.fruitChunk)) {
            this.rollFruitChunk();
        } else {
            this.chunks.remove(this.chunks.size() - 1);
        }
        this.saveChunks();
    }

    private void showFruit() {
        if (this.client.getLocalPlayer() == null || this.fruitChunk == null) {
            return;
        }
        WorldPoint playerLocation = this.client.getLocalPlayer().getWorldLocation();
        WorldPoint fruitChunkCenter = this.fruitChunk.getCenter();
        if (this.config.showFruitIndicator()) {
            this.worldMapPointManager.removeIf(SnakemanModeWorldMapPoint.class::isInstance);
            this.worldMapPointManager.add((WorldMapPoint)new SnakemanModeWorldMapPoint(fruitChunkCenter, this.getFruitImage()));
        }
        if (playerLocation.distanceTo(fruitChunkCenter) < 104) {
            this.fruit = this.client.createRuneLiteObject();
            LocalPoint fruitLocation = LocalPoint.fromWorld((Client)this.client, (WorldPoint)fruitChunkCenter);
            if (fruitLocation == null) {
                return;
            }
            fruitLocation = new LocalPoint(fruitLocation.getX() + 64, fruitLocation.getY() + 64);
            Model model = this.client.loadModel(30124);
            if (model == null) {
                Instant loadTimeOutInstant = Instant.now().plus(Duration.ofSeconds(5L));
                this.clientThread.invoke(() -> {
                    if (Instant.now().isAfter(loadTimeOutInstant)) {
                        return true;
                    }
                    Model reloadedModel = this.client.loadModel(30124);
                    if (reloadedModel == null) {
                        return false;
                    }
                    this.fruit.setModel(reloadedModel);
                    return true;
                });
            } else {
                this.fruit.setModel(model);
            }
            this.fruit.setLocation(fruitLocation, fruitChunkCenter.getPlane());
            this.fruit.setActive(true);
        }
    }

    private void removeFruit() {
        if (this.fruit != null) {
            this.fruit.setActive(false);
        }
        this.fruit = null;
        this.fruitChunk = null;
    }

    private void rollFruitChunk() {
        int lastId = -1;
        if (this.fruitChunk != null) {
            lastId = this.fruitChunk.getId();
        }
        this.removeFruit();
        Random random = new Random();
        List<Integer> fruitChunks = this.config.onlyFreeToPlay() ? SnakemanModeAreas.FREE_TO_PLAY : SnakemanModeAreas.FRUIT_AREA;
        int idx = 0;
        int size = fruitChunks.size();
        while (++idx < Integer.MAX_VALUE) {
            SnakemanModeChunk chunk;
            int i = random.nextInt(size);
            int id = fruitChunks.get(i);
            if (id == lastId || this.config.onlyFreeToPlay() && !SnakemanModeAreas.FRUIT_AREA.contains(id) || this.chunks.contains(chunk = new SnakemanModeChunk(id))) continue;
            this.fruitChunk = chunk;
            break;
        }
        if (this.fruitChunk == null) {
            this.fruitChunk = new SnakemanModeChunk(this.client, FIRST_FRUIT_LOCATION);
        }
        this.saveFruitChunk();
        this.showFruit();
    }

    private boolean isNearbyChunk() {
        if (this.client.getSelectedSceneTile() == null || this.client.getLocalPlayer() == null) {
            return false;
        }
        SnakemanModeChunk selectedChunk = new SnakemanModeChunk(this.client, this.client.getSelectedSceneTile().getWorldLocation());
        SnakemanModeChunk playerChunk = new SnakemanModeChunk(this.client, this.client.getLocalPlayer().getWorldLocation());
        List<SnakemanModeChunk> nearbyChunks = playerChunk.getNeighbourChunks(this.client);
        nearbyChunks.add(playerChunk);
        return nearbyChunks.contains(selectedChunk) && this.chunks.contains(playerChunk);
    }

    private boolean isUnlockedChunk() {
        if (this.client.getSelectedSceneTile() == null) {
            return true;
        }
        return this.isUnlockedChunk(this.client.getSelectedSceneTile().getWorldLocation(), false);
    }

    private BufferedImage getFruitImage() {
        if (this.fruitImage != null) {
            return this.fruitImage;
        }
        this.fruitImage = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)PATH_FRUIT_IMAGE);
        return this.fruitImage;
    }

    private List<Integer> getChunkIds() {
        if (!this.chunks.isEmpty()) {
            return this.chunks.stream().map(SnakemanModeChunk::getId).collect(Collectors.toList());
        }
        String json = this.configManager.getConfiguration(CONFIG_GROUP, CONFIG_KEY_CHUNKS);
        if (Strings.isNullOrEmpty((String)json)) {
            return new ArrayList<Integer>();
        }
        return (List)this.gson.fromJson(json, new TypeToken<List<Integer>>(){}.getType());
    }

    private BufferedImage getMinimapSprite() {
        if (this.client.isResized()) {
            if (this.minimapSpriteResizeable != null) {
                return this.minimapSpriteResizeable;
            }
            this.minimapSpriteResizeable = this.spriteManager.getSprite(1178, 0);
            return this.minimapSpriteResizeable;
        }
        if (this.minimapSpriteFixed != null) {
            return this.minimapSpriteFixed;
        }
        this.minimapSpriteFixed = this.spriteManager.getSprite(1183, 0);
        return this.minimapSpriteFixed;
    }

    private Polygon bufferedImageToPolygon(BufferedImage image) {
        Color outsideColour = null;
        int width = image.getWidth();
        int height = image.getHeight();
        ArrayList<Point> points = new ArrayList<Point>();
        for (int y = 0; y < height; ++y) {
            Color previousColour = outsideColour;
            for (int x = 0; x < width; ++x) {
                int rgb = image.getRGB(x, y);
                int a = (rgb & 0xFF000000) >>> 24;
                int r = (rgb & 0xFF0000) >> 16;
                int g = (rgb & 0xFF00) >> 8;
                int b = (rgb & 0xFF) >> 0;
                Color colour = new Color(r, g, b, a);
                if (x == 0 && y == 0) {
                    outsideColour = colour;
                    previousColour = colour;
                }
                if (!colour.equals(outsideColour) && previousColour.equals(outsideColour)) {
                    points.add(new Point(x, y));
                }
                if ((colour.equals(outsideColour) || x == width - 1) && !previousColour.equals(outsideColour)) {
                    points.add(0, new Point(x, y));
                }
                previousColour = colour;
            }
        }
        int offsetX = 0;
        int offsetY = 0;
        Widget minimapDrawWidget = this.getMinimapDrawWidget();
        if (minimapDrawWidget != null) {
            offsetX = minimapDrawWidget.getBounds().x;
            offsetY = minimapDrawWidget.getBounds().y;
        }
        Polygon polygon = new Polygon();
        for (Point point : points) {
            polygon.addPoint(point.x + offsetX, point.y + offsetY);
        }
        return polygon;
    }

    List<SnakemanModeChunk> getChunks() {
        return this.chunks;
    }

    SnakemanModeChunk getFruitChunk() {
        return this.fruitChunk;
    }
}

