/*
 * Decompiled with CFR 0.152.
 */
package com.snakemanmode;

import com.google.inject.Inject;
import com.snakemanmode.SnakemanModeAreas;
import com.snakemanmode.SnakemanModeChunk;
import com.snakemanmode.SnakemanModeConfig;
import com.snakemanmode.SnakemanModePlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldArea;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.widgets.Widget;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;

public class SnakemanModeMinimapOverlay
extends Overlay {
    private static final int TILE_SIZE = 4;
    private final Client client;
    private final SnakemanModeConfig config;
    private final SnakemanModePlugin plugin;

    @Inject
    SnakemanModeMinimapOverlay(Client client, SnakemanModeConfig config, SnakemanModePlugin plugin) {
        this.client = client;
        this.config = config;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
    }

    public Dimension render(Graphics2D graphics) {
        boolean outlineFruitChunk;
        Point minimapPoint;
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics.setClip(this.plugin.getMinimapClipArea());
        SnakemanModeChunk fruitChunk = this.plugin.getFruitChunk();
        BufferedImage fruitImageIcon = this.plugin.getFruitImageIcon();
        if (fruitImageIcon != null && fruitChunk != null && (minimapPoint = this.worldToMinimap(fruitChunk.getCenter().dx(1).dy(1))) != null) {
            Point offsetPoint = new Point(minimapPoint.getX() - fruitImageIcon.getWidth() / 2, minimapPoint.getY() - fruitImageIcon.getHeight() / 2);
            graphics.drawImage((Image)fruitImageIcon, offsetPoint.getX(), offsetPoint.getY(), null);
        }
        List<SnakemanModeChunk> unlockedChunks = this.plugin.getChunks();
        List<Area> unlockAreas = this.getAreas(unlockedChunks);
        ArrayList<SnakemanModeChunk> fruitChunks = new ArrayList<SnakemanModeChunk>();
        fruitChunks.add(this.plugin.getFruitChunk());
        List<Area> fruitChunkAreas = this.getAreas(fruitChunks);
        boolean fillUnlocked = this.config.unlockedFillColourMinimap().getAlpha() > 0;
        boolean fillLocked = this.config.lockedFillColourMinimap().getAlpha() > 0;
        boolean fillFruitChunk = this.config.fruitChunkFillColourMinimap().getAlpha() > 0;
        boolean outlineUnlocked = this.config.unlockedBorderColourMinimap().getAlpha() > 0;
        boolean bl = outlineFruitChunk = this.config.fruitChunkBorderColourMinimap().getAlpha() > 0;
        if (fillLocked) {
            Iterator<Area> lockedArea = new Area(this.plugin.getMinimapDrawWidget().getBounds());
            for (WorldArea worldArea : SnakemanModeAreas.WHITELISTED_AREA) {
                ((Area)((Object)lockedArea)).subtract(this.getArea(worldArea.toWorldPoint(), worldArea.getWidth(), worldArea.getHeight()));
            }
            for (Area area : fruitChunkAreas) {
                ((Area)((Object)lockedArea)).subtract(area);
            }
            for (Area area : unlockAreas) {
                ((Area)((Object)lockedArea)).subtract(area);
            }
            graphics.setColor(this.config.lockedFillColourMinimap());
            graphics.fill((Shape)((Object)lockedArea));
        }
        if (fillFruitChunk) {
            graphics.setColor(this.config.fruitChunkFillColourMinimap());
            for (Area area : fruitChunkAreas) {
                graphics.fill(area);
            }
        }
        if (fillUnlocked) {
            graphics.setColor(this.config.unlockedFillColourMinimap());
            for (Area area : unlockAreas) {
                graphics.fill(area);
            }
        }
        if (outlineFruitChunk) {
            graphics.setColor(this.config.fruitChunkBorderColourMinimap());
            for (Area area : fruitChunkAreas) {
                graphics.draw(area);
            }
        }
        if (outlineUnlocked) {
            graphics.setColor(this.config.unlockedBorderColourMinimap());
            for (Area area : unlockAreas) {
                graphics.draw(area);
            }
        }
        if (this.config.showChunkNumber() && !this.config.drawOutlineOnly()) {
            int idx = 1;
            graphics.setColor(Color.WHITE);
            for (Area area : unlockAreas) {
                String s = "" + idx++;
                int x = (int)(area.getBounds().getCenterX() - graphics.getFontMetrics().getStringBounds(s, graphics).getWidth() / 2.0 + 1.0);
                int y = (int)(area.getBounds().getCenterY() + graphics.getFontMetrics().getStringBounds(s, graphics).getHeight() / 2.0);
                graphics.drawString(s, x, y);
            }
        }
        return null;
    }

    private List<Area> getAreas(List<SnakemanModeChunk> chunks) {
        ArrayList<Area> areas = new ArrayList<Area>();
        Area outline = new Area();
        for (SnakemanModeChunk chunk : chunks) {
            if (this.client == null) {
                System.out.println("client == null");
            }
            if (chunk == null) {
                System.out.println("chunk == null");
            } else if (chunk.getBottomLeft() == null) {
                System.out.println("bottom left == null");
            }
            if (this.client.getPlane() != chunk.getBottomLeft().getPlane()) continue;
            Area chunkArea = this.getArea(chunk.getBottomLeft(), chunk.getSize(), chunk.getSize());
            areas.add(chunkArea);
            if (!this.config.drawOutlineOnly()) continue;
            outline.add(chunkArea);
        }
        if (this.config.drawOutlineOnly()) {
            areas.clear();
            areas.add(outline);
        }
        return areas;
    }

    private Area getArea(WorldPoint bottomLeft, int width, int height) {
        Point nw = this.worldToMinimap(bottomLeft.dy(height));
        Point ne = this.worldToMinimap(bottomLeft.dx(width).dy(height));
        Point sw = this.worldToMinimap(bottomLeft);
        Point se = this.worldToMinimap(bottomLeft.dx(width));
        if (nw == null || ne == null || sw == null || se == null) {
            return new Area();
        }
        Polygon polygon = new Polygon(new int[]{sw.getX(), se.getX(), ne.getX(), nw.getX()}, new int[]{sw.getY(), se.getY(), ne.getY(), nw.getY()}, 4);
        return new Area(polygon);
    }

    private Point worldToMinimap(WorldPoint worldPoint) {
        if (this.client.getLocalPlayer() == null) {
            return null;
        }
        WorldPoint playerLocation = this.client.getLocalPlayer().getWorldLocation();
        LocalPoint localLocation = this.client.getLocalPlayer().getLocalLocation();
        LocalPoint playerLocalPoint = LocalPoint.fromWorld((Client)this.client, (WorldPoint)playerLocation);
        if (playerLocalPoint == null) {
            return null;
        }
        int offsetX = playerLocalPoint.getX() - localLocation.getX();
        int offsetY = playerLocalPoint.getY() - localLocation.getY();
        int x = (worldPoint.getX() - playerLocation.getX()) * 4 + offsetX / 32 - 2;
        int y = (worldPoint.getY() - playerLocation.getY()) * 4 + offsetY / 32 - 2 + 1;
        int angle = this.client.getMapAngle() & 0x7FF;
        int sin = (int)(65536.0 * Math.sin((double)angle * 0.0030679615757712823));
        int cos = (int)(65536.0 * Math.cos((double)angle * 0.0030679615757712823));
        Widget minimapDrawWidget = this.plugin.getMinimapDrawWidget();
        if (minimapDrawWidget == null || minimapDrawWidget.isHidden()) {
            return null;
        }
        int xx = y * sin + cos * x >> 16;
        int yy = sin * x - y * cos >> 16;
        Point loc = minimapDrawWidget.getCanvasLocation();
        int minimapX = loc.getX() + xx + minimapDrawWidget.getWidth() / 2;
        int minimapY = loc.getY() + yy + minimapDrawWidget.getHeight() / 2;
        return new Point(minimapX, minimapY);
    }
}

