/*
 * Decompiled with CFR 0.152.
 */
package com.snakemanmode;

import com.google.inject.Inject;
import com.snakemanmode.SnakemanModeConfig;
import com.snakemanmode.SnakemanModePlugin;
import java.awt.Dimension;
import java.awt.Graphics2D;
import net.runelite.api.Client;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.LineComponent;

public class SnakemanModeInfoOverlay
extends OverlayPanel {
    private static final String LABEL_LOCKED_AREA = "Go to your unlocked area!";
    private static final String LABEL_UNLOCKED = "Unlocked:";
    private static final String LABEL_XP_TO_UNLOCK = "XP to unlock:";
    private final Client client;
    private final SnakemanModeConfig config;
    private final SnakemanModePlugin plugin;

    @Inject
    SnakemanModeInfoOverlay(Client client, SnakemanModeConfig config, SnakemanModePlugin plugin) {
        this.client = client;
        this.config = config;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.setPriority(OverlayPriority.LOW);
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.config.showInfo() || this.client.getLocalPlayer() == null) {
            return null;
        }
        if (!this.plugin.isUnlockedChunk(this.client.getLocalPlayer().getWorldLocation(), false)) {
            this.panelComponent.getChildren().add(LineComponent.builder().left(LABEL_LOCKED_AREA).build());
        } else {
            this.panelComponent.getChildren().add(LineComponent.builder().left(LABEL_XP_TO_UNLOCK).right("" + this.plugin.getXpToUnlock()).build());
            this.panelComponent.getChildren().add(LineComponent.builder().left(LABEL_UNLOCKED).right("" + this.plugin.getChunks().size()).build());
        }
        return super.render(graphics);
    }
}

