/*
 * Decompiled with CFR 0.152.
 */
package com.snakemanmode;

import java.util.ArrayList;
import java.util.List;
import net.runelite.api.Client;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;

public class SnakemanModeChunk {
    private final int z;
    private final int i;
    private final int j;
    private final int x;
    private final int y;

    SnakemanModeChunk(Client client, WorldPoint worldPoint) {
        LocalPoint localPoint;
        if (client.isInInstancedRegion() && (localPoint = LocalPoint.fromWorld((Client)client, (WorldPoint)worldPoint)) != null) {
            worldPoint = WorldPoint.fromLocalInstance((Client)client, (LocalPoint)localPoint);
        }
        this.z = worldPoint.getPlane();
        this.i = worldPoint.getX() >> 6;
        this.j = worldPoint.getY() >> 6;
        this.x = worldPoint.getRegionX() / 8;
        this.y = worldPoint.getRegionY() / 8;
    }

    SnakemanModeChunk(int id) {
        this.z = id >> 21 & 3;
        this.i = id >> 14 & 0x7F;
        this.j = id >> 6 & 0xFF;
        this.x = id >> 3 & 7;
        this.y = id >> 0 & 7;
    }

    int getId() {
        return SnakemanModeChunk.getId(this.z, this.i, this.j, this.x, this.y);
    }

    static int getId(int z, int i, int j, int x, int y) {
        int Z = z << 21;
        int I = i << 14;
        int J = j << 6;
        int X = x << 3;
        int Y = y << 0;
        return Z | I | J | X | Y;
    }

    int getSize() {
        return 8;
    }

    WorldPoint getBottomLeft() {
        return new WorldPoint((this.i << 6) + this.x * this.getSize(), (this.j << 6) + this.y * this.getSize(), this.z);
    }

    WorldPoint getCenter() {
        int offset = this.getSize() / 2 - (this.getSize() % 2 == 0 ? 1 : 0);
        return this.getBottomLeft().dx(offset).dy(offset);
    }

    List<SnakemanModeChunk> getNeighbourChunks(Client client) {
        ArrayList<SnakemanModeChunk> neighbours = new ArrayList<SnakemanModeChunk>();
        int offset = this.getSize();
        neighbours.add(new SnakemanModeChunk(client, this.getBottomLeft().dx(-offset).dy(offset)));
        neighbours.add(new SnakemanModeChunk(client, this.getBottomLeft().dy(offset)));
        neighbours.add(new SnakemanModeChunk(client, this.getBottomLeft().dx(offset).dy(offset)));
        neighbours.add(new SnakemanModeChunk(client, this.getBottomLeft().dx(-offset)));
        neighbours.add(new SnakemanModeChunk(client, this.getBottomLeft().dx(offset)));
        neighbours.add(new SnakemanModeChunk(client, this.getBottomLeft().dx(-offset).dy(-offset)));
        neighbours.add(new SnakemanModeChunk(client, this.getBottomLeft().dy(-offset)));
        neighbours.add(new SnakemanModeChunk(client, this.getBottomLeft().dx(offset).dy(-offset)));
        return neighbours;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SnakemanModeChunk)) {
            return false;
        }
        SnakemanModeChunk other = (SnakemanModeChunk)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.z != other.z) {
            return false;
        }
        if (this.i != other.i) {
            return false;
        }
        if (this.j != other.j) {
            return false;
        }
        if (this.x != other.x) {
            return false;
        }
        return this.y == other.y;
    }

    protected boolean canEqual(Object other) {
        return other instanceof SnakemanModeChunk;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.z;
        result = result * 59 + this.i;
        result = result * 59 + this.j;
        result = result * 59 + this.x;
        result = result * 59 + this.y;
        return result;
    }
}

