/*
 * Decompiled with CFR 0.152.
 */
package com.peek;

import com.google.inject.Provides;
import com.peek.BossLair;
import com.peek.PeekConfig;
import com.peek.PeekInfo;
import com.peek.PeekOverlay;
import java.time.Instant;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.MenuAction;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Wilderness Boss Peek")
public class PeekPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(PeekPlugin.class);
    public static final String ACTIVITY_MSG = "You peek into the darkness and can make out some movement. There is activity inside.";
    public static final String EMPTY_MSG = "You peek into the darkness and everything seems quiet. The cave is empty.";
    @Inject
    private Client client;
    @Inject
    private PeekConfig config;
    @Inject
    private PeekOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    private BossLair currentBoss;
    private Map<BossLair, Map<Integer, PeekInfo>> bossToWorlds;
    private final Map<BossLair, GameObject> lairToObject = new EnumMap<BossLair, GameObject>(BossLair.class);

    protected void startUp() throws Exception {
        this.bossToWorlds = new EnumMap<BossLair, Map<Integer, PeekInfo>>(BossLair.class);
        for (BossLair bossLair : BossLair.values) {
            this.bossToWorlds.put(bossLair, new HashMap());
        }
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() throws Exception {
        for (BossLair bossLair : BossLair.values) {
            this.bossToWorlds.get((Object)bossLair).clear();
        }
        this.bossToWorlds.clear();
        this.bossToWorlds = null;
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (!event.getType().equals((Object)ChatMessageType.GAMEMESSAGE)) {
            return;
        }
        if (ACTIVITY_MSG.equals(event.getMessage())) {
            PeekInfo peekInfo = new PeekInfo(Instant.now().toEpochMilli(), true);
            this.bossToWorlds.get((Object)this.currentBoss).put(this.client.getWorld(), peekInfo);
            if (this.config.addActiveScoutsToChat()) {
                String msg = "W" + this.client.getWorld() + " " + this.currentBoss.name + " Active";
                this.client.addChatMessage(ChatMessageType.CONSOLE, "", msg, "");
            }
        } else if (EMPTY_MSG.equals(event.getMessage())) {
            PeekInfo peekInfo = new PeekInfo(Instant.now().toEpochMilli(), false);
            this.bossToWorlds.get((Object)this.currentBoss).put(this.client.getWorld(), peekInfo);
            if (this.config.addEmptyScoutsToChat()) {
                String msg = "W" + this.client.getWorld() + " " + this.currentBoss.name + " Empty";
                this.client.addChatMessage(ChatMessageType.CONSOLE, "", msg, "");
            }
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (!event.getMenuAction().equals((Object)MenuAction.GAME_OBJECT_SECOND_OPTION)) {
            return;
        }
        int objectId = event.getId();
        for (BossLair bossLair : BossLair.values) {
            if (bossLair.objectId != objectId) continue;
            this.currentBoss = bossLair;
            return;
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        int objId = event.getGameObject().getId();
        for (BossLair lair : BossLair.values) {
            if (objId != lair.objectId) continue;
            this.lairToObject.put(lair, event.getGameObject());
            return;
        }
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned event) {
        int objId = event.getGameObject().getId();
        for (BossLair lair : BossLair.values) {
            if (objId != lair.objectId) continue;
            this.lairToObject.remove((Object)lair);
            return;
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        GameState gameState = gameStateChanged.getGameState();
        if (gameState == GameState.LOADING) {
            this.lairToObject.clear();
        }
    }

    @Provides
    PeekConfig provideConfig(ConfigManager configManager) {
        return (PeekConfig)configManager.getConfig(PeekConfig.class);
    }

    public BossLair getCurrentBoss() {
        return this.currentBoss;
    }

    public Map<BossLair, Map<Integer, PeekInfo>> getBossToWorlds() {
        return this.bossToWorlds;
    }

    public Map<BossLair, GameObject> getLairToObject() {
        return this.lairToObject;
    }
}

