/*
 * Decompiled with CFR 0.152.
 */
package com.peek;

import com.peek.BossLair;
import com.peek.PeekConfig;
import com.peek.PeekInfo;
import com.peek.PeekPlugin;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.Instant;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.Point;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.util.ColorUtil;

public class PeekOverlay
extends Overlay {
    private static final NumberFormat TIME_FORMATTER = DecimalFormat.getInstance(Locale.US);
    private final Client client;
    private final PeekPlugin plugin;
    private final PeekConfig config;

    @Inject
    private PeekOverlay(Client client, PeekPlugin plugin, PeekConfig config) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        for (Map.Entry<BossLair, GameObject> entry : this.plugin.getLairToObject().entrySet()) {
            BossLair lair = entry.getKey();
            GameObject object = entry.getValue();
            int world = this.client.getWorld();
            PeekInfo peekInfo = this.plugin.getBossToWorlds().get((Object)lair).get(world);
            if (peekInfo == null) continue;
            double timeSince = (double)(Instant.now().toEpochMilli() - peekInfo.timeMs) / 1000.0;
            if (timeSince > (double)this.config.cutoffTime()) {
                this.plugin.getBossToWorlds().get((Object)lair).remove(world);
                continue;
            }
            if (this.client.getLocalPlayer().getWorldLocation().distanceTo2D(object.getWorldLocation()) > 25) continue;
            String s = TIME_FORMATTER.format(timeSince);
            Color color = peekInfo.active ? this.config.activityColour() : this.config.emptyColour();
            Shape clickBox = object.getClickbox();
            if (clickBox == null) continue;
            OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)clickBox, (Color)color, (Color)ColorUtil.colorWithAlpha((Color)color.brighter(), (int)40), (Stroke)new BasicStroke(1.0f));
            Point textLocation = object.getCanvasTextLocation(graphics, s, 0);
            if (textLocation == null) continue;
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)textLocation, (String)s, (Color)Color.WHITE);
        }
        return null;
    }

    static {
        ((DecimalFormat)TIME_FORMATTER).applyPattern("#0.0");
    }
}

