/*
 * Decompiled with CFR 0.152.
 */
package com.diabolickal.pickpocketinfo;

import com.diabolickal.pickpocketinfo.PickpocketInfoConfig;
import com.diabolickal.pickpocketinfo.PickpocketInfoOverlay;
import com.diabolickal.pickpocketinfo.ResetType;
import com.google.inject.Provides;
import java.time.Instant;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Pickpocket Info", description="Shows helpful pickpocketing info.", tags={"thieving", "pickpocket"}, loadWhenOutdated=true, enabledByDefault=false)
public class PickpocketInfoPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(PickpocketInfoPlugin.class);
    private float attempts;
    private float passes;
    private float percent;
    private int dodgyCharges = -1;
    private int pouchNum;
    private int brokenDodgy;
    private int totalPouches;
    private int lastPouchNum;
    private String lastTarget;
    private Instant lastPickpocket;
    private boolean hasDodgy;
    private boolean targetHasPouches;
    private int bestStreak = 0;
    private int currentStreak = 0;
    private static final Pattern DODGY_CHECK_PATTERN = Pattern.compile("Your dodgy necklace has (\\d+) charges? left\\.");
    private static final Pattern DODGY_PROTECT_PATTERN = Pattern.compile("Your dodgy necklace protects you\\..*It has (\\d+) charges? left\\.");
    private static final Pattern DODGY_BREAK_PATTERN = Pattern.compile("Your dodgy necklace protects you\\..*It then crumbles to dust\\.");
    @Inject
    private Client client;
    @Inject
    private PickpocketInfoOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ClientThread clientThread;
    @Inject
    private PickpocketInfoConfig config;

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
        this.dodgyCharges = this.config.dodgyNecklace();
        this.clientThread.invokeLater(() -> {
            ItemContainer container = this.client.getItemContainer(InventoryID.EQUIPMENT);
            ItemContainer inventory = this.client.getItemContainer(InventoryID.INVENTORY);
            if (container != null) {
                this.CheckForEquippedDodgy(container.getItems());
                this.CheckForPouches(inventory.getItems());
            }
        });
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if (chatMessage.getType() == ChatMessageType.GAMEMESSAGE || chatMessage.getType() == ChatMessageType.SPAM) {
            this.CheckDodgy(chatMessage);
            this.CheckPickpocket(chatMessage);
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getItemContainer() == this.client.getItemContainer(InventoryID.EQUIPMENT)) {
            this.CheckForEquippedDodgy(event.getItemContainer().getItems());
        }
        if (event.getItemContainer() == this.client.getItemContainer(InventoryID.INVENTORY)) {
            this.CheckForPouches(event.getItemContainer().getItems());
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGIN_SCREEN) {
            this.lastPickpocket = null;
            if (this.config.resetType() == ResetType.LOGOUT) {
                this.ResetRate();
            }
        }
    }

    @Provides
    PickpocketInfoConfig provideConfig(ConfigManager configManager) {
        return (PickpocketInfoConfig)configManager.getConfig(PickpocketInfoConfig.class);
    }

    private void ResetRate() {
        this.attempts = 0.0f;
        this.passes = 0.0f;
        this.brokenDodgy = 0;
        this.targetHasPouches = false;
        this.currentStreak = 0;
        this.bestStreak = 0;
    }

    private void CheckForEquippedDodgy(Item[] items) {
        Item Necklace = items[EquipmentInventorySlot.AMULET.getSlotIdx()];
        this.hasDodgy = Necklace.getId() == 21143;
    }

    private void CheckDodgy(ChatMessage chatMessage) {
        Matcher dodgyCheck = DODGY_CHECK_PATTERN.matcher(chatMessage.getMessage());
        Matcher dodgyProtect = DODGY_PROTECT_PATTERN.matcher(chatMessage.getMessage());
        Matcher dodgyBreak = DODGY_BREAK_PATTERN.matcher(chatMessage.getMessage());
        if (dodgyCheck.find()) {
            this.dodgyCharges = Integer.parseInt(dodgyCheck.group(1));
            this.config.dodgyNecklace(this.dodgyCharges);
        } else if (dodgyProtect.find()) {
            this.dodgyCharges = Integer.parseInt(dodgyProtect.group(1));
            this.config.dodgyNecklace(this.dodgyCharges);
        } else if (dodgyBreak.find()) {
            this.dodgyCharges = 10;
            ++this.brokenDodgy;
            this.config.dodgyNecklace(this.dodgyCharges);
        }
    }

    private void CheckForPouches(Item[] items) {
        this.pouchNum = 0;
        for (int i = 0; i < items.length; ++i) {
            String name = this.client.getItemDefinition(items[i].getId()).getName();
            if (!name.toLowerCase().equals("coin pouch")) continue;
            this.pouchNum = items[i].getQuantity();
            this.targetHasPouches = true;
            break;
        }
        if (this.pouchNum > this.lastPouchNum) {
            ++this.totalPouches;
        }
        this.lastPouchNum = this.pouchNum;
    }

    private void CheckPickpocket(ChatMessage chatMessage) {
        String msg = chatMessage.getMessage().toLowerCase();
        if (msg.contains("you attempt to pick")) {
            String pickTarget = msg.split("pick the ")[1];
            pickTarget = pickTarget.split("'s")[0];
            this.lastPickpocket = Instant.now();
            if (!pickTarget.equals(this.lastTarget)) {
                this.ResetCounter();
            }
            this.attempts += 1.0f;
            this.lastTarget = pickTarget;
        }
        if (msg.contains("you pick the")) {
            this.passes += 1.0f;
            ++this.currentStreak;
            this.bestStreak = Math.max(this.bestStreak, this.currentStreak);
            this.percent = this.passes / this.attempts * 100.0f;
        }
        if (msg.contains("you fail to pick")) {
            this.percent = this.passes / this.attempts * 100.0f;
        }
        if (msg.contains("been stunned")) {
            this.currentStreak = 0;
        }
    }

    private void ResetCounter() {
        this.attempts = 0.0f;
        this.passes = 0.0f;
        this.totalPouches = 0;
        this.brokenDodgy = 0;
        this.targetHasPouches = false;
        this.currentStreak = 0;
        this.bestStreak = 0;
    }

    public float attempts() {
        return this.attempts;
    }

    public float percent() {
        return this.percent;
    }

    public int dodgyCharges() {
        return this.dodgyCharges;
    }

    public Instant lastPickpocket() {
        return this.lastPickpocket;
    }

    public int pouchNum() {
        return this.pouchNum;
    }

    public boolean hasDodgy() {
        return this.hasDodgy;
    }

    public boolean targetHasPouches() {
        return this.targetHasPouches;
    }

    public int brokenDodgy() {
        return this.brokenDodgy;
    }

    public int totalPouches() {
        return this.totalPouches;
    }

    public int getBestStreak() {
        return this.bestStreak;
    }

    public int getCurrentStreak() {
        return this.currentStreak;
    }
}

