/*
 * Decompiled with CFR 0.152.
 */
package com.diabolickal.pickpocketinfo;

import com.diabolickal.pickpocketinfo.PickpocketInfoConfig;
import com.diabolickal.pickpocketinfo.PickpocketInfoPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.time.Duration;
import java.time.Instant;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class PickpocketInfoOverlay
extends OverlayPanel {
    private final Client client;
    private final PickpocketInfoPlugin plugin;
    private final PickpocketInfoConfig config;

    @Inject
    PickpocketInfoOverlay(Client client, PickpocketInfoPlugin plugin, PickpocketInfoConfig config) {
        super((Plugin)plugin);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "PP overlay"));
    }

    public Dimension render(Graphics2D graphics) {
        Object charges = "?";
        if (this.plugin.dodgyCharges() >= 0) {
            charges = "" + this.plugin.dodgyCharges();
        }
        if (!this.plugin.hasDodgy()) {
            charges = "";
        }
        if (this.plugin.lastPickpocket() != null && (this.config.overlayDuration() < 1 || Duration.between(this.plugin.lastPickpocket(), Instant.now()).getSeconds() < (long)this.config.overlayDuration())) {
            this.panelComponent.getChildren().add(TitleComponent.builder().text("Pickpocket Info").color(Color.WHITE).build());
            this.panelComponent.getChildren().add(LineComponent.builder().left("Rate").right(String.format("%.1f", Float.valueOf(this.plugin.percent())) + "%").build());
            if (this.config.showSessionTotal()) {
                this.panelComponent.getChildren().add(LineComponent.builder().left("Attempts").right(String.format("%.0f", Float.valueOf(this.plugin.attempts()))).build());
            }
            if (this.config.showDodgy()) {
                this.panelComponent.getChildren().add(LineComponent.builder().left(!this.plugin.hasDodgy() ? "No Dodgy" : "Dodgy Charges").leftColor(this.plugin.dodgyCharges() <= this.config.warnThreshold() || !this.plugin.hasDodgy() ? Color.RED : Color.WHITE).right((String)charges).rightColor(this.plugin.dodgyCharges() <= this.config.warnThreshold() && this.plugin.hasDodgy() ? Color.RED : Color.WHITE).build());
            }
            if (this.config.showPouches() && this.plugin.targetHasPouches()) {
                int maxNumberOfPouches = this.client.getVarbitValue(4461) > 0 ? 140 : (this.client.getVarbitValue(4460) > 0 ? 84 : (this.client.getVarbitValue(4459) > 0 ? 56 : 28));
                Color pouchColor = this.plugin.pouchNum() >= maxNumberOfPouches - 1 ? Color.RED : Color.WHITE;
                this.panelComponent.getChildren().add(LineComponent.builder().left("Pouches").leftColor(pouchColor).right("" + this.plugin.pouchNum()).rightColor(pouchColor).build());
            }
            if (this.config.showBrokenDodgys()) {
                this.panelComponent.getChildren().add(LineComponent.builder().left("Broken Dodgies").right(String.format("%d", this.plugin.brokenDodgy())).build());
            }
            if (this.config.showPouchesTotal()) {
                this.panelComponent.getChildren().add(LineComponent.builder().left("Total Pouches").right(String.format("%d", this.plugin.totalPouches())).build());
            }
            if (this.config.showBestStreak()) {
                this.panelComponent.getChildren().add(LineComponent.builder().left("Best Streak").right(String.format("%d", this.plugin.getBestStreak())).build());
            }
            if (this.config.showCurrentStreak()) {
                this.panelComponent.getChildren().add(LineComponent.builder().left("Current Streak").right(String.format("%d", this.plugin.getCurrentStreak())).build());
            }
        }
        return super.render(graphics);
    }
}

