/*
 * Decompiled with CFR 0.152.
 */
package io.banna.rl.item;

import io.banna.rl.item.ItemNicknames;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.ItemComposition;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.ItemManager;

@Singleton
public class ItemUtil {
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ItemManager itemManager;

    public void getId(String searchString, Consumer<Integer> callback) {
        if (searchString == null || "".equals(searchString)) {
            return;
        }
        int nicknameId = ItemNicknames.checkNickname(searchString);
        if (nicknameId != -1) {
            callback.accept(nicknameId);
        }
        if (this.isItemId(searchString)) {
            callback.accept(Integer.parseInt(searchString));
        } else {
            this.clientThread.invokeLater(() -> {
                for (int i = 0; i < this.client.getItemCount(); ++i) {
                    ItemComposition itemComposition = this.itemManager.getItemComposition(this.itemManager.canonicalize(i));
                    if (!itemComposition.getMembersName().equalsIgnoreCase(searchString)) continue;
                    callback.accept(i);
                    return;
                }
                callback.accept(-1);
            });
        }
    }

    private boolean isItemId(String input) {
        return input.matches("\\d+");
    }
}

