/*
 * Decompiled with CFR 0.152.
 */
package io.banna.rl;

import com.google.common.base.Strings;
import com.google.common.util.concurrent.Runnables;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Provides;
import io.banna.rl.NpcLabelsConfig;
import io.banna.rl.NpcLabelsOverlay;
import io.banna.rl.domain.NpcLabel;
import io.banna.rl.item.ItemUtil;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.NPC;
import net.runelite.api.events.CommandExecuted;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.chatbox.ChatboxPanelManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.components.colorpicker.ColorPickerManager;
import net.runelite.client.ui.components.colorpicker.RuneliteColorPicker;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="NPC Labels")
public class NpcLabelsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(NpcLabelsPlugin.class);
    private static final String LABEL = "Label";
    private static final String MANAGE_LABEL = "Manage-Label";
    private static final String SET_LABEL_TEXT = "Set Label Text";
    private static final String SET_LABEL_ICON = "Set Label Item";
    private static final String SET_LABEL_COLOR = "Set Label Color";
    private static final String CLEAR_LABEL = "Clear Label";
    private static final String LABEL_CONFIG_PREFIX = "npc_";
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private NpcLabelsConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private Gson gson;
    @Inject
    private NpcLabelsOverlay overlay;
    @Inject
    private ChatboxPanelManager chatboxPanelManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ColorPickerManager colorPickerManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ItemUtil itemUtil;
    private Map<Integer, NpcLabel> labelMap = new HashMap<Integer, NpcLabel>();
    private List<NPC> relevantNpcs = new ArrayList<NPC>();

    protected void startUp() throws Exception {
        log.info("NPC Labels started!");
        this.overlayManager.add((Overlay)this.overlay);
        this.rebuildNpcList();
    }

    protected void shutDown() throws Exception {
        log.info("NPC Labels stopped!");
        this.save();
        this.relevantNpcs.clear();
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Provides
    NpcLabelsConfig provideConfig(ConfigManager configManager) {
        return (NpcLabelsConfig)configManager.getConfig(NpcLabelsConfig.class);
    }

    @Subscribe
    public void onCommandExecuted(CommandExecuted commandExecuted) {
        if (commandExecuted.getCommand().equals("export-npc-labels")) {
            String exportString = this.getExportJson();
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(exportString), null);
            this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Exported all NPC labels to clipboard", null);
        } else if (commandExecuted.getCommand().equals("import-npc-labels")) {
            List importLabels;
            String clipboardText;
            try {
                clipboardText = Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor).toString();
            }
            catch (UnsupportedFlavorException | IOException ex) {
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Error reading clipboard contents", null);
                log.warn("error reading clipboard", (Throwable)ex);
                return;
            }
            log.debug("Clipboard contents: {}", (Object)clipboardText);
            if (Strings.isNullOrEmpty((String)clipboardText)) {
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "You don't have any NPC labels in your clipboard", null);
                return;
            }
            try {
                importLabels = (List)this.gson.fromJson(clipboardText, new TypeToken<List<NpcLabel>>(){}.getType());
            }
            catch (JsonSyntaxException e) {
                log.debug("Malformed JSON for clipboard import", (Throwable)e);
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "You don't have any NPC labels in your clipboard", null);
                return;
            }
            if (importLabels.isEmpty()) {
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "You don't have any NPC labels in your clipboard", null);
                return;
            }
            this.chatboxPanelManager.openTextMenuInput("Are you sure you want to import " + importLabels.size() + " NPC labels?").option("Yes", () -> this.importLabels(importLabels)).option("No", Runnables.doNothing()).build();
        }
    }

    private void importLabels(List<NpcLabel> importLabels) {
        for (NpcLabel label : importLabels) {
            this.labelMap.put(label.getNpcId(), label);
        }
        this.save();
        this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Successfully imported " + importLabels.size() + " NPC labels", null);
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        MenuEntry menuEntry = event.getMenuEntry();
        MenuAction menuAction = menuEntry.getType();
        NPC npc = menuEntry.getNpc();
        if (npc == null) {
            return;
        }
        if (menuAction == MenuAction.EXAMINE_NPC && this.client.isKeyPressed(81)) {
            if (npc.getName() == null) {
                return;
            }
            int idx = -1;
            if (this.getNpcLabel(npc) == null) {
                this.client.createMenuEntry(idx--).setOption(LABEL).setTarget(event.getTarget()).setIdentifier(event.getIdentifier()).setType(MenuAction.RUNELITE).onClick(this::label);
            } else {
                MenuEntry menuManage = this.client.createMenuEntry(idx--).setOption(MANAGE_LABEL).setTarget(event.getTarget()).setType(MenuAction.RUNELITE_SUBMENU);
                this.client.createMenuEntry(idx--).setOption(SET_LABEL_TEXT).setTarget(event.getTarget()).setIdentifier(event.getIdentifier()).setType(MenuAction.RUNELITE).setParent(menuManage).onClick(this::setLabelText);
                this.client.createMenuEntry(idx--).setOption(SET_LABEL_ICON).setTarget(event.getTarget()).setIdentifier(event.getIdentifier()).setType(MenuAction.RUNELITE).setParent(menuManage).onClick(this::setLabelIcon);
                this.client.createMenuEntry(idx--).setOption(SET_LABEL_COLOR).setTarget(event.getTarget()).setIdentifier(event.getIdentifier()).setType(MenuAction.RUNELITE).setParent(menuManage).onClick(this::setLabelColor);
                this.client.createMenuEntry(idx--).setOption(CLEAR_LABEL).setTarget(event.getTarget()).setIdentifier(event.getIdentifier()).setType(MenuAction.RUNELITE).setParent(menuManage).onClick(this::clearLabel);
            }
        }
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned npcSpawned) {
        NPC npc = npcSpawned.getNpc();
        if (this.getNpcLabel(npc) != null && !this.exclude(npc)) {
            this.relevantNpcs.add(npc);
        }
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned npcDespawned) {
        NPC npc = npcDespawned.getNpc();
        this.relevantNpcs.remove(npc);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if ("npc-labels".equals(configChanged.getGroup())) {
            this.rebuildNpcList();
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGIN_SCREEN || gameStateChanged.getGameState() == GameState.HOPPING) {
            this.relevantNpcs.clear();
        }
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            this.rebuildNpcList();
        }
    }

    private void rebuildNpcList() {
        this.relevantNpcs.clear();
        if (this.client.getGameState() != GameState.LOGGED_IN && this.client.getGameState() != GameState.LOADING) {
            return;
        }
        for (NPC npc : this.client.getNpcs()) {
            if (this.getNpcLabel(npc) == null || this.exclude(npc)) continue;
            this.relevantNpcs.add(npc);
        }
    }

    private void label(MenuEntry entry) {
        int id = entry.getIdentifier();
        NPC[] cachedNPCs = this.client.getCachedNPCs();
        NPC npc = cachedNPCs[id];
        log.info("Clicked label on {}", (Object)npc.getName());
        NpcLabel existing = this.getNpcLabel(npc);
        String existingValue = "";
        if (existing != null) {
            existingValue = existing.getLabel();
        }
        this.chatboxPanelManager.openTextInput("NPC label").value(existingValue).onDone(input -> {
            input = Strings.emptyToNull((String)input);
            log.info("Adding label [{}] to NPC [{}]", input, (Object)npc.getName());
            NpcLabel label = new NpcLabel();
            label.setNpcId(npc.getId());
            label.setNpcName(npc.getName());
            label.setLabel((String)input);
            label.setColor(Color.GREEN);
            this.labelMap.put(npc.getId(), label);
            this.save();
            this.rebuildNpcList();
        }).build();
    }

    private void setLabelText(MenuEntry entry) {
        int id = entry.getIdentifier();
        NPC[] cachedNPCs = this.client.getCachedNPCs();
        NPC npc = cachedNPCs[id];
        NpcLabel existing = this.getNpcLabel(npc);
        if (existing == null) {
            log.info("Not sure how you got here!");
            return;
        }
        this.chatboxPanelManager.openTextInput("NPC label").value(existing.getLabel() == null ? "" : existing.getLabel()).onDone(input -> {
            input = Strings.emptyToNull((String)input);
            log.info("Adding label [{}] to NPC [{}]", input, (Object)npc.getName());
            existing.setLabel((String)input);
            existing.setColor(Color.GREEN);
            this.save();
        }).build();
    }

    private void setLabelIcon(MenuEntry entry) {
        int id = entry.getIdentifier();
        NPC[] cachedNPCs = this.client.getCachedNPCs();
        NPC npc = cachedNPCs[id];
        NpcLabel existing = this.getNpcLabel(npc);
        if (existing == null) {
            log.info("Not sure how you got here!");
            return;
        }
        String existingValue = "";
        if (existing.getItemIconName() != null) {
            existingValue = existing.getItemIconName();
        }
        this.chatboxPanelManager.openTextInput("NPC label icon item ID").value(existingValue).onDone(input -> {
            if ((input = Strings.emptyToNull((String)input)) != null) {
                String finalInput = input;
                this.clientThread.invoke(() -> this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Searching for item with name " + finalInput, null));
                this.itemUtil.getId((String)input, itemId -> this.clientThread.invokeLater(() -> {
                    if (itemId == -1) {
                        this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Failed to find item with name " + finalInput + ", have not updated the icon for " + npc.getName(), null);
                    } else {
                        String itemName = this.itemManager.getItemComposition(itemId.intValue()).getMembersName();
                        this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Found item with name " + itemName + ", set as icon for " + npc.getName(), null);
                        existing.setItemIconId((Integer)itemId);
                        existing.setItemIconName(itemName);
                        this.save();
                    }
                }));
            }
        }).build();
    }

    private void setLabelColor(MenuEntry entry) {
        int id = entry.getIdentifier();
        NPC[] cachedNPCs = this.client.getCachedNPCs();
        NPC npc = cachedNPCs[id];
        NpcLabel existing = this.getNpcLabel(npc);
        Color color = existing.getColor();
        SwingUtilities.invokeLater(() -> {
            RuneliteColorPicker colorPicker = this.colorPickerManager.create(SwingUtilities.windowForComponent((Applet)this.client), color, "NPC Label color", false);
            colorPicker.setOnClose(c -> {
                existing.setColor((Color)c);
                this.save();
            });
            colorPicker.setVisible(true);
        });
    }

    private void clearLabel(MenuEntry entry) {
        int id = entry.getIdentifier();
        NPC[] cachedNPCs = this.client.getCachedNPCs();
        NPC npc = cachedNPCs[id];
        if (this.config.confirmClear()) {
            this.chatboxPanelManager.openTextMenuInput("Are you sure you want to clear the label for " + npc.getName()).option("Yes", () -> {
                this.clearConfig(npc.getId());
                this.labelMap.remove(npc.getId());
                this.save();
            }).option("No", Runnables.doNothing()).build();
        } else {
            this.clearConfig(npc.getId());
            this.labelMap.remove(npc.getId());
            this.save();
        }
    }

    private void save() {
        for (Map.Entry<Integer, NpcLabel> entry : this.labelMap.entrySet()) {
            String labelJson = this.gson.toJson((Object)entry.getValue());
            this.configManager.setConfiguration("npc-labels", LABEL_CONFIG_PREFIX + entry.getKey(), labelJson);
        }
    }

    public String getExportJson() {
        return this.gson.toJson(this.configManager.getConfigurationKeys("npc-labels").stream().map(c -> {
            String[] wholeKeyParts = c.split("\\.");
            return wholeKeyParts[wholeKeyParts.length - 1];
        }).filter(key -> key.startsWith(LABEL_CONFIG_PREFIX)).map(key -> {
            String labelJson = this.configManager.getConfiguration("npc-labels", key);
            if (labelJson == null || "".equals(labelJson)) {
                return null;
            }
            return (NpcLabel)this.gson.fromJson(labelJson, NpcLabel.class);
        }).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    private void clearConfig(int npcId) {
        this.configManager.unsetConfiguration("npc-labels", LABEL_CONFIG_PREFIX + npcId);
    }

    public NpcLabel getNpcLabel(NPC npc) {
        if (this.labelMap.containsKey(npc.getId())) {
            return this.labelMap.get(npc.getId());
        }
        String labelJson = this.configManager.getConfiguration("npc-labels", LABEL_CONFIG_PREFIX + npc.getId());
        if (labelJson != null) {
            NpcLabel label = (NpcLabel)this.gson.fromJson(labelJson, NpcLabel.class);
            this.labelMap.put(npc.getId(), label);
            return label;
        }
        return null;
    }

    public boolean exclude(NPC npc) {
        return npc == null || npc.getName() == null || npc.getName().isEmpty() || "null".equals(npc.getName());
    }

    public List<NPC> getRelevantNpcs() {
        return this.relevantNpcs;
    }
}

