/*
 * Decompiled with CFR 0.152.
 */
package io.banna.rl;

import io.banna.rl.NpcLabelsConfig;
import io.banna.rl.NpcLabelsPlugin;
import io.banna.rl.domain.NpcLabel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.NPC;
import net.runelite.api.Point;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.util.AsyncBufferedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NpcLabelsOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(NpcLabelsOverlay.class);
    private final NpcLabelsPlugin plugin;
    private final NpcLabelsConfig config;
    private final ItemManager itemManager;

    @Inject
    public NpcLabelsOverlay(NpcLabelsPlugin plugin, NpcLabelsConfig config, ItemManager itemManager) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.plugin = plugin;
        this.config = config;
        this.itemManager = itemManager;
    }

    public Dimension render(Graphics2D graphics) {
        if (this.config.showOverlay()) {
            this.plugin.getRelevantNpcs().forEach(npc -> this.renderLabel((NPC)npc, graphics));
        }
        return null;
    }

    private void renderLabel(NPC npc, Graphics2D graphics) {
        if (npc.isDead()) {
            return;
        }
        NpcLabel label = this.plugin.getNpcLabel(npc);
        if (label != null) {
            Point textCanvasLocation;
            if (label.getLabel() != null && (textCanvasLocation = npc.getCanvasTextLocation(graphics, label.getLabel(), this.config.labelHeight())) != null) {
                Point dropShadow = new Point(textCanvasLocation.getX() + 1, textCanvasLocation.getY() + 1);
                if (this.config.dropShadow()) {
                    OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)dropShadow, (String)label.getLabel(), (Color)Color.BLACK);
                }
                OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)textCanvasLocation, (String)label.getLabel(), (Color)label.getColor());
            }
            if (label.getItemIconId() != null) {
                AsyncBufferedImage itemIcon = this.itemManager.getImage(label.getItemIconId().intValue());
                BufferedImage bufferedItemIcon = NpcLabelsOverlay.toBufferedImage((Image)itemIcon);
                Point imageCanvasLocation = npc.getCanvasImageLocation(bufferedItemIcon, this.config.iconHeight());
                OverlayUtil.renderImageLocation((Graphics2D)graphics, (Point)imageCanvasLocation, (BufferedImage)bufferedItemIcon);
            }
        }
    }

    public static BufferedImage toBufferedImage(Image img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        BufferedImage bimage = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D bGr = bimage.createGraphics();
        bGr.drawImage(img, 0, 0, null);
        bGr.dispose();
        return bimage;
    }
}

