/*
 * Decompiled with CFR 0.152.
 */
package com.boneluck;

import com.boneluck.BoneLuckConfig;
import com.boneluck.BoneLuckOverlay;
import com.google.inject.Provides;
import java.time.Instant;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.Skill;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.StatChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Bone Luck", description="Shows how lucky you've gotten offering your bones.", tags={"prayer", "bone", "luck"})
public class BoneLuckPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(BoneLuckPlugin.class);
    int CHAOS_ALTAR_REGION = 11835;
    Skill PRAYER = Skill.PRAYER;
    private float used;
    private float saved;
    private float percent;
    private float actualXpGained;
    private float expectedXpGained;
    private Instant lastUsedBone;
    private boolean inRegion;
    private boolean wasInRegion;
    private int previousXp;
    private static final Pattern BONE_SAVED_CHECK = Pattern.compile("The Dark Lord spares your sacrifice but still rewards you for your efforts\\.");
    @Inject
    private Client client;
    @Inject
    private BoneLuckOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ClientThread clientThread;
    @Inject
    private BoneLuckConfig config;

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
        this.resetRate();
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if (chatMessage.getType() == ChatMessageType.GAMEMESSAGE || chatMessage.getType() == ChatMessageType.SPAM) {
            this.checkSaved(chatMessage);
            this.calculatePercent();
        }
    }

    @Subscribe
    public void onStatChanged(StatChanged statChanged) {
        Skill skill = statChanged.getSkill();
        int currentXp = statChanged.getXp();
        if (skill == this.PRAYER && this.previousXp == 0) {
            this.previousXp = currentXp;
            return;
        }
        if (skill == this.PRAYER && this.inRegion && currentXp > this.previousXp) {
            this.actualXpGained += (float)(currentXp - this.previousXp);
            this.lastUsedBone = Instant.now();
            this.used += 1.0f;
            this.previousXp = currentXp;
            this.calculatePercent();
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.client.getLocalPlayer().getWorldLocation().getRegionID() != this.CHAOS_ALTAR_REGION) {
            if (this.inRegion) {
                this.inRegion = false;
            }
            return;
        }
        if (!this.inRegion) {
            this.wasInRegion = true;
            this.inRegion = true;
        }
    }

    @Provides
    BoneLuckConfig provideConfig(ConfigManager configManager) {
        return (BoneLuckConfig)configManager.getConfig(BoneLuckConfig.class);
    }

    private void resetRate() {
        this.used = 0.0f;
        this.saved = 0.0f;
        this.percent = 0.0f;
        this.actualXpGained = 0.0f;
        this.expectedXpGained = 0.0f;
    }

    private void checkSaved(ChatMessage chatMessage) {
        Matcher savedCheck = BONE_SAVED_CHECK.matcher(chatMessage.getMessage());
        if (savedCheck.find()) {
            this.saved += 1.0f;
        }
    }

    private void calculatePercent() {
        this.percent = this.saved / this.used * 100.0f;
        float bonesReallyUsed = this.used - this.saved;
        float avgXpPerBone = this.actualXpGained / this.used;
        this.expectedXpGained = bonesReallyUsed * 2.0f * avgXpPerBone;
    }

    public float getSaved() {
        return this.saved;
    }

    public float getUsed() {
        return this.used;
    }

    public float getPercent() {
        return this.percent;
    }

    public float getActualXpGained() {
        return this.actualXpGained;
    }

    public float getExpectedXpGained() {
        return this.expectedXpGained;
    }

    public Instant getLastUsedBone() {
        return this.lastUsedBone;
    }

    public boolean isInRegion() {
        return this.inRegion;
    }

    public boolean wasInRegion() {
        return this.wasInRegion;
    }
}

