/*
 * Decompiled with CFR 0.152.
 */
package com.boneluck;

import com.boneluck.BoneLuckConfig;
import com.boneluck.BoneLuckPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.time.Duration;
import java.time.Instant;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class BoneLuckOverlay
extends OverlayPanel {
    private final Client client;
    private final BoneLuckPlugin plugin;
    private final BoneLuckConfig config;

    @Inject
    BoneLuckOverlay(Client client, BoneLuckPlugin plugin, BoneLuckConfig config) {
        super((Plugin)plugin);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "PP overlay"));
    }

    public Dimension render(Graphics2D graphics) {
        if (this.plugin.getLastUsedBone() != null && this.plugin.wasInRegion() && (this.config.overlayDuration() < 1 || Duration.between(this.plugin.getLastUsedBone(), Instant.now()).getSeconds() < (long)this.config.overlayDuration())) {
            this.panelComponent.getChildren().add(TitleComponent.builder().text("Bone Luck info").color(Color.WHITE).build());
            this.panelComponent.getChildren().add(LineComponent.builder().left("Bones Used").right(String.format("%.0f", Float.valueOf(this.plugin.getUsed()))).build());
            this.panelComponent.getChildren().add(LineComponent.builder().left("Bones Saved").right(String.format("%.0f", Float.valueOf(this.plugin.getSaved()))).build());
            this.panelComponent.getChildren().add(LineComponent.builder().left("% Saved").right(String.format("%.1f", Float.valueOf(this.plugin.getPercent())) + "%").build());
            if (this.config.showActualXpGained()) {
                this.panelComponent.getChildren().add(LineComponent.builder().left("XP Gained").right(String.format("%.0f", Float.valueOf(this.plugin.getActualXpGained()))).build());
            }
            if (this.config.showExpectedXpGained()) {
                this.panelComponent.getChildren().add(LineComponent.builder().left("Expected XP").right(String.format("%.0f", Float.valueOf(this.plugin.getExpectedXpGained()))).build());
            }
        }
        return super.render(graphics);
    }
}

