/*
 * Decompiled with CFR 0.152.
 */
package com.weather3d.conditions;

import com.weather3d.WeatherObject;
import com.weather3d.audio.SoundPlayer;
import com.weather3d.conditions.Weather;
import java.util.ArrayList;

public class WeatherManager {
    private Weather weatherType;
    private SoundPlayer[] soundPlayers;
    private int soundPlayerTimer;
    private ArrayList<WeatherObject> weatherObjArray;
    private int startRotation;
    private boolean isFading;

    public SoundPlayer getPrimarySoundPlayer() {
        if (this.soundPlayers[1].isPrimarySoundPlayer()) {
            this.soundPlayers[1].setPrimarySoundPlayer(true);
            this.soundPlayers[0].setPrimarySoundPlayer(false);
            return this.soundPlayers[1];
        }
        this.soundPlayers[0].setPrimarySoundPlayer(true);
        this.soundPlayers[1].setPrimarySoundPlayer(false);
        return this.soundPlayers[0];
    }

    public void switchSoundPlayerPriority() {
        SoundPlayer primSoundPlayer = this.getPrimarySoundPlayer();
        SoundPlayer secSoundPlayer = primSoundPlayer == this.soundPlayers[0] ? this.soundPlayers[1] : this.soundPlayers[0];
        primSoundPlayer.setPrimarySoundPlayer(false);
        secSoundPlayer.setPrimarySoundPlayer(true);
    }

    public void stopManagerSoundPlayers() {
        this.setSoundPlayerTimer(0);
        for (SoundPlayer soundPlayer : this.soundPlayers) {
            soundPlayer.stopClip();
        }
    }

    public Weather getWeatherType() {
        return this.weatherType;
    }

    public SoundPlayer[] getSoundPlayers() {
        return this.soundPlayers;
    }

    public int getSoundPlayerTimer() {
        return this.soundPlayerTimer;
    }

    public ArrayList<WeatherObject> getWeatherObjArray() {
        return this.weatherObjArray;
    }

    public int getStartRotation() {
        return this.startRotation;
    }

    public boolean isFading() {
        return this.isFading;
    }

    public void setWeatherType(Weather weatherType) {
        this.weatherType = weatherType;
    }

    public void setSoundPlayers(SoundPlayer[] soundPlayers) {
        this.soundPlayers = soundPlayers;
    }

    public void setSoundPlayerTimer(int soundPlayerTimer) {
        this.soundPlayerTimer = soundPlayerTimer;
    }

    public void setWeatherObjArray(ArrayList<WeatherObject> weatherObjArray) {
        this.weatherObjArray = weatherObjArray;
    }

    public void setStartRotation(int startRotation) {
        this.startRotation = startRotation;
    }

    public void setFading(boolean isFading) {
        this.isFading = isFading;
    }

    public WeatherManager(Weather weatherType, SoundPlayer[] soundPlayers, int soundPlayerTimer, ArrayList<WeatherObject> weatherObjArray, int startRotation, boolean isFading) {
        this.weatherType = weatherType;
        this.soundPlayers = soundPlayers;
        this.soundPlayerTimer = soundPlayerTimer;
        this.weatherObjArray = weatherObjArray;
        this.startRotation = startRotation;
        this.isFading = isFading;
    }
}

