/*
 * Decompiled with CFR 0.152.
 */
package com.weather3d.audio;

import com.weather3d.CyclesConfig;
import com.weather3d.CyclesPlugin;
import com.weather3d.audio.SoundEffect;
import jaco.mp3.player.MP3Player;
import java.io.File;
import java.net.URL;
import javax.inject.Inject;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoundPlayer {
    private static final Logger log = LoggerFactory.getLogger(SoundPlayer.class);
    @Inject
    private CyclesPlugin plugin;
    @Inject
    private CyclesConfig config;
    @Inject
    private SourceDataLine sourceDataLine;
    @Inject
    private AudioSystem audioSystem;
    private boolean isFading = false;
    private boolean primarySoundPlayer = false;
    private int timer = 0;
    private SoundEffect currentTrack;
    private boolean ambienceError = false;
    private final MP3Player trackPlayer = new MP3Player();
    private Thread handlePlayThread = null;
    private Thread volumeChangeHandler = null;

    public void playClip(SoundEffect soundEffect) {
        this.setTimer(0);
        AudioFormat format = new AudioFormat(1000.0f, 16, 2, true, false);
        try {
            AudioSystem.getLine(new DataLine.Info(SourceDataLine.class, format));
        }
        catch (Exception e) {
            return;
        }
        this.trackPlayer.getPlayList().clear();
        this.handlePlayThread = new Thread(() -> {
            try {
                String soundLink = soundEffect.getSoundFile();
                if (soundLink.toLowerCase().startsWith("http")) {
                    this.trackPlayer.addToPlayList(new URL(soundLink));
                } else {
                    this.trackPlayer.addToPlayList(new File(soundLink));
                }
                this.trackPlayer.play();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        this.currentTrack = soundEffect;
        this.handlePlayThread.start();
    }

    public void stopClip() {
        log.debug(this.currentTrack + " SoundPlayer STOPPING!");
        this.trackPlayer.stop();
        this.setTimer(0);
    }

    public boolean isPlaying() {
        return this.trackPlayer.isPlaying();
    }

    public int getCurrentVolume() {
        return this.trackPlayer.getVolume();
    }

    public void smoothVolumeChange(int endVolume, int milliseconds) {
        if (this.volumeChangeHandler != null) {
            this.volumeChangeHandler.interrupt();
        }
        this.volumeChangeHandler = new Thread(() -> {
            try {
                int startVolume = this.getCurrentVolume();
                long startTime = System.currentTimeMillis();
                long endTime = startTime + (long)milliseconds;
                while (System.currentTimeMillis() < endTime) {
                    double percentProgress = (double)(System.currentTimeMillis() - startTime) / (double)(endTime - startTime);
                    double sigmoid = this.sigmoid(percentProgress);
                    int newVolume = (int)((double)startVolume + sigmoid * (double)(endVolume - startVolume));
                    this.setVolumeLevel(newVolume);
                    Thread.sleep(100L);
                }
                this.setVolumeLevel(endVolume);
                if (endVolume == 0) {
                    this.setFading(false);
                    this.stopClip();
                }
            }
            catch (InterruptedException e) {
                return;
            }
        });
        this.volumeChangeHandler.start();
    }

    private double sigmoid(double percentProgress) {
        percentProgress = percentProgress * Math.E * 4.0;
        return Math.exp(percentProgress - 5.43656365691809) / (Math.exp(percentProgress - 5.43656365691809) + 1.0);
    }

    public void setVolumeLevel(int volume) {
        if (volume < 0) {
            volume = 0;
        }
        if (volume > 100) {
            volume = 100;
        }
        this.trackPlayer.setVolume(volume);
    }

    public CyclesPlugin getPlugin() {
        return this.plugin;
    }

    public CyclesConfig getConfig() {
        return this.config;
    }

    public SourceDataLine getSourceDataLine() {
        return this.sourceDataLine;
    }

    public AudioSystem getAudioSystem() {
        return this.audioSystem;
    }

    public boolean isFading() {
        return this.isFading;
    }

    public boolean isPrimarySoundPlayer() {
        return this.primarySoundPlayer;
    }

    public int getTimer() {
        return this.timer;
    }

    public SoundEffect getCurrentTrack() {
        return this.currentTrack;
    }

    public boolean isAmbienceError() {
        return this.ambienceError;
    }

    public MP3Player getTrackPlayer() {
        return this.trackPlayer;
    }

    public Thread getHandlePlayThread() {
        return this.handlePlayThread;
    }

    public Thread getVolumeChangeHandler() {
        return this.volumeChangeHandler;
    }

    public void setPlugin(CyclesPlugin plugin) {
        this.plugin = plugin;
    }

    public void setConfig(CyclesConfig config) {
        this.config = config;
    }

    public void setSourceDataLine(SourceDataLine sourceDataLine) {
        this.sourceDataLine = sourceDataLine;
    }

    public void setAudioSystem(AudioSystem audioSystem) {
        this.audioSystem = audioSystem;
    }

    public void setFading(boolean isFading) {
        this.isFading = isFading;
    }

    public void setPrimarySoundPlayer(boolean primarySoundPlayer) {
        this.primarySoundPlayer = primarySoundPlayer;
    }

    public void setTimer(int timer) {
        this.timer = timer;
    }

    public void setCurrentTrack(SoundEffect currentTrack) {
        this.currentTrack = currentTrack;
    }

    public void setAmbienceError(boolean ambienceError) {
        this.ambienceError = ambienceError;
    }

    public void setHandlePlayThread(Thread handlePlayThread) {
        this.handlePlayThread = handlePlayThread;
    }

    public void setVolumeChangeHandler(Thread volumeChangeHandler) {
        this.volumeChangeHandler = volumeChangeHandler;
    }
}

