/*
 * Decompiled with CFR 0.152.
 */
package com.weather3d;

import com.weather3d.conditions.Weather;
import java.util.Arrays;
import java.util.Objects;
import javax.inject.Inject;
import net.runelite.api.Animation;
import net.runelite.api.Client;
import net.runelite.api.JagexColor;
import net.runelite.api.Model;
import net.runelite.api.ModelData;

public class ModelHandler {
    @Inject
    private Client client;
    private Model ashModel;
    private Model ashModel2;
    private Model ashModel3;
    private Model cloudModel;
    private Model cloudModel2;
    private Model cloudModel3;
    private Model cloudModelTP;
    private Model cloudModelTP2;
    private Model cloudModelTP3;
    private Model fogModel;
    private Model fogModel2;
    private Model fogModel3;
    private Model rainModel;
    private Model rainModel2;
    private Model rainModel3;
    private Model snowModel;
    private Model snowModel2;
    private Model snowModel3;
    private Model starModel;
    private Model starModel2;
    private Model starModel3;
    private Model starModelTP;
    private Model starModelTP2;
    private Model starModelTP3;
    private Model stormModel;
    private Model stormModel2;
    private Model stormModel3;
    private Animation ashAnimation;
    private Animation cloudAnimation;
    private Animation fogAnimation;
    private Animation rainAnimation;
    private Animation snowAnimation;
    private Animation starAnimation;
    private final int ASH_MODEL = 27835;
    private final int ASH_ANIMATION = 7000;
    private final int CLOUD_MODEL = 4086;
    private final int CLOUD_ANIMATION = 6470;
    private final int FOG_MODEL = 29290;
    private final int FOG_ANIMATION = 4516;
    private final int RAIN_MODEL = 15524;
    private final int RAIN_ANIMATION = 7001;
    private final int SNOW_MODEL = 27835;
    private final int SNOW_ANIMATION = 7000;
    private final int STAR_MODEL = 16374;
    private final int STAR_ANIMATION = 7971;

    public void loadModels() {
        ModelData ashModelData = this.client.loadModelData(27835).cloneColors().cloneVertices();
        ModelData ashModelData2 = this.client.loadModelData(27835).cloneColors().cloneVertices();
        ModelData ashModelData3 = this.client.loadModelData(27835).cloneColors().cloneVertices();
        short[] ashFaceColours = ashModelData.getFaceColors();
        short[] ashFaceColours2 = ashModelData2.getFaceColors();
        short[] ashFaceColours3 = ashModelData3.getFaceColors();
        short ashColour1 = JagexColor.packHSL((int)39, (int)1, (int)40);
        short ashColour2 = JagexColor.packHSL((int)39, (int)1, (int)40);
        this.ashModel = ((ModelData)((ModelData)ashModelData.scale(128, 192, 128)).translate(0, 180, 0)).recolor(ashFaceColours[0], ashColour1).recolor(ashFaceColours[2], ashColour2).light();
        this.ashModel2 = ((ModelData)((ModelData)((ModelData)ashModelData2.scale(128, 192, 128)).translate(0, 180, 0)).recolor(ashFaceColours2[0], ashColour1).recolor(ashFaceColours2[2], ashColour2).rotateY90Ccw()).light();
        this.ashModel3 = ((ModelData)((ModelData)((ModelData)ashModelData3.scale(128, 192, 128)).translate(0, 180, 0)).recolor(ashFaceColours3[0], ashColour1).recolor(ashFaceColours3[2], ashColour2).rotateY270Ccw()).light();
        ModelData cloudModelData = this.client.loadModelData(4086).cloneVertices().cloneColors().cloneTransparencies();
        ModelData cloudModelData2 = this.client.loadModelData(4086).cloneVertices().cloneColors().cloneTransparencies();
        ModelData cloudModelData3 = this.client.loadModelData(4086).cloneVertices().cloneColors().cloneTransparencies();
        short cloudFaceColour = cloudModelData.getFaceColors()[0];
        short cloudReplaceColour = JagexColor.packHSL((int)54, (int)0, (int)110);
        this.cloudModel = ((ModelData)((ModelData)cloudModelData.scale(650, 325, 650)).translate(0, -1000, 0)).recolor(cloudFaceColour, cloudReplaceColour).light();
        this.cloudModel2 = ((ModelData)((ModelData)((ModelData)cloudModelData2.scale(1000, 500, 1000)).translate(0, -1400, 0)).recolor(cloudFaceColour, cloudReplaceColour).rotateY90Ccw()).light();
        this.cloudModel3 = ((ModelData)((ModelData)((ModelData)cloudModelData3.scale(800, 400, 800)).translate(0, -1200, 0)).recolor(cloudFaceColour, cloudReplaceColour).rotateY180Ccw()).light();
        ModelData cloudTPModelData = this.client.loadModelData(4086).cloneVertices().cloneColors().cloneTransparencies();
        ModelData cloudTPModelData2 = this.client.loadModelData(4086).cloneVertices().cloneColors().cloneTransparencies();
        ModelData cloudTPModelData3 = this.client.loadModelData(4086).cloneVertices().cloneColors().cloneTransparencies();
        this.cloudModelTP = ((ModelData)((ModelData)cloudTPModelData.scale(650, 325, 650)).translate(0, -1000, 0)).recolor(cloudFaceColour, cloudReplaceColour).light();
        this.cloudModelTP2 = ((ModelData)((ModelData)((ModelData)cloudTPModelData2.scale(1000, 500, 1000)).translate(0, -1400, 0)).recolor(cloudFaceColour, cloudReplaceColour).rotateY90Ccw()).light();
        this.cloudModelTP3 = ((ModelData)((ModelData)((ModelData)cloudTPModelData3.scale(800, 400, 800)).translate(0, -1200, 0)).recolor(cloudFaceColour, cloudReplaceColour).rotateY180Ccw()).light();
        byte[] cloudMDTP = cloudTPModelData.getFaceTransparencies();
        byte[] cloudMDTP2 = cloudTPModelData2.getFaceTransparencies();
        byte[] cloudMDTP3 = cloudTPModelData3.getFaceTransparencies();
        Arrays.fill(cloudMDTP, (byte)-23);
        Arrays.fill(cloudMDTP2, (byte)-23);
        Arrays.fill(cloudMDTP3, (byte)-23);
        ModelData fogModelData = this.client.loadModelData(29290).cloneVertices().cloneColors().cloneTransparencies();
        ModelData fogModelData2 = this.client.loadModelData(29290).cloneVertices().cloneColors().cloneTransparencies();
        ModelData fogModelData3 = this.client.loadModelData(29290).cloneVertices().cloneColors().cloneTransparencies();
        short fogFaceColour = fogModelData.getFaceColors()[0];
        short fogReplaceColour = JagexColor.packHSL((int)54, (int)0, (int)77);
        this.fogModel = ((ModelData)((ModelData)fogModelData.scale(190, 110, 190)).recolor(fogFaceColour, fogReplaceColour).translate(0, -70, 0)).light(200, 768, -50, -10, -50);
        this.fogModel2 = ((ModelData)((ModelData)fogModelData2.scale(190, 110, 190)).recolor(fogFaceColour, fogReplaceColour).translate(0, -100, 0)).light(200, 768, -50, -10, -50);
        this.fogModel3 = ((ModelData)((ModelData)fogModelData3.scale(190, 110, 190)).recolor(fogFaceColour, fogReplaceColour).translate(0, -85, 0)).light(200, 768, -50, -10, -50);
        byte[] fogTransparency = fogModelData.getFaceTransparencies();
        byte[] fogTransparency2 = fogModelData2.getFaceTransparencies();
        byte[] fogTransparency3 = fogModelData3.getFaceTransparencies();
        Arrays.fill(fogTransparency, (byte)-15);
        Arrays.fill(fogTransparency2, (byte)-15);
        Arrays.fill(fogTransparency3, (byte)-15);
        ModelData snowModelData = this.client.loadModelData(27835).cloneVertices();
        ModelData snowModelData2 = this.client.loadModelData(27835).cloneVertices();
        ModelData snowModelData3 = this.client.loadModelData(27835).cloneVertices();
        this.snowModel = ((ModelData)((ModelData)snowModelData.scale(128, 192, 128)).translate(0, 190, 0)).light();
        this.snowModel2 = ((ModelData)((ModelData)((ModelData)snowModelData2.scale(128, 192, 128)).translate(0, 190, 0)).rotateY90Ccw()).light();
        this.snowModel3 = ((ModelData)((ModelData)((ModelData)snowModelData3.scale(128, 192, 128)).translate(0, 190, 0)).rotateY270Ccw()).light();
        ModelData rainModelData = this.client.loadModelData(15524).cloneVertices();
        ModelData rainModelData2 = this.client.loadModelData(15524).cloneVertices();
        ModelData rainModelData3 = this.client.loadModelData(15524).cloneVertices();
        short[] rainFaceColours = rainModelData.getFaceColors();
        short[] rainFaceColours2 = rainModelData2.getFaceColors();
        short[] rainFaceColours3 = rainModelData3.getFaceColors();
        short rainRippleColour = JagexColor.packHSL((int)32, (int)1, (int)127);
        short rainDropColour = JagexColor.packHSL((int)32, (int)1, (int)120);
        this.rainModel = ((ModelData)rainModelData.scale(100, 256, 100)).recolor(rainFaceColours[0], rainRippleColour).recolor(rainFaceColours[23], rainDropColour).light();
        this.rainModel2 = ((ModelData)((ModelData)rainModelData2.scale(90, 256, 90)).recolor(rainFaceColours2[0], rainRippleColour).recolor(rainFaceColours2[23], rainDropColour).rotateY90Ccw()).light();
        this.rainModel3 = ((ModelData)((ModelData)rainModelData3.scale(110, 256, 110)).recolor(rainFaceColours3[0], rainRippleColour).recolor(rainFaceColours3[23], rainDropColour).rotateY270Ccw()).light();
        ModelData stormModelData = this.client.loadModelData(15524).cloneColors().cloneVertices();
        ModelData stormModelData2 = this.client.loadModelData(15524).cloneColors().cloneVertices();
        ModelData stormModelData3 = this.client.loadModelData(15524).cloneColors().cloneVertices();
        short[] stormFaceColours = stormModelData.getFaceColors();
        short[] stormFaceColours2 = stormModelData2.getFaceColors();
        short[] stormFaceColours3 = stormModelData3.getFaceColors();
        short stormRippleColour = JagexColor.packHSL((int)38, (int)1, (int)110);
        short stormDropColour = JagexColor.packHSL((int)38, (int)2, (int)105);
        this.stormModel = ((ModelData)stormModelData.scale(110, 410, 110)).recolor(stormFaceColours[0], stormRippleColour).recolor(stormFaceColours[23], stormDropColour).light();
        this.stormModel2 = ((ModelData)((ModelData)stormModelData2.scale(100, 410, 100)).recolor(stormFaceColours2[0], stormRippleColour).recolor(stormFaceColours2[23], stormDropColour).rotateY90Ccw()).light();
        this.stormModel3 = ((ModelData)((ModelData)stormModelData3.scale(120, 410, 120)).recolor(stormFaceColours3[0], stormRippleColour).recolor(stormFaceColours3[23], stormDropColour).rotateY90Ccw()).light();
        ModelData starModelData = this.client.loadModelData(16374).cloneColors().cloneVertices().cloneTransparencies();
        ModelData starModelData2 = this.client.loadModelData(16374).cloneColors().cloneVertices().cloneTransparencies();
        ModelData starModelData3 = this.client.loadModelData(16374).cloneColors().cloneVertices().cloneTransparencies();
        short[] starFaceColours = starModelData.getFaceColors();
        short[] starFaceColours2 = starModelData2.getFaceColors();
        short[] starFaceColours3 = starModelData3.getFaceColors();
        short starShellReplaceColour = JagexColor.packHSL((int)10, (int)4, (int)60);
        short starInsideReplaceColour = JagexColor.packHSL((int)10, (int)6, (int)80);
        this.starModel = ((ModelData)((ModelData)starModelData.scale(80, 80, 80)).translate(0, -1400, 0)).recolor(starFaceColours[0], starShellReplaceColour).recolor(starFaceColours[45], starInsideReplaceColour).light(64, 1400, -50, -10, -50);
        this.starModel2 = ((ModelData)((ModelData)starModelData2.scale(65, 65, 65)).translate(0, -1500, 0)).recolor(starFaceColours2[0], starShellReplaceColour).recolor(starFaceColours2[45], starInsideReplaceColour).light(64, 1400, -50, -10, -50);
        this.starModel3 = ((ModelData)((ModelData)starModelData3.scale(95, 95, 95)).translate(0, -1300, 0)).recolor(starFaceColours3[0], starShellReplaceColour).recolor(starFaceColours3[45], starInsideReplaceColour).light(64, 1400, -50, -10, -50);
        ModelData starModelDataTP = this.client.loadModelData(16374).cloneColors().cloneVertices().cloneTransparencies();
        ModelData starModelDataTP2 = this.client.loadModelData(16374).cloneColors().cloneVertices().cloneTransparencies();
        ModelData starModelDataTP3 = this.client.loadModelData(16374).cloneColors().cloneVertices().cloneTransparencies();
        short[] starFaceColoursTP = starModelDataTP.getFaceColors();
        short[] starFaceColoursTP2 = starModelDataTP2.getFaceColors();
        short[] starFaceColoursTP3 = starModelDataTP3.getFaceColors();
        this.starModelTP = ((ModelData)((ModelData)starModelDataTP.scale(80, 80, 80)).translate(0, -1400, 0)).recolor(starFaceColoursTP[0], starShellReplaceColour).recolor(starFaceColoursTP[45], starInsideReplaceColour).light(64, 1400, -50, -10, -50);
        this.starModelTP2 = ((ModelData)((ModelData)starModelDataTP2.scale(65, 65, 65)).translate(0, -1500, 0)).recolor(starFaceColoursTP2[0], starShellReplaceColour).recolor(starFaceColoursTP2[45], starInsideReplaceColour).light(64, 1400, -50, -10, -50);
        this.starModelTP3 = ((ModelData)((ModelData)starModelDataTP3.scale(95, 95, 95)).translate(0, -1300, 0)).recolor(starFaceColoursTP3[0], starShellReplaceColour).recolor(starFaceColoursTP3[45], starInsideReplaceColour).light(64, 1400, -50, -10, -50);
        byte[] starMDTP = starModelDataTP.getFaceTransparencies();
        byte[] starMDTP2 = starModelDataTP2.getFaceTransparencies();
        byte[] starMDTP3 = starModelDataTP3.getFaceTransparencies();
        Arrays.fill(starMDTP, (byte)-80);
        Arrays.fill(starMDTP2, (byte)-80);
        Arrays.fill(starMDTP3, (byte)-80);
        this.ashAnimation = this.client.loadAnimation(7000);
        this.cloudAnimation = this.client.loadAnimation(6470);
        this.fogAnimation = this.client.loadAnimation(6470);
        this.rainAnimation = this.client.loadAnimation(7001);
        this.snowAnimation = this.client.loadAnimation(7000);
        this.starAnimation = this.client.loadAnimation(7971);
    }

    public Model getWeatherModel(Weather currentWeather, int alternative) {
        switch (currentWeather) {
            case ASHFALL: {
                switch (alternative) {
                    default: {
                        return this.ashModel;
                    }
                    case 2: {
                        return this.ashModel2;
                    }
                    case 3: 
                }
                return this.ashModel3;
            }
            case CLOUDY: 
            case PARTLY_CLOUDY: {
                switch (alternative) {
                    default: {
                        return this.cloudModel;
                    }
                    case 2: {
                        return this.cloudModel2;
                    }
                    case 3: 
                }
                return this.cloudModel3;
            }
            case STARRY: {
                switch (alternative) {
                    default: {
                        return this.starModel;
                    }
                    case 2: {
                        return this.starModel2;
                    }
                    case 3: 
                }
                return this.starModel3;
            }
            case FOGGY: {
                return this.fogModel;
            }
            case SNOWY: {
                switch (alternative) {
                    default: {
                        return this.snowModel;
                    }
                    case 2: {
                        return this.snowModel2;
                    }
                    case 3: 
                }
                return this.snowModel3;
            }
            case RAINY: {
                switch (alternative) {
                    default: {
                        return this.rainModel;
                    }
                    case 2: {
                        return this.rainModel2;
                    }
                    case 3: 
                }
                return this.rainModel3;
            }
            case STORMY: {
                switch (alternative) {
                    default: {
                        return this.stormModel;
                    }
                    case 2: {
                        return this.stormModel2;
                    }
                    case 3: 
                }
                return this.stormModel3;
            }
        }
        return null;
    }

    public Animation getWeatherAnimation(Weather currentWeather) {
        switch (currentWeather) {
            case ASHFALL: {
                return this.ashAnimation;
            }
            case CLOUDY: 
            case PARTLY_CLOUDY: {
                return this.cloudAnimation;
            }
            case STARRY: {
                return this.starAnimation;
            }
            case FOGGY: {
                return this.fogAnimation;
            }
            case SNOWY: {
                return this.snowAnimation;
            }
            case RAINY: 
            case STORMY: {
                return this.rainAnimation;
            }
        }
        return null;
    }

    public Model getTransparentModel(Weather weatherType, int objectVariant) {
        switch (weatherType) {
            default: {
                switch (objectVariant) {
                    default: {
                        return this.cloudModelTP;
                    }
                    case 2: {
                        return this.cloudModelTP2;
                    }
                    case 3: 
                }
                return this.cloudModelTP3;
            }
            case STARRY: 
        }
        switch (objectVariant) {
            default: {
                return this.starModelTP;
            }
            case 2: {
                return this.starModelTP2;
            }
            case 3: 
        }
        return this.starModelTP3;
    }

    public Model getRegularModel(Weather weatherType, int objectVariant) {
        switch (weatherType) {
            default: {
                switch (objectVariant) {
                    default: {
                        return this.cloudModel;
                    }
                    case 2: {
                        return this.cloudModel2;
                    }
                    case 3: 
                }
                return this.cloudModel3;
            }
            case STARRY: 
        }
        switch (objectVariant) {
            default: {
                return this.starModel;
            }
            case 2: {
                return this.starModel2;
            }
            case 3: 
        }
        return this.starModel3;
    }

    public int getModelRadius(Weather weatherType) {
        switch (weatherType) {
            default: {
                return 60;
            }
            case CLOUDY: 
            case PARTLY_CLOUDY: {
                return 60;
            }
            case FOGGY: 
        }
        return 90;
    }

    public Client getClient() {
        return this.client;
    }

    public Model getAshModel() {
        return this.ashModel;
    }

    public Model getAshModel2() {
        return this.ashModel2;
    }

    public Model getAshModel3() {
        return this.ashModel3;
    }

    public Model getCloudModel() {
        return this.cloudModel;
    }

    public Model getCloudModel2() {
        return this.cloudModel2;
    }

    public Model getCloudModel3() {
        return this.cloudModel3;
    }

    public Model getCloudModelTP() {
        return this.cloudModelTP;
    }

    public Model getCloudModelTP2() {
        return this.cloudModelTP2;
    }

    public Model getCloudModelTP3() {
        return this.cloudModelTP3;
    }

    public Model getFogModel() {
        return this.fogModel;
    }

    public Model getFogModel2() {
        return this.fogModel2;
    }

    public Model getFogModel3() {
        return this.fogModel3;
    }

    public Model getRainModel() {
        return this.rainModel;
    }

    public Model getRainModel2() {
        return this.rainModel2;
    }

    public Model getRainModel3() {
        return this.rainModel3;
    }

    public Model getSnowModel() {
        return this.snowModel;
    }

    public Model getSnowModel2() {
        return this.snowModel2;
    }

    public Model getSnowModel3() {
        return this.snowModel3;
    }

    public Model getStarModel() {
        return this.starModel;
    }

    public Model getStarModel2() {
        return this.starModel2;
    }

    public Model getStarModel3() {
        return this.starModel3;
    }

    public Model getStarModelTP() {
        return this.starModelTP;
    }

    public Model getStarModelTP2() {
        return this.starModelTP2;
    }

    public Model getStarModelTP3() {
        return this.starModelTP3;
    }

    public Model getStormModel() {
        return this.stormModel;
    }

    public Model getStormModel2() {
        return this.stormModel2;
    }

    public Model getStormModel3() {
        return this.stormModel3;
    }

    public Animation getAshAnimation() {
        return this.ashAnimation;
    }

    public Animation getCloudAnimation() {
        return this.cloudAnimation;
    }

    public Animation getFogAnimation() {
        return this.fogAnimation;
    }

    public Animation getRainAnimation() {
        return this.rainAnimation;
    }

    public Animation getSnowAnimation() {
        return this.snowAnimation;
    }

    public Animation getStarAnimation() {
        return this.starAnimation;
    }

    public int getASH_MODEL() {
        Objects.requireNonNull(this);
        return 27835;
    }

    public int getASH_ANIMATION() {
        Objects.requireNonNull(this);
        return 7000;
    }

    public int getCLOUD_MODEL() {
        return this.CLOUD_MODEL;
    }

    public int getCLOUD_ANIMATION() {
        return this.CLOUD_ANIMATION;
    }

    public int getFOG_MODEL() {
        return this.FOG_MODEL;
    }

    public int getFOG_ANIMATION() {
        return this.FOG_ANIMATION;
    }

    public int getRAIN_MODEL() {
        return this.RAIN_MODEL;
    }

    public int getRAIN_ANIMATION() {
        return this.RAIN_ANIMATION;
    }

    public int getSNOW_MODEL() {
        Objects.requireNonNull(this);
        return 27835;
    }

    public int getSNOW_ANIMATION() {
        Objects.requireNonNull(this);
        return 7000;
    }

    public int getSTAR_MODEL() {
        return this.STAR_MODEL;
    }

    public int getSTAR_ANIMATION() {
        return this.STAR_ANIMATION;
    }
}

