/*
 * Decompiled with CFR 0.152.
 */
package com.weather3d;

import com.weather3d.CyclesConfig;
import com.weather3d.CyclesPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;

public class LightningOverlay
extends Overlay {
    private final Client client;
    private final CyclesPlugin plugin;
    private final CyclesConfig config;

    @Inject
    private LightningOverlay(Client client, CyclesPlugin plugin, CyclesConfig config) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.config.enableLightning() || !this.plugin.flashLightning) {
            return null;
        }
        Dimension dimensions = this.client.getRealDimensions();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, dimensions.width, dimensions.height);
        this.plugin.flashLightning = false;
        return null;
    }
}

