/*
 * Decompiled with CFR 0.152.
 */
package com.weather3d;

import com.google.inject.Provides;
import com.weather3d.BiomeChunkMap;
import com.weather3d.CyclesClock;
import com.weather3d.CyclesConfig;
import com.weather3d.CyclesOverlay;
import com.weather3d.LightningOverlay;
import com.weather3d.ModelHandler;
import com.weather3d.WeatherForecast;
import com.weather3d.WeatherObject;
import com.weather3d.audio.SoundEffect;
import com.weather3d.audio.SoundPlayer;
import com.weather3d.conditions.Biome;
import com.weather3d.conditions.Season;
import com.weather3d.conditions.Weather;
import com.weather3d.conditions.WeatherManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.Animation;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Model;
import net.runelite.api.RuneLiteObject;
import net.runelite.api.Scene;
import net.runelite.api.Tile;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.PluginManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="3D Weather", description="Creates immersive 3D Weather with dynamic Weather cycles and ambience", tags={"immersion,", "weather", "ambience", "audio", "graphics"})
public class CyclesPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(CyclesPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private CyclesConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private CyclesOverlay cyclesOverlay;
    @Inject
    private LightningOverlay lightningOverlay;
    @Inject
    private ConfigManager configManager;
    @Inject
    private PluginManager pluginManager;
    @Inject
    private ModelHandler modelHandler;
    private final Random random = new Random();
    private final ArrayList<WeatherManager> weatherManagerList = new ArrayList();
    private boolean loadedAnimsModels = false;
    private boolean conditionsSynced = false;
    private boolean isPlayerIndoors = false;
    public boolean flashLightning = false;
    private boolean winter117 = false;
    private int savedChunk = 0;
    private int savedZPlane = -1;
    private int zoneObjRecovery = 0;
    private final int WINTERTODT_CHUNK = 6462;
    private final int OBJ_ROTATION_CONSTANT = 20;
    private final int MODEL_TRANSPARENT_SWAP_DISTANCE = 3000;
    private final int MODEL_DISAPPEAR_DISTANCE = 2500;
    private final int FOG_RADIUS = 100;
    private Season currentSeason = Season.SPRING;
    private Biome currentBiome = Biome.GRASSLAND;
    private Weather currentWeather;

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.cyclesOverlay);
        this.overlayManager.add((Overlay)this.lightningOverlay);
        if (this.client.getLocalPlayer() != null) {
            this.syncBiome();
            this.syncSeason();
            this.setConfigWeather();
            this.handleWeatherManagers();
        }
    }

    protected void shutDown() throws Exception {
        this.clientThread.invoke(this::clearAllWeatherManagers);
        this.overlayManager.remove((Overlay)this.cyclesOverlay);
        this.overlayManager.remove((Overlay)this.lightningOverlay);
    }

    @Subscribe
    public void onClientTick(ClientTick event) {
        for (WeatherManager weatherManager : this.weatherManagerList) {
            Weather weatherType = weatherManager.getWeatherType();
            if (weatherType != Weather.CLOUDY && weatherType != Weather.PARTLY_CLOUDY && weatherType != Weather.STARRY) continue;
            LocalPoint localPoint = new LocalPoint(this.client.getCameraX(), this.client.getCameraY());
            for (WeatherObject weatherObject : weatherManager.getWeatherObjArray()) {
                RuneLiteObject runeLiteObject = weatherObject.getRuneLiteObject();
                int objectVariant = weatherObject.getObjVariant();
                int distance = runeLiteObject.getLocation().distanceTo(localPoint);
                if (distance < 2500) {
                    runeLiteObject.setActive(false);
                    continue;
                }
                runeLiteObject.setActive(true);
                if (distance < 3000) {
                    runeLiteObject.setModel(this.modelHandler.getTransparentModel(weatherType, objectVariant));
                    continue;
                }
                runeLiteObject.setModel(this.modelHandler.getRegularModel(weatherType, objectVariant));
            }
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (!this.loadedAnimsModels) {
            this.modelHandler.loadModels();
            this.loadedAnimsModels = true;
        }
        if (!this.conditionsSynced) {
            this.setConfigWeather();
            if (this.currentWeather.isHasPrecipitation()) {
                this.handleWeatherManagers();
            }
            this.conditionsSynced = true;
        }
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        this.syncSeason();
        this.syncBiome();
        this.isPlayerIndoors = true;
        WorldPoint playerLoc = this.client.getLocalPlayer().getWorldLocation();
        for (Tile t : this.getAvailableTiles()) {
            if (t.getWorldLocation().getX() != playerLoc.getX() || t.getWorldLocation().getY() != playerLoc.getY()) continue;
            this.isPlayerIndoors = false;
        }
        if (this.config.weatherType() == CyclesConfig.WeatherType.DYNAMIC) {
            Weather nextWeather = this.syncWeather(this.currentSeason, this.currentBiome);
            if (nextWeather != this.currentWeather) {
                this.setConfigWeather();
                this.handleWeatherManagers();
            }
            this.conditionsSynced = true;
        }
        for (WeatherManager weatherManager : this.weatherManagerList) {
            if (weatherManager.isFading()) {
                this.fadeWeatherManager(weatherManager);
            } else {
                this.handleWeatherChanges(weatherManager);
            }
            this.handleSoundChanges(weatherManager);
        }
        this.clearFadedWeatherManagers();
        if (this.savedZPlane != this.client.getPlane()) {
            this.transitionZPlane();
            this.savedZPlane = this.client.getPlane();
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        GameState gameState = event.getGameState();
        if (gameState == GameState.LOGIN_SCREEN || gameState == GameState.LOGIN_SCREEN_AUTHENTICATOR || gameState == GameState.STARTING) {
            this.clientThread.invoke(this::clearAllWeatherManagers);
            return;
        }
        if (gameState != GameState.LOGGED_IN) {
            return;
        }
        this.syncBiome();
        this.syncSeason();
        this.setConfigWeather();
        this.handleWeatherManagers();
        this.handleZoneTransition();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("3Dweather")) {
            return;
        }
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        String key = event.getKey();
        if (key.equals("weatherType")) {
            this.setConfigWeather();
            this.handleWeatherManagers();
            return;
        }
        if (key.equals("disableWeatherUnderground")) {
            if (!this.config.disableWeatherUnderground()) {
                return;
            }
            if (this.currentBiome == Biome.CAVE || this.currentBiome == Biome.LAVA_CAVE) {
                this.clientThread.invoke(this::clearAllWeatherManagers);
            }
        }
        if (key.equals("seasonType")) {
            this.syncSeason();
            return;
        }
        if (key.equals("ashfallDensity")) {
            this.handleConfigDensityChange(Weather.ASHFALL, this.config.ashfallDensity());
        }
        if (key.equals("rainDensity")) {
            this.handleConfigDensityChange(Weather.RAINY, this.config.rainDensity());
        }
        if (key.equals("stormDensity")) {
            this.handleConfigDensityChange(Weather.STORMY, this.config.stormDensity());
        }
        if (key.equals("snowDensity")) {
            this.handleConfigDensityChange(Weather.SNOWY, this.config.snowDensity());
        }
        if (key.equals("partlyCloudyDensity")) {
            this.handleConfigDensityChange(Weather.PARTLY_CLOUDY, this.config.partlyCloudyDensity());
        }
        if (key.equals("cloudyDensity")) {
            this.handleConfigDensityChange(Weather.CLOUDY, this.config.cloudyDensity());
        }
        if (key.equals("foggyDensity")) {
            this.handleConfigDensityChange(Weather.FOGGY, this.config.foggyDensity());
        }
        if (key.equals("starryDensity")) {
            this.handleConfigDensityChange(Weather.STARRY, this.config.starryDensity());
        }
        if (event.getKey().equals("toggleOverlay")) {
            if (this.config.toggleOverlay()) {
                this.overlayManager.add((Overlay)this.cyclesOverlay);
                return;
            }
            this.overlayManager.remove((Overlay)this.cyclesOverlay);
            return;
        }
        if (event.getKey().equals("toggleAmbience")) {
            for (WeatherManager weatherManager : this.weatherManagerList) {
                if (!weatherManager.getWeatherType().isHasSound()) continue;
                if (this.config.toggleAmbience()) {
                    this.handleSoundChanges(weatherManager);
                    return;
                }
                weatherManager.stopManagerSoundPlayers();
            }
            return;
        }
        if (key.equals("enableRain")) {
            this.handleConfigEnableChange(Weather.RAINY, Boolean.getBoolean(event.getNewValue()));
            this.handleConfigEnableChange(Weather.STORMY, Boolean.getBoolean(event.getNewValue()));
        }
        if (key.equals("enableSnow")) {
            this.handleConfigEnableChange(Weather.SNOWY, Boolean.getBoolean(event.getNewValue()));
        }
        if (key.equals("enableClouds")) {
            this.handleConfigEnableChange(Weather.CLOUDY, Boolean.getBoolean(event.getNewValue()));
            this.handleConfigEnableChange(Weather.PARTLY_CLOUDY, Boolean.getBoolean(event.getNewValue()));
        }
        if (key.equals("enableAsh")) {
            this.handleConfigEnableChange(Weather.ASHFALL, Boolean.getBoolean(event.getNewValue()));
        }
        if (key.equals("enableFog")) {
            this.handleConfigEnableChange(Weather.FOGGY, Boolean.getBoolean(event.getNewValue()));
        }
        if (key.equals("enableStars")) {
            this.handleConfigEnableChange(Weather.STARRY, Boolean.getBoolean(event.getNewValue()));
        }
        if (event.getKey().equals("enableWintertodtSnow")) {
            if (this.config.enableWintertodtSnow()) {
                return;
            }
            int playerChunk = this.client.getLocalPlayer().getWorldLocation().getRegionID();
            if (playerChunk == 6462) {
                for (WeatherManager weatherManager : this.weatherManagerList) {
                    if (weatherManager.getWeatherType() != Weather.SNOWY) continue;
                    this.clientThread.invoke(() -> this.clearWeatherObjects(weatherManager));
                    this.clientThread.invoke(weatherManager::stopManagerSoundPlayers);
                }
            }
        }
    }

    private void handleConfigEnableChange(Weather weather, boolean enabled) {
        if (enabled) {
            return;
        }
        for (WeatherManager weatherManager : this.weatherManagerList) {
            if (weatherManager.getWeatherType() != weather) continue;
            this.clientThread.invoke(() -> this.clearWeatherObjects(weatherManager));
            this.clientThread.invoke(weatherManager::stopManagerSoundPlayers);
        }
    }

    private void handleConfigDensityChange(Weather weatherType, int newDensity) {
        for (WeatherManager weatherManager : this.weatherManagerList) {
            Weather weather = weatherManager.getWeatherType();
            if (weather != weatherType || !weather.isHasPrecipitation()) continue;
            ArrayList<WeatherObject> array = weatherManager.getWeatherObjArray();
            this.clientThread.invoke(() -> {
                while (array.size() > newDensity) {
                    this.removeWeatherObject(0, array);
                }
            });
        }
    }

    public void handleWeatherManagers() {
        boolean activeManager = false;
        for (WeatherManager weatherManager : this.weatherManagerList) {
            weatherManager.setFading(true);
            if (weatherManager.getWeatherType() != this.currentWeather) continue;
            weatherManager.setFading(false);
            activeManager = true;
        }
        if (!activeManager && this.currentWeather.isHasPrecipitation()) {
            SwingUtilities.invokeLater(this::createWeatherManager);
        }
    }

    public void handleSoundChanges(WeatherManager weatherManager) {
        SoundEffect appropriateSound;
        for (SoundPlayer sp : weatherManager.getSoundPlayers()) {
            if (!sp.isPlaying()) continue;
            sp.setTimer(sp.getTimer() + 1);
        }
        Weather weather = weatherManager.getWeatherType();
        if (!weather.isHasSound() || !this.config.toggleAmbience()) {
            return;
        }
        if (this.config.weatherType() != CyclesConfig.WeatherType.DYNAMIC && this.config.disableWeatherUnderground() && (this.currentBiome == Biome.CAVE || this.currentBiome == Biome.LAVA_CAVE)) {
            return;
        }
        if (weather != this.currentWeather) {
            for (SoundPlayer sp : weatherManager.getSoundPlayers()) {
                if (!sp.isPlaying() || sp.isFading()) continue;
                sp.setFading(true);
                sp.smoothVolumeChange(0, 6000);
            }
            return;
        }
        if (weatherManager.getPrimarySoundPlayer().isFading()) {
            weatherManager.getPrimarySoundPlayer().setFading(false);
            weatherManager.getPrimarySoundPlayer().getVolumeChangeHandler().interrupt();
        }
        boolean muffled = false;
        SoundEffect outdoorSound = weatherManager.getWeatherType().getSoundEffect();
        if (this.isPlayerIndoors && !this.config.disableIndoorMuffling()) {
            if (outdoorSound == SoundEffect.RAIN) {
                appropriateSound = SoundEffect.RAIN_MUFFLED;
                muffled = true;
            } else if (outdoorSound == SoundEffect.THUNDERSTORM) {
                appropriateSound = SoundEffect.THUNDERSTORM_MUFFLED;
                muffled = true;
            } else if (outdoorSound == SoundEffect.WIND) {
                appropriateSound = SoundEffect.WIND_MUFFLED;
                muffled = true;
            } else {
                appropriateSound = outdoorSound;
            }
        } else {
            appropriateSound = outdoorSound;
        }
        SoundPlayer primary = weatherManager.getPrimarySoundPlayer();
        int currentObjects = weatherManager.getWeatherObjArray().size();
        int currentVolume = primary.getCurrentVolume();
        int volumeGoal = this.getVolumeGoal(muffled, weather);
        int changeRate = 6000;
        if (!(primary.getCurrentTrack() == null || currentVolume == volumeGoal || primary.getVolumeChangeHandler() != null && primary.getVolumeChangeHandler().isAlive())) {
            log.debug("Primary at wrong volume. Setting back to " + volumeGoal);
            primary.smoothVolumeChange(volumeGoal, changeRate);
        }
        if (primary.getCurrentTrack() == null || !weatherManager.getPrimarySoundPlayer().isPlaying()) {
            log.debug("Initializing soundplayer at volume " + (int)((double)this.config.ambientVolume() * this.getWeatherDensityFactor(weather)));
            primary.setVolumeLevel(0);
            primary.smoothVolumeChange(volumeGoal, changeRate);
            primary.playClip(appropriateSound);
        } else if (primary.getCurrentTrack() != appropriateSound || primary.getTimer() > 230) {
            log.debug("Looping because " + primary.getCurrentTrack() + " != " + appropriateSound + " or it was just time to loop");
            primary.smoothVolumeChange(0, changeRate);
            weatherManager.switchSoundPlayerPriority();
            if (!primary.isPlaying()) {
                primary.setVolumeLevel(0);
                primary.playClip(appropriateSound);
            }
            primary.smoothVolumeChange(volumeGoal, changeRate);
        }
        if (weather == Weather.STORMY && (primary.getTimer() == 90 || primary.getTimer() == 138)) {
            this.flashLightning = true;
        }
    }

    public int getObjectTarget(Weather weather) {
        switch (weather) {
            case ASHFALL: {
                return this.config.ashfallDensity();
            }
            case FOGGY: {
                return this.config.foggyDensity();
            }
            case RAINY: {
                return this.config.rainDensity();
            }
            case SNOWY: {
                return this.config.snowDensity();
            }
            case CLOUDY: {
                return this.config.cloudyDensity();
            }
            case STARRY: {
                return this.config.starryDensity();
            }
            case STORMY: {
                return this.config.stormDensity();
            }
            case PARTLY_CLOUDY: {
                return this.config.partlyCloudyDensity();
            }
        }
        return 0;
    }

    public int getVolumeGoal(boolean muffled, Weather weather) {
        double weatherDensityFactor = this.getWeatherDensityFactor(weather);
        double volumeDouble = (double)this.config.ambientVolume() * weatherDensityFactor;
        if (muffled) {
            volumeDouble = (double)this.config.muffledVolume() * weatherDensityFactor;
        }
        return (int)volumeDouble;
    }

    public double getWeatherDensityFactor(Weather weather) {
        double factor = (double)weather.getMaxObjects() / (double)weather.getMaxObjectVolume();
        if (factor > 1.0) {
            factor = 1.0;
        }
        return factor;
    }

    public boolean weatherEnabled(Weather weather) {
        switch (weather) {
            case ASHFALL: {
                return this.config.enableAsh();
            }
            case FOGGY: {
                return this.config.enableFog();
            }
            case RAINY: 
            case STORMY: {
                return this.config.enableRain();
            }
            case SNOWY: {
                return this.config.enableSnow();
            }
            case CLOUDY: 
            case PARTLY_CLOUDY: {
                return this.config.enableClouds();
            }
            case STARRY: {
                return this.config.enableStars();
            }
        }
        return true;
    }

    public void createWeatherManager() {
        SoundPlayer[] soundPlayers = new SoundPlayer[]{new SoundPlayer(), new SoundPlayer()};
        WeatherManager weatherManager = new WeatherManager(this.currentWeather, soundPlayers, 0, new ArrayList<WeatherObject>(), 0, false);
        this.weatherManagerList.add(weatherManager);
    }

    public void fadeWeatherManager(WeatherManager weatherManager) {
        ArrayList<WeatherObject> array;
        int trimNumber = weatherManager.getWeatherType().getMaxObjects() / 20;
        if (trimNumber < (array = weatherManager.getWeatherObjArray()).size() / 20) {
            trimNumber = array.size() / 20;
        }
        if (trimNumber == 0) {
            trimNumber = 1;
        }
        this.trimWeatherArray(weatherManager, 0, trimNumber);
    }

    public void clearFadedWeatherManagers() {
        for (int i = 0; i < this.weatherManagerList.size(); ++i) {
            WeatherManager weatherManager = this.weatherManagerList.get(i);
            if (!weatherManager.isFading() || !weatherManager.getWeatherObjArray().isEmpty()) continue;
            boolean readyToRemove = true;
            for (SoundPlayer soundPlayer : weatherManager.getSoundPlayers()) {
                if (!soundPlayer.isPlaying()) continue;
                readyToRemove = false;
            }
            if (!readyToRemove) continue;
            this.weatherManagerList.remove(weatherManager);
            --i;
        }
    }

    public void clearAllWeatherManagers() {
        for (WeatherManager weatherManager : this.weatherManagerList) {
            this.clearWeatherObjects(weatherManager);
            weatherManager.stopManagerSoundPlayers();
        }
        this.weatherManagerList.clear();
    }

    public void handleWeatherChanges(WeatherManager weatherManager) {
        int playerChunk;
        Weather weather = weatherManager.getWeatherType();
        if (this.config.weatherType() != CyclesConfig.WeatherType.DYNAMIC && this.config.disableWeatherUnderground() && (this.currentBiome == Biome.CAVE || this.currentBiome == Biome.LAVA_CAVE)) {
            return;
        }
        if (!this.weatherEnabled(weather)) {
            return;
        }
        if (!this.config.enableWintertodtSnow() && weather == Weather.SNOWY && (playerChunk = this.client.getLocalPlayer().getWorldLocation().getRegionID()) == 6462) {
            return;
        }
        int objectTarget = this.getObjectTarget(weather);
        ArrayList<WeatherObject> array = weatherManager.getWeatherObjArray();
        if (array.size() < objectTarget) {
            if (this.zoneObjRecovery > 0) {
                this.relocateObjects(weatherManager, objectTarget / 10);
                --this.zoneObjRecovery;
            }
            this.renderWeather(objectTarget / 20, weatherManager);
        } else if (array.size() == objectTarget && this.client.getTickCount() % weather.getChangeRate() == 0) {
            this.relocateObjects(weatherManager, objectTarget / 20);
        }
    }

    private void renderWeather(int objects, WeatherManager weatherManager) {
        Weather weather = weatherManager.getWeatherType();
        int z = this.client.getPlane();
        ArrayList<WeatherObject> array = weatherManager.getWeatherObjArray();
        Animation weatherAnimation = this.modelHandler.getWeatherAnimation(weather);
        int alternate = 1;
        ArrayList<Tile> availableTiles = this.getAvailableTiles();
        for (int i = 0; i < objects; ++i) {
            switch (weather) {
                default: 
            }
            int roll = this.random.nextInt(availableTiles.size());
            Tile openTile = availableTiles.get(roll);
            WeatherObject weatherObject = this.createWeatherObject(weather, weatherAnimation, openTile.getLocalLocation(), z, alternate);
            if (++alternate > weather.getModelVariety()) {
                alternate = 1;
            }
            array.add(weatherObject);
            if (array.size() != this.getObjectTarget(weather)) continue;
            return;
        }
    }

    public WeatherObject createWeatherObject(Weather weather, Animation weatherAnimation, LocalPoint lp, int plane, int objectVariant) {
        RuneLiteObject runeLiteObject = this.client.createRuneLiteObject();
        Model weatherModel = this.modelHandler.getWeatherModel(weather, objectVariant);
        int radius = this.modelHandler.getModelRadius(weather);
        runeLiteObject.setModel(weatherModel);
        runeLiteObject.setRadius(radius);
        runeLiteObject.setDrawFrontTilesFirst(true);
        runeLiteObject.setAnimation(weatherAnimation);
        runeLiteObject.setLocation(lp, plane);
        runeLiteObject.setShouldLoop(true);
        runeLiteObject.setActive(true);
        return new WeatherObject(runeLiteObject, objectVariant);
    }

    public void removeWeatherObject(int index, ArrayList<WeatherObject> weatherArray) {
        if (index >= weatherArray.size()) {
            return;
        }
        WeatherObject weatherObject = weatherArray.get(index);
        weatherObject.getRuneLiteObject().setActive(false);
        weatherArray.remove(index);
    }

    public void clearWeatherObjects(WeatherManager weatherManager) {
        ArrayList<WeatherObject> array = weatherManager.getWeatherObjArray();
        for (WeatherObject weatherObject : array) {
            weatherObject.getRuneLiteObject().setActive(false);
        }
        array.clear();
    }

    public void trimWeatherArray(WeatherManager weatherManager, int start, int end) {
        for (int i = start; i < end; ++i) {
            this.removeWeatherObject(start, weatherManager.getWeatherObjArray());
        }
    }

    public void relocateObjects(WeatherManager weatherManager, int numToRelocate) {
        int z = this.client.getPlane();
        int beginRotation = weatherManager.getStartRotation();
        ArrayList<WeatherObject> array = weatherManager.getWeatherObjArray();
        Weather weather = weatherManager.getWeatherType();
        ArrayList<Tile> availableTiles = this.getAvailableTiles();
        for (int i = beginRotation; i < beginRotation + numToRelocate; ++i) {
            switch (weather) {
                default: 
            }
            int roll = this.random.nextInt(availableTiles.size());
            Tile nextTile = availableTiles.get(roll);
            if (i >= array.size()) break;
            WeatherObject weatherObject = array.get(i);
            RuneLiteObject runeLiteObject = weatherObject.getRuneLiteObject();
            runeLiteObject.setLocation(nextTile.getLocalLocation(), z);
            runeLiteObject.setAnimation(this.modelHandler.getWeatherAnimation(weather));
        }
        weatherManager.setStartRotation(beginRotation + numToRelocate);
        if (beginRotation > this.getObjectTarget(weather)) {
            weatherManager.setStartRotation(0);
        }
    }

    public void transitionZPlane() {
        if (!this.currentWeather.isHasPrecipitation()) {
            this.clearAllWeatherManagers();
            return;
        }
        this.handleZoneTransition();
    }

    public void handleZoneTransition() {
        if (this.config.weatherType() != CyclesConfig.WeatherType.DYNAMIC && this.config.disableWeatherUnderground() && (this.currentBiome == Biome.CAVE || this.currentBiome == Biome.LAVA_CAVE)) {
            this.clientThread.invoke(this::clearAllWeatherManagers);
            return;
        }
        for (WeatherManager weatherManager : this.weatherManagerList) {
            Weather weatherType = weatherManager.getWeatherType();
            ArrayList<WeatherObject> array = weatherManager.getWeatherObjArray();
            int size = (int)((double)array.size() * 0.8);
            this.clearWeatherObjects(weatherManager);
            if (weatherType != this.currentWeather) continue;
            this.renderWeather(size, weatherManager);
            this.zoneObjRecovery = 4;
        }
    }

    public ArrayList<Tile> getAvailableTiles() {
        Scene scene = this.client.getScene();
        Tile[][][] tiles = scene.getTiles();
        byte[][][] settings = this.client.getTileSettings();
        int zLayer = this.client.getPlane();
        ArrayList<Tile> availableTiles = new ArrayList<Tile>();
        for (int z = 0; z <= zLayer; ++z) {
            for (int x = 0; x < 104; ++x) {
                for (int y = 0; y < 104; ++y) {
                    byte flag;
                    Tile tile = tiles[z][x][y];
                    if (tile == null || ((flag = settings[z][x][y]) & 4) != 0) continue;
                    availableTiles.add(tile);
                }
            }
        }
        return availableTiles;
    }

    private boolean wallCollision(Tile targetTile) {
        Scene scene = this.client.getScene();
        Tile[][][] tiles = scene.getTiles();
        int zLayer = this.client.getPlane();
        for (int z = 0; z <= zLayer; ++z) {
            for (int x = 0; x < 104; ++x) {
                for (int y = 0; y < 104; ++y) {
                    Tile tile = tiles[z][x][y];
                    if (tile == null || tile.getWallObject() == null || tile.getLocalLocation().distanceTo(targetTile.getLocalLocation()) >= 100) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void setConfigWeather() {
        switch (this.config.weatherType()) {
            case ASHFALL: {
                this.currentWeather = Weather.ASHFALL;
                break;
            }
            default: {
                this.currentWeather = this.syncWeather(this.currentSeason, this.currentBiome);
                break;
            }
            case CLOUDY: {
                this.currentWeather = Weather.CLOUDY;
                break;
            }
            case CLEAR: {
                this.currentWeather = Weather.SUNNY;
                break;
            }
            case FOGGY: {
                this.currentWeather = Weather.FOGGY;
                break;
            }
            case PARTLY_CLOUDY: {
                this.currentWeather = Weather.PARTLY_CLOUDY;
                break;
            }
            case RAINY: {
                this.currentWeather = Weather.RAINY;
                break;
            }
            case SNOWY: {
                this.currentWeather = Weather.SNOWY;
                break;
            }
            case STARRY: {
                this.currentWeather = Weather.STARRY;
                break;
            }
            case STORMY: {
                this.currentWeather = Weather.STORMY;
            }
        }
    }

    private Weather syncWeather(Season seasonCondition, Biome biomeCondition) {
        int totalMin = CyclesClock.getTimeHours() * 60 + CyclesClock.getTimeMinutes();
        int cycleSegment = totalMin / 15 % 12;
        for (WeatherForecast forecast : WeatherForecast.values()) {
            if (forecast.getSeasonCondition() != seasonCondition || forecast.getBiomeCondition() != biomeCondition) continue;
            return forecast.getForecastArray()[cycleSegment];
        }
        return Weather.COVERED;
    }

    private void syncBiome() {
        WorldPoint wp = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)this.client.getLocalPlayer().getLocalLocation(), (int)this.client.getPlane());
        int playerChunk = wp.getRegionID();
        if (this.savedChunk != playerChunk) {
            this.currentBiome = BiomeChunkMap.checkBiome(playerChunk);
            this.savedChunk = playerChunk;
        }
        if (this.winter117 && this.currentBiome != Biome.CAVE && this.currentBiome != Biome.LAVA_CAVE) {
            this.currentBiome = Biome.ARCTIC;
            this.savedChunk = -1;
        }
    }

    private void syncSeason() {
        if (this.config.themes117()) {
            Collection plugins = this.pluginManager.getPlugins();
            for (Plugin plugin : plugins) {
                if (!plugin.getName().equals("117 HD") || !this.pluginManager.isPluginEnabled(plugin)) continue;
                try {
                    String seasonalTheme;
                    switch (seasonalTheme = (String)this.configManager.getConfiguration("hd", "KEY_SEASONAL_THEME", String.class)) {
                        case "DEFAULT_THEME": {
                            break;
                        }
                        case "WINTER_THEME": {
                            this.currentSeason = Season.WINTER;
                            this.winter117 = true;
                            break;
                        }
                        case "AUTUMN_THEME": {
                            this.currentSeason = Season.AUTUMN;
                            this.winter117 = false;
                        }
                    }
                }
                catch (Exception exception) {}
            }
        }
        this.winter117 = false;
        switch (this.config.seasonType()) {
            default: {
                switch (CyclesClock.getTimeDays() / 7 % 4) {
                    default: {
                        this.currentSeason = Season.SPRING;
                        return;
                    }
                    case 1: {
                        this.currentSeason = Season.SUMMER;
                        return;
                    }
                    case 2: {
                        this.currentSeason = Season.AUTUMN;
                        return;
                    }
                    case 3: 
                }
                this.currentSeason = Season.WINTER;
                return;
            }
            case SPRING: {
                this.currentSeason = Season.SPRING;
                return;
            }
            case SUMMER: {
                this.currentSeason = Season.SUMMER;
                return;
            }
            case AUTUMN: {
                this.currentSeason = Season.AUTUMN;
                return;
            }
            case WINTER: 
        }
        this.currentSeason = Season.WINTER;
    }

    @Provides
    CyclesConfig provideConfig(ConfigManager configManager) {
        return (CyclesConfig)configManager.getConfig(CyclesConfig.class);
    }

    public Season getCurrentSeason() {
        return this.currentSeason;
    }

    public Biome getCurrentBiome() {
        return this.currentBiome;
    }

    public Weather getCurrentWeather() {
        return this.currentWeather;
    }
}

