/*
 * Decompiled with CFR 0.152.
 */
package com.weather3d;

import com.weather3d.CyclesConfig;
import com.weather3d.CyclesPlugin;
import com.weather3d.conditions.Biome;
import com.weather3d.conditions.Season;
import com.weather3d.conditions.Weather;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.ImageComponent;

public class CyclesOverlay
extends OverlayPanel {
    private final Client client;
    private final CyclesPlugin plugin;
    private final CyclesConfig config;

    @Inject
    private CyclesOverlay(Client client, CyclesPlugin plugin, CyclesConfig config) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.ABOVE_CHATBOX_RIGHT);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.config.toggleOverlay()) {
            return null;
        }
        Weather weather = this.plugin.getCurrentWeather();
        Biome biome = this.plugin.getCurrentBiome();
        Season season = this.plugin.getCurrentSeason();
        if (this.config.miniOverlay()) {
            this.renderMiniOverlay(weather, biome, season);
        } else {
            this.renderOverlay(weather, biome, season);
        }
        return super.render(graphics);
    }

    private void renderOverlay(Weather weather, Biome biome, Season season) {
        this.panelComponent.getChildren().add(new ImageComponent(weather.getConditionImage()));
        this.panelComponent.getChildren().add(new ImageComponent(biome.getConditionImage()));
        this.panelComponent.getChildren().add(new ImageComponent(season.getConditionImage()));
    }

    private void renderMiniOverlay(Weather weather, Biome biome, Season season) {
        this.panelComponent.getChildren().add(new ImageComponent(weather.getMiniConditionImage()));
        this.panelComponent.getChildren().add(new ImageComponent(biome.getMiniConditionImage()));
        this.panelComponent.getChildren().add(new ImageComponent(season.getMiniConditionImage()));
    }
}

