/*
 * Decompiled with CFR 0.152.
 */
package com.weather3d;

import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Range;
import net.runelite.client.config.Units;

@ConfigGroup(value="3Dweather")
public interface CyclesConfig
extends Config {
    @ConfigSection(name="General", description="General settings", position=0)
    public static final String generalSettings = "generalSettings";
    @ConfigSection(name="Audio", description="Audio settings", position=6)
    public static final String audioSettings = "audioSettings";
    @ConfigSection(name="Weathers", description="Weather Options", position=11)
    public static final String weatherToggles = "weatherToggles";
    @ConfigSection(name="Other", description="Other Settings", position=28)
    public static final String otherSettings = "otherSettings";

    @ConfigItem(keyName="weatherType", name="Weather Type", description="Determines the current Weather (Dynamic automatically cycles based on Season and Biome)", section="generalSettings", position=1)
    default public WeatherType weatherType() {
        return WeatherType.DYNAMIC;
    }

    @ConfigItem(keyName="seasonType", name="Season Type", description="Determines the current Season and its Weather cycle (only relevant if Weather Type is Dynamic)", section="generalSettings", position=2)
    default public SeasonType seasonType() {
        return SeasonType.DYNAMIC;
    }

    @ConfigItem(keyName="toggleOverlay", name="Enable Overlay", description="Displays an overlay indicating Weather, Biome, and Season", section="generalSettings", position=3)
    default public boolean toggleOverlay() {
        return true;
    }

    @ConfigItem(keyName="miniOverlay", name="Enable Mini Overlay", description="Displays a mini overlay indicating Weather, Biome, and Season", section="generalSettings", position=4)
    default public boolean miniOverlay() {
        return false;
    }

    @ConfigItem(keyName="disableWeatherUnderground", name="Disable Weather Underground", description="Prevents Weather from occurring while in Cave or Lava Cave Biomes, regardless of the set Weather Type", section="generalSettings", position=5)
    default public boolean disableWeatherUnderground() {
        return true;
    }

    @ConfigItem(keyName="toggleAmbience", name="Enable Ambience", description="Toggles ambient Weather sounds on/off", section="audioSettings", position=7)
    default public boolean toggleAmbience() {
        return true;
    }

    @ConfigItem(keyName="ambientVolume", name="Ambient Volume", description="Sets the volume of ambient Weather sounds", section="audioSettings", position=8)
    @Units(value="%")
    @Range(max=100)
    default public int ambientVolume() {
        return 50;
    }

    @ConfigItem(keyName="muffledVolume", name="Muffled Volume", description="Sets the volume of muffled Weather sounds while indoors", section="audioSettings", position=9)
    @Units(value="%")
    @Range(max=100)
    default public int muffledVolume() {
        return 50;
    }

    @ConfigItem(keyName="disableIndoorMuffling", name="Disable Indoor Muffling", description="Prevents ambience sound from being muffled while standing indoors.", section="audioSettings", position=10)
    default public boolean disableIndoorMuffling() {
        return false;
    }

    @ConfigItem(keyName="enableRain", name="Rain Enabled", description="Allows Rain objects to appear while Rainy or Stormy", section="weatherToggles", position=12)
    default public boolean enableRain() {
        return true;
    }

    @ConfigItem(keyName="rainDensity", name="Rain Density", description="Sets the number of Rain objects that spawn while Rainy", section="weatherToggles", position=13)
    @Range(max=2000)
    default public int rainDensity() {
        return 400;
    }

    @ConfigItem(keyName="stormDensity", name="Storm Density", description="Sets the number of Rain objects that spawn while Stormy", section="weatherToggles", position=14)
    @Range(max=3000)
    default public int stormDensity() {
        return 600;
    }

    @ConfigItem(keyName="enableSnow", name="Snow Enabled", description="Allows Snow objects to appear while Snowy", section="weatherToggles", position=15)
    default public boolean enableSnow() {
        return true;
    }

    @ConfigItem(keyName="snowDensity", name="Snow Density", description="Sets the number of Snow objects that spawn while Snowy", section="weatherToggles", position=16)
    @Range(max=2000)
    default public int snowDensity() {
        return 400;
    }

    @ConfigItem(keyName="enableClouds", name="Clouds Enabled", description="Allows Cloud objects to appear while Cloudy or Partly Cloudy", section="weatherToggles", position=17)
    default public boolean enableClouds() {
        return true;
    }

    @ConfigItem(keyName="cloudyDensity", name="Cloud Density", description="Sets the number of Cloud objects that spawn while Cloudy", section="weatherToggles", position=18)
    @Range(max=1000)
    default public int cloudyDensity() {
        return 200;
    }

    @ConfigItem(keyName="partlyCloudyDensity", name="Partly Cloudy Density", description="Sets the number of Cloud objects that spawn while Partly Cloudy", section="weatherToggles", position=19)
    @Range(max=300)
    default public int partlyCloudyDensity() {
        return 50;
    }

    @ConfigItem(keyName="enableAsh", name="Ash Enabled", description="Allows Ash objects to appear while in Ashfall", section="weatherToggles", position=20)
    default public boolean enableAsh() {
        return false;
    }

    @ConfigItem(keyName="ashfallDensity", name="Ashfall Density", description="Sets the number of Ash objects that spawn while in Ashfall", section="weatherToggles", position=21)
    @Range(max=1200)
    default public int ashfallDensity() {
        return 200;
    }

    @ConfigItem(keyName="enableFog", name="Fog Enabled", description="Allows Fog objects to appear while Foggy", section="weatherToggles", position=22)
    default public boolean enableFog() {
        return false;
    }

    @ConfigItem(keyName="foggyDensity", name="Fog Density", description="Sets the number of Fog objects that spawn while Foggy", section="weatherToggles", position=23)
    @Range(max=1800)
    default public int foggyDensity() {
        return 500;
    }

    @ConfigItem(keyName="enableStars", name="Stars Enabled", description="Allows Star objects to appear while in other Realms", section="weatherToggles", position=24)
    default public boolean enableStars() {
        return true;
    }

    @ConfigItem(keyName="starryDensity", name="Stars Density", description="Sets the number of Star objects that spawn while Starry", section="weatherToggles", position=25)
    @Range(max=2000)
    default public int starryDensity() {
        return 400;
    }

    @ConfigItem(keyName="enableWintertodtSnow", name="Enable Wintertodt Snow", description="Allows Snow objects to appear at Wintertodt while Snowing (may make it difficult to see incoming attacks)", section="weatherToggles", position=26)
    default public boolean enableWintertodtSnow() {
        return true;
    }

    @ConfigItem(keyName="enableLightning", name="Enable Lightning", description="PHOTOSENSITIVITY WARNING - Allows Lightning flashes to occur during Stormy weather", section="weatherToggles", position=27)
    default public boolean enableLightning() {
        return false;
    }

    @ConfigItem(keyName="117Themes", name="Allow 117 Theme Overrides", description="Allows 117HD to override current Season with its relevant seasonal theme", section="otherSettings", position=29)
    default public boolean themes117() {
        return true;
    }

    public static enum SeasonType {
        DYNAMIC,
        SPRING,
        SUMMER,
        AUTUMN,
        WINTER;

    }

    public static enum WeatherType {
        DYNAMIC,
        ASHFALL,
        CLEAR,
        CLOUDY,
        FOGGY,
        PARTLY_CLOUDY,
        RAINY,
        SNOWY,
        STARRY,
        STORMY;

    }
}

