/*
 * Decompiled with CFR 0.152.
 */
package com.baplus;

import com.baplus.Role;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalUnit;
import javax.inject.Inject;
import net.runelite.client.util.RSTimeUnit;

class Round {
    private final Instant roundStartTime;
    private final Role roundRole;
    private boolean runnersKilled;
    private boolean rangersKilled;
    private boolean healersKilled;
    private boolean fightersKilled;

    @Inject
    public Round(Role role) {
        this.roundRole = role;
        this.roundStartTime = Instant.now().plus(Duration.of(2L, (TemporalUnit)RSTimeUnit.GAME_TICKS));
    }

    public long getRoundTime() {
        return Duration.between(this.roundStartTime, Instant.now()).getSeconds();
    }

    public long getTimeToChange() {
        return 30L + Duration.between(Instant.now(), this.roundStartTime).getSeconds() % 30L;
    }

    public Role getRoundRole() {
        return this.roundRole;
    }

    public boolean isRunnersKilled() {
        return this.runnersKilled;
    }

    public void setRunnersKilled(boolean runnersKilled) {
        this.runnersKilled = runnersKilled;
    }

    public boolean isRangersKilled() {
        return this.rangersKilled;
    }

    public void setRangersKilled(boolean rangersKilled) {
        this.rangersKilled = rangersKilled;
    }

    public boolean isHealersKilled() {
        return this.healersKilled;
    }

    public void setHealersKilled(boolean healersKilled) {
        this.healersKilled = healersKilled;
    }

    public boolean isFightersKilled() {
        return this.fightersKilled;
    }

    public void setFightersKilled(boolean fightersKilled) {
        this.fightersKilled = fightersKilled;
    }
}

