/*
 * Decompiled with CFR 0.152.
 */
package com.baplus;

import com.baplus.BAPlusConfig;
import com.baplus.GameTimer;
import com.baplus.Role;
import com.baplus.Round;
import com.baplus.RunCategory;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Provides;
import java.awt.Color;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.MessageNode;
import net.runelite.api.Model;
import net.runelite.api.TileItem;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ItemSpawned;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.HotkeyListener;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="BA Plus", description="Adds speedrunning and general qol improvements to the base BA plugin", tags={"ba", "barb assault", "barbarian assault", "speedrunning"})
public class BAPlusPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(BAPlusPlugin.class);
    private final int BA_GREEN_EGG_ID = 10531;
    private final int BA_RED_EGG_ID = 10532;
    private final int BA_BLUE_EGG_ID = 10533;
    private final int BA_YELLOW_EGG_ID = 10534;
    private final int BA_POISONED_EGG_ID = 10535;
    private final int BA_SPIKED_EGG_ID = 10536;
    private final int BA_OMEGA_EGG_ID = 10537;
    private final int WHITE_TO_RED = 896;
    private final int WHITE_TO_GREEN = 22400;
    private final int WHITE_TO_BLUE = 43392;
    private final int RED_TO_YELLOW = -56320;
    private final int YELLOW_RED_DIVIDE = 60466;
    private final int SATURATION_LIMIT = 128;
    private final int RED_BRIGHTNESS_LIMIT = 940;
    private final int RED_ADJUST = 920;
    private final int RED_SHADOW_LIMIT = 918;
    private final int RED_SHADOW_ADJUST = 917;
    private final int GREEN_BRIGHTNESS_LIMIT = 22450;
    private final int GREEN_ADJUST = 22418;
    private final int GREEN_SHADOW_FACE_MAX_INDEX = 45;
    private final int GREEN_SHADOW_ADJUST = 22408;
    private final int BLUE_BRIGHTNESS_LIMIT = 43426;
    private final int BLUE_ADJUST = 43426;
    private final int BLUE_SHADOW_LIMIT = 43420;
    private final int BLUE_SHADOW_ADJUST = 43418;
    private static final int BA_WAVE_NUM_INDEX = 2;
    private static final int BA_MONSTER_DEATH_INDEX = 5;
    private static final int BA_WAVE_COUNT = 10;
    private static final int CALL_FLASH_WIDGET_ID = 3;
    private static final String START_WAVE = "1";
    private static final String ENDGAME_REWARD_NEEDLE_TEXT = "<br>5";
    private static final String CONFIG_GROUP = "barbarianAssault";
    final int[] childIDsOfPointsWidgets = new int[]{33, 32, 25, 26, 24, 28, 31, 27, 29, 30, 21, 22, 19};
    private int pointsHealer;
    private int pointsDefender;
    private int pointsCollector;
    private int pointsAttacker;
    private int totalEggsCollected;
    private int totalIncorrectAttacks;
    private int totalHealthReplenished;
    private static final Gson GSON = new Gson();
    private int inGameBit = 0;
    private String currentWave = "1";
    private GameTimer gameTime;
    private String[] waveGoal = new String[]{"0:30", "0:37", "0:43", "0:42", "0:48", "1:01", "1:09", "1:12", "1:21", "1:48"};
    private String[] lastRun = new String[]{"", "", "", "", "", "", "", "", "", ""};
    private Round currentRound;
    @Inject
    private Client client;
    @Inject
    private KeyManager keyManager;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private ConfigManager configManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private BAPlusConfig config;
    private final HotkeyListener previousKeyListener = new HotkeyListener(() -> this.config.saveLastRunAsPB()){

        public void hotkeyPressed() {
            if (BAPlusPlugin.this.config.category() == RunCategory.SOLOHEALPB || BAPlusPlugin.this.config.category() == RunCategory.DUOHEALPB || BAPlusPlugin.this.config.category() == RunCategory.LEECHPB) {
                BAPlusPlugin.this.saveTime(BAPlusPlugin.this.config.category(), BAPlusPlugin.this.lastRun);
                BAPlusPlugin.this.announceMessage("Personal best saved for run type: " + BAPlusPlugin.this.config.category().toString() + ".");
            } else {
                BAPlusPlugin.this.announceMessage("Unable to save personal best - Invalid run type: " + BAPlusPlugin.this.config.category().toString() + ", save as a PB.");
            }
        }
    };
    private final HotkeyListener nextKeyListener = new HotkeyListener(() -> this.config.saveCustomAsPB()){

        public void hotkeyPressed() {
            if (BAPlusPlugin.this.config.category() == RunCategory.SOLOHEALPB || BAPlusPlugin.this.config.category() == RunCategory.DUOHEALPB || BAPlusPlugin.this.config.category() == RunCategory.LEECHPB) {
                BAPlusPlugin.this.saveTime(BAPlusPlugin.this.config.category(), BAPlusPlugin.this.parseWaveTimesFromString(BAPlusPlugin.this.config.getDesiredWaveSplits()));
                BAPlusPlugin.this.announceMessage("Personal best saved for run type: " + BAPlusPlugin.this.config.category().toString() + ".");
            } else if (BAPlusPlugin.this.config.category() == RunCategory.CUSTOM) {
                BAPlusPlugin.this.waveGoal = BAPlusPlugin.this.parseWaveTimesFromString(BAPlusPlugin.this.config.getDesiredWaveTimes());
                if (BAPlusPlugin.this.waveGoal.length >= 10) {
                    BAPlusPlugin.this.announceMessage("Saved new goal times: " + BAPlusPlugin.this.waveGoal[0] + ", " + BAPlusPlugin.this.waveGoal[1] + ", " + BAPlusPlugin.this.waveGoal[2] + ", " + BAPlusPlugin.this.waveGoal[3] + ", " + BAPlusPlugin.this.waveGoal[4] + ", " + BAPlusPlugin.this.waveGoal[5] + ", " + BAPlusPlugin.this.waveGoal[6] + ", " + BAPlusPlugin.this.waveGoal[7] + ", " + BAPlusPlugin.this.waveGoal[8] + ", " + BAPlusPlugin.this.waveGoal[9]);
                } else {
                    BAPlusPlugin.this.announceMessage("Error parsing wave end times, invalid input.");
                }
            } else {
                BAPlusPlugin.this.announceMessage("Unable to save personal best - Invalid run type: " + BAPlusPlugin.this.config.category().toString() + ", save as a PB.");
            }
        }
    };

    @Provides
    BAPlusConfig provideConfig(ConfigManager configManager) {
        return (BAPlusConfig)configManager.getConfig(BAPlusConfig.class);
    }

    protected void startUp() throws Exception {
        this.keyManager.registerKeyListener((KeyListener)this.previousKeyListener);
        this.keyManager.registerKeyListener((KeyListener)this.nextKeyListener);
        this.saveTime(RunCategory.SOLOHEALWR, new String[]{"0:30", "1:10", "1:55", "2:41", "3:36", "4:39", "5:50", "7:06", "8:30", "10:18"});
        this.saveTime(RunCategory.DUOHEALWR, new String[]{"0:30", "1:11", "1:57", "2:41", "3:33", "4:34", "5:38", "6:48", "8:11", "9:57"});
        this.saveTime(RunCategory.LEECHWR, new String[]{"0:32", "1:14", "2:04", "2:55", "3:52", "4:57", "6:10", "7:27", "8:56", "10:50"});
        this.saveTime(RunCategory.CUSTOM, this.parseWaveTimesFromString(this.config.getDesiredWaveSplits()));
        if (this.config.category() == RunCategory.CUSTOM && this.parseWaveTimesFromString(this.config.getDesiredWaveTimes()).length == 10) {
            this.waveGoal = this.parseWaveTimesFromString(this.config.getDesiredWaveTimes());
        }
        log.debug("Startup");
    }

    protected void shutDown() throws Exception {
        this.gameTime = null;
        this.currentWave = START_WAVE;
        this.inGameBit = 0;
    }

    @Subscribe
    public void onItemSpawned(ItemSpawned itemSpawned) {
        TileItem item;
        int itemID;
        if (this.config.legacyEggModels() && (itemID = (item = itemSpawned.getItem()).getId()) >= 10531 && itemID <= 10537) {
            this.recolorEggFaces(item.getModel(), itemID);
        }
    }

    private void recolorEggFaces(Model model, int itemID) {
        System.out.println("recolorEggFaces: " + itemID);
        switch (itemID) {
            case 10531: {
                this.replaceFaceColorValues(model, 128, 22400, 22450, 22418);
                break;
            }
            case 10532: {
                this.replaceFaceColorValues(model, 128, 896, 940, 920);
                break;
            }
            case 10533: {
                this.replaceFaceColorValues(model, 128, 43392, 43426, 43426);
                break;
            }
            case 10534: {
                this.replaceFaceColorValues(model, 0, -56320, 60466, 0);
                break;
            }
        }
    }

    private void replaceFaceColorValues(Model model, int saturationLimit, int correctionValue, int brightnessLimit, int adjust) {
        int[] faceColors1 = model.getFaceColors1();
        int[] faceColors2 = model.getFaceColors2();
        int[] faceColors3 = model.getFaceColors3();
        if (faceColors3.length != faceColors1.length || faceColors3.length != faceColors2.length || faceColors1.length != faceColors2.length) {
            System.out.println("Model face array length mismatch");
            return;
        }
        try {
            for (int i = 0; i < faceColors1.length; ++i) {
                if (faceColors1[i] < saturationLimit) {
                    int n = i;
                    faceColors1[n] = faceColors1[n] + correctionValue;
                } else if (faceColors1[i] > brightnessLimit && saturationLimit != 0) {
                    faceColors1[i] = adjust;
                }
                if (faceColors2[i] < saturationLimit) {
                    int n = i;
                    faceColors2[n] = faceColors2[n] + correctionValue;
                } else if (faceColors2[i] > brightnessLimit && saturationLimit != 0) {
                    faceColors2[i] = adjust;
                }
                if (faceColors3[i] < saturationLimit) {
                    int n = i;
                    faceColors3[n] = faceColors3[n] + correctionValue;
                } else if (faceColors3[i] > brightnessLimit && saturationLimit != 0) {
                    faceColors3[i] = adjust;
                }
                if (faceColors1[i] >= 60466) {
                    faceColors1[i] = faceColors1[i] + -56320;
                }
                if (faceColors2[i] >= 60466) {
                    faceColors2[i] = faceColors2[i] + -56320;
                }
                if (faceColors3[i] < 60466) continue;
                faceColors3[i] = faceColors3[i] + -56320;
            }
        }
        catch (Exception ex) {
            System.out.println("--- BAPlusPlugin.replaceColorFaceValues() ---\n" + ex.getClass().toString() + " exception: " + ex.getMessage());
            log.debug("--- BAPlusPlugin.replaceColorFaceValues() ---\n" + ex.getClass().toString() + " exception: " + ex.getMessage());
        }
        System.out.println("Done recoloring");
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        switch (event.getGroupId()) {
            case 497: {
                int wavePoints_Collector;
                Widget rewardWidget = this.client.getWidget(WidgetInfo.BA_REWARD_TEXT);
                Widget pointsWidget = this.client.getWidget(497, 14);
                if (rewardWidget != null && rewardWidget.getText().contains(ENDGAME_REWARD_NEEDLE_TEXT) && this.gameTime != null) {
                    this.gameTime = null;
                    ChatMessageBuilder message = new ChatMessageBuilder().append("Attacker: ").append(Color.red, "" + (this.pointsAttacker + 80)).append(" |  Healer: ").append(Color.GREEN, "" + (this.pointsHealer + 80)).append(" | Defender: ").append(Color.blue, "" + (this.pointsDefender + 80)).append(" | Collector: ").append(Color.yellow, "" + (this.pointsCollector + 80)).append(System.getProperty("line.separator")).append(this.totalEggsCollected + " eggs collected, " + this.totalHealthReplenished + "HP vialed and " + this.totalIncorrectAttacks + " wrong attacks.");
                    if (!this.config.pointBreakdown()) break;
                    this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(message.build()).build());
                    break;
                }
                if (pointsWidget == null || this.client.getVar(3923) != 0) break;
                int wavePoints_Healer = wavePoints_Collector = Integer.parseInt(this.client.getWidget(497, this.childIDsOfPointsWidgets[0]).getText());
                int wavePoints_Defender = wavePoints_Collector;
                int wavePoints_Attacker = wavePoints_Collector;
                int waveFailedAttacks = 0;
                int waveHPReplenished = 0;
                int waveEggsCollected = 0;
                block16: for (int i = 0; i < this.childIDsOfPointsWidgets.length; ++i) {
                    int value = Integer.parseInt(this.client.getWidget(497, this.childIDsOfPointsWidgets[i]).getText());
                    switch (i) {
                        case 1: 
                        case 2: 
                        case 3: {
                            wavePoints_Attacker += value;
                            continue block16;
                        }
                        case 4: 
                        case 5: {
                            wavePoints_Defender += value;
                            continue block16;
                        }
                        case 6: {
                            wavePoints_Collector += value;
                            continue block16;
                        }
                        case 7: 
                        case 8: 
                        case 9: {
                            wavePoints_Healer += value;
                            continue block16;
                        }
                        case 10: {
                            waveEggsCollected = value;
                            this.totalEggsCollected += value;
                            continue block16;
                        }
                        case 11: {
                            waveFailedAttacks = value;
                            this.totalIncorrectAttacks += value;
                            continue block16;
                        }
                        case 12: {
                            waveHPReplenished = value;
                            this.totalHealthReplenished += value;
                        }
                    }
                }
                this.pointsCollector += wavePoints_Collector;
                this.pointsHealer += wavePoints_Healer;
                this.pointsDefender += wavePoints_Defender;
                this.pointsAttacker += wavePoints_Attacker;
                ChatMessageBuilder message = new ChatMessageBuilder().append("Attacker: ").append(Color.red, "" + wavePoints_Attacker).append(" |  Healer: ").append(Color.GREEN, "" + wavePoints_Healer).append(" | Defender: ").append(Color.blue, "" + wavePoints_Defender).append(" | Collector: ").append(Color.yellow, "" + wavePoints_Collector).append(System.getProperty("line.separator")).append(waveEggsCollected + " eggs collected, " + waveHPReplenished + "HP vialed and " + waveFailedAttacks + " wrong attacks.");
                if (!this.config.wavePointBreakdown()) break;
                this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(message.build()).build());
                break;
            }
            case 485: {
                this.setRound(Role.ATTACKER);
                this.disableCallFlash(Role.ATTACKER);
                break;
            }
            case 487: {
                this.setRound(Role.DEFENDER);
                this.disableCallFlash(Role.DEFENDER);
                break;
            }
            case 488: {
                this.setRound(Role.HEALER);
                this.disableCallFlash(Role.HEALER);
                break;
            }
            case 486: {
                this.setRound(Role.COLLECTOR);
                this.disableCallFlash(Role.COLLECTOR);
            }
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() == ChatMessageType.GAMEMESSAGE && event.getMessage().startsWith("---- Wave:")) {
            String[] message = event.getMessage().split(" ");
            this.currentWave = message[2];
            if (this.currentWave.equals(START_WAVE)) {
                this.gameTime = new GameTimer();
                this.totalHealthReplenished = 0;
                this.totalIncorrectAttacks = 0;
                this.totalEggsCollected = 0;
                this.pointsAttacker = 0;
                this.pointsCollector = 0;
                this.pointsDefender = 0;
                this.pointsHealer = 0;
            } else if (this.gameTime != null) {
                this.gameTime.setWaveStartTime();
            }
        } else if (event.getMessage().startsWith("All of the Penance") && this.gameTime != null && this.inGameBit != 0 && this.config.monsterTimer()) {
            MessageNode node = event.getMessageNode();
            String nodeValue = Text.removeTags((String)node.getValue());
            node.setValue(nodeValue + " (<col=ff8000>" + this.timeToSeconds(this.gameTime.getTime(true)) + "s<col=ffffff>)");
            this.chatMessageManager.update(node);
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        int inGame = this.client.getVar(3923);
        if (this.inGameBit != inGame && this.inGameBit == 1) {
            this.currentRound = null;
            if (this.config.waveTimes() && this.gameTime != null && this.client.isInInstancedRegion()) {
                int curWave = 0;
                try {
                    curWave = Integer.parseInt(this.currentWave);
                }
                catch (NumberFormatException nfex) {
                    return;
                }
                this.waveEnd(curWave, this.gameTime.getTime(false));
            }
        }
        this.inGameBit = inGame;
    }

    private void setRound(Role role) {
        if (this.currentRound == null) {
            this.currentRound = new Round(role);
        }
    }

    private void waveEnd(int waveNum, String time) {
        if (waveNum < 1 || waveNum > 10) {
            this.announceMessage("waveNum: " + waveNum);
            return;
        }
        if (waveNum == 1) {
            for (int i = 0; i < this.lastRun.length; ++i) {
                this.lastRun[i] = "";
            }
        }
        this.lastRun[waveNum - 1] = time;
        if (this.config.waveTimes()) {
            this.announceTime(waveNum, this.gameTime.getTime(true));
        }
        if (this.config.waveSplits()) {
            this.announceTime(waveNum, this.config.category(), time);
        }
    }

    private void disableCallFlash(Role role) {
        if (this.config.disableCallFlashing()) {
            switch (role) {
                case ATTACKER: {
                    Widget atkFlashWidget = this.client.getWidget(485, 3);
                    atkFlashWidget.setOpacity(255);
                    break;
                }
                case DEFENDER: {
                    Widget defFlashWidget = this.client.getWidget(487, 3);
                    defFlashWidget.setOpacity(255);
                    break;
                }
                case COLLECTOR: {
                    Widget colFlashWidget = this.client.getWidget(486, 3);
                    colFlashWidget.setOpacity(255);
                    break;
                }
                case HEALER: {
                    Widget healFlashWidget = this.client.getWidget(488, 3);
                    healFlashWidget.setOpacity(255);
                    break;
                }
            }
        }
    }

    private void announceTime(int waveNum, String time) {
        if (waveNum < 1 || waveNum > 10) {
            String errormsg = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append("Invalid waveNum: " + waveNum).build();
            this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(errormsg).build());
            return;
        }
        String timeMessage = "";
        if (this.config.waveTimes()) {
            timeMessage = this.config.waveCompare() ? new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Wave " + waveNum + " goal: ").append(Color.BLUE, this.waveGoal[waveNum - 1]).append(ChatColorType.NORMAL).append(" || Duration: ").append(this.compareSplitColor(time, this.waveGoal[waveNum - 1]), time).build() : new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Wave " + waveNum + " duration: ").append(ChatColorType.HIGHLIGHT).append(time).build();
            this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(timeMessage).build());
            if (waveNum == 10 && !this.config.waveSplits()) {
                String endMessage = new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Game finished, duration: ").append(ChatColorType.HIGHLIGHT).append(this.gameTime.getTime(false)).build();
                this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(endMessage).build());
            }
        }
    }

    private void announceTime(int waveNum, RunCategory category, String time) {
        String[] compareTimes = this.getTimes(category);
        if (waveNum < 1 || waveNum > compareTimes.length) {
            return;
        }
        String timeMessage = new ChatMessageBuilder().append(ChatColorType.NORMAL).append(category.toString() + " - Wave " + waveNum + " pace: ").append(Color.BLUE, compareTimes[waveNum - 1]).append(ChatColorType.NORMAL).append(" || Split: ").append(this.compareSplitColor(time, compareTimes[waveNum - 1]), time + " (" + (this.timeToSeconds(time) - this.timeToSeconds(compareTimes[waveNum - 1])) + "s)").build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(timeMessage).build());
    }

    private void announceMessage(String msg) {
        String chatmsg = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append(msg).build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(chatmsg).build());
    }

    private Color compareSplitColor(String split, String pace) {
        if (this.timeToSeconds(split) < this.timeToSeconds(pace)) {
            return Color.GREEN;
        }
        if (this.timeToSeconds(split) > this.timeToSeconds(pace)) {
            return Color.RED;
        }
        return Color.BLUE;
    }

    private int timeToSeconds(String time) {
        String[] times = time.split(":");
        try {
            if (times.length == 1) {
                return Integer.parseInt(time);
            }
            if (times.length == 2) {
                return Integer.parseInt(times[0]) * 60 + Integer.parseInt(times[1]);
            }
            return 0;
        }
        catch (NumberFormatException nfex) {
            return -1;
        }
    }

    private String[] parseWaveTimesFromString(String timeString) {
        String[] timeArray = timeString.split("[,\\s\n]");
        if (timeArray.length != 10) {
            return new String[0];
        }
        return timeArray;
    }

    private void saveTime(RunCategory category, String[] times) {
        if (times == null || times.length == 0) {
            this.configManager.unsetConfiguration(CONFIG_GROUP, category.toString());
            return;
        }
        String json = GSON.toJson((Object)times);
        this.configManager.setConfiguration(CONFIG_GROUP, category.toString(), json);
    }

    private String[] getTimes(RunCategory category) {
        String json = this.configManager.getConfiguration(CONFIG_GROUP, category.toString());
        if (Strings.isNullOrEmpty((String)json)) {
            this.announceMessage("Error getting split time, no time found for category: " + category.toString());
            return this.waveGoal;
        }
        return (String[])GSON.fromJson(json, new TypeToken<String[]>(){}.getType());
    }

    public Round getCurrentRound() {
        return this.currentRound;
    }
}

