/*
 * Decompiled with CFR 0.152.
 */
package com.discordgroupbanknotifications;

import com.discordgroupbanknotifications.Item;
import com.discordgroupbanknotifications.ItemTransfer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ItemMap {
    private final Map<Integer, Item> itemMap;

    public ItemMap(Item[] items) {
        this.itemMap = this.createItemMap(items);
    }

    public Map<Integer, Item> createItemMap(Item[] items) {
        HashMap<Integer, Item> itemMap = new HashMap<Integer, Item>();
        for (Item item : items) {
            if (item == null || item.getId() < 0 || item.getQuantity() < 0) continue;
            int id = item.getId();
            if (itemMap.containsKey(id)) {
                itemMap.put(id, new Item(id, item.getName(), item.getQuantity() + ((Item)itemMap.get(id)).getQuantity()));
                continue;
            }
            itemMap.put(id, new Item(id, item.getName(), item.getQuantity()));
        }
        return itemMap;
    }

    public List<ItemTransfer> getItemTransfers(ItemMap other) {
        Map<Integer, Item> thisItems = this.getItemMap();
        Map<Integer, Item> otherItems = other.getItemMap();
        ArrayList<ItemTransfer> result = new ArrayList<ItemTransfer>();
        for (Integer itemId : otherItems.keySet()) {
            Item otherItem = otherItems.get(itemId);
            if (thisItems.containsKey(itemId)) {
                Item thisItem = thisItems.get(itemId);
                int quantityDifference = otherItem.getQuantity() - thisItem.getQuantity();
                if (quantityDifference == 0) continue;
                result.add(new ItemTransfer(itemId, thisItem.getName(), quantityDifference));
                continue;
            }
            result.add(new ItemTransfer(itemId, otherItem.getName(), otherItem.getQuantity()));
        }
        for (Integer itemId : thisItems.keySet()) {
            Item thisItem = thisItems.get(itemId);
            if (otherItems.containsKey(itemId)) continue;
            result.add(new ItemTransfer(itemId, thisItem.getName(), -thisItem.getQuantity()));
        }
        return result;
    }

    public Map<Integer, Item> getItemMap() {
        return this.itemMap;
    }
}

