/*
 * Decompiled with CFR 0.152.
 */
package com.discordgroupbanknotifications;

import com.discordgroupbanknotifications.ApiTool;
import com.discordgroupbanknotifications.DiscordGroupBankNotificationsConfig;
import com.discordgroupbanknotifications.DiscordWebhook;
import com.discordgroupbanknotifications.Item;
import com.discordgroupbanknotifications.ItemMap;
import com.discordgroupbanknotifications.ItemTransfer;
import com.discordgroupbanknotifications.TransferMessageCreator;
import com.google.common.base.Strings;
import com.google.inject.Provides;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuAction;
import net.runelite.api.WorldType;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.http.api.RuneLiteAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Discord Group Bank Notifications")
public class DiscordGroupBankNotificationsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(DiscordGroupBankNotificationsPlugin.class);
    @Inject
    private Client client;
    @Inject
    private DiscordGroupBankNotificationsConfig config;
    @Inject
    private ItemManager itemManager;
    @Inject
    private TransferMessageCreator transferMessageCreator;
    @Inject
    private ApiTool apiTool;
    private static final int OPEN_SHARED_STORAGE = 786440;
    private static final int SAVE_SHARED_STORAGE = 47448098;
    private static final int BACK_TO_BANK_SHARED_STORAGE = 47448073;
    private static final int CLOSE_SHARED_STORAGE = 47448067;
    private boolean fetchInitialSharedBankItems = false;
    private ItemMap initialSharedBankItems = null;
    private ItemMap modifiedSharedBankItems = null;

    protected void startUp() throws Exception {
        log.info("Discord Group Bank Notifications started!");
        super.startUp();
    }

    protected void shutDown() throws Exception {
        log.info("Discord Group Bank Notifications stopped!");
        super.shutDown();
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        ItemContainer container;
        if (!this.isEnabled()) {
            return;
        }
        if (this.fetchInitialSharedBankItems && (container = this.client.getItemContainer(InventoryID.GROUP_STORAGE)) != null) {
            this.initialSharedBankItems = new ItemMap(this.mapItems(container.getItems()));
            this.fetchInitialSharedBankItems = false;
        }
    }

    @Subscribe
    private void onItemContainerChanged(ItemContainerChanged event) {
        int id = event.getContainerId();
        ItemContainer container = event.getItemContainer();
        if (id == InventoryID.GROUP_STORAGE.getId()) {
            this.modifiedSharedBankItems = new ItemMap(this.mapItems(container.getItems()));
        }
    }

    private Item[] mapItems(net.runelite.api.Item[] items) {
        return (Item[])Arrays.stream(items).map(i -> new Item(this.itemManager.canonicalize(i.getId()), this.itemManager.getItemComposition(i.getId()).getMembersName(), i.getQuantity())).toArray(Item[]::new);
    }

    @Subscribe
    private void onMenuOptionClicked(MenuOptionClicked event) {
        if (!this.isEnabled()) {
            return;
        }
        int param1 = event.getParam1();
        MenuAction menuAction = event.getMenuAction();
        if (menuAction != MenuAction.CC_OP) {
            return;
        }
        if (param1 == 786440) {
            this.fetchInitialSharedBankItems = true;
        } else if (param1 == 47448098 || param1 == 47448073 || param1 == 47448067) {
            if (this.modifiedSharedBankItems == null) {
                return;
            }
            List<ItemTransfer> itemTransfers = this.initialSharedBankItems.getItemTransfers(this.modifiedSharedBankItems);
            this.sendWebhook(this.transferMessageCreator.createTransferMessages(itemTransfers, this.client.getLocalPlayer().getName()));
            this.modifiedSharedBankItems = null;
            this.initialSharedBankItems = null;
        }
    }

    private void sendWebhook(DiscordWebhook discordWebhook) {
        String configUrl = this.config.webhook();
        if (Strings.isNullOrEmpty((String)configUrl)) {
            return;
        }
        List<String> webhookUrls = Arrays.stream(configUrl.split("\n")).filter(u -> u.length() > 0).map(String::trim).collect(Collectors.toList());
        String jsonStr = RuneLiteAPI.GSON.toJson((Object)discordWebhook);
        webhookUrls.forEach(url -> this.apiTool.postRaw((String)url, jsonStr, "application/json").handle((_v, e) -> {
            if (e != null) {
                log.error(e.getMessage());
            }
            return null;
        }));
    }

    private boolean isEnabled() {
        return this.isLoggedIn() && this.isCorrectWorldType();
    }

    private boolean isLoggedIn() {
        return this.client.getGameState() == GameState.LOGGED_IN && this.client.getLocalPlayer() != null;
    }

    private boolean isCorrectWorldType() {
        EnumSet worldTypes = this.client.getWorldType();
        for (WorldType worldType : worldTypes) {
            if (worldType != WorldType.SEASONAL && worldType != WorldType.DEADMAN && worldType != WorldType.TOURNAMENT_WORLD && worldType != WorldType.PVP_ARENA) continue;
            return false;
        }
        return true;
    }

    @Provides
    DiscordGroupBankNotificationsConfig provideConfig(ConfigManager configManager) {
        return (DiscordGroupBankNotificationsConfig)configManager.getConfig(DiscordGroupBankNotificationsConfig.class);
    }
}

