/*
 * Decompiled with CFR 0.152.
 */
package com.killsperhour;

import com.google.inject.Provides;
import com.killsperhour.FileReadWriter;
import com.killsperhour.KphBossGoalsOverlay;
import com.killsperhour.KphBossInfo;
import com.killsperhour.KphConfig;
import com.killsperhour.KphInfobox;
import com.killsperhour.KphOverlay;
import com.killsperhour.KphPanel;
import com.killsperhour.KphSpecialMethods;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.DecimalFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.client.RuneLite;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatCommandManager;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.ItemStack;
import net.runelite.client.game.LootManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.loottracker.LootReceived;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.ImageUtil;
import net.runelite.http.api.loottracker.LootRecordType;
import org.apache.commons.lang3.time.DurationFormatUtils;

@PluginDescriptor(name="Bossing Info", description="Tracks statistics such as kills per hour and time bossed at various bosses.", tags={"PVM", "kills per hour", "kph", "boss", "info", "boss utilities", "boss util", "util", "utilities", "kill times"})
public class KphPlugin
extends Plugin {
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private KphOverlay overlay;
    @Inject
    private KphConfig config;
    @Inject
    private ChatCommandManager chatCommandManager;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private Client client;
    @Inject
    private KphSpecialMethods sMethods;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private FileReadWriter fileRW;
    @Inject
    private KphBossGoalsOverlay kphBossGoalsOverlay;
    private KphPanel panel;
    @Inject
    private LootManager lootManager;
    @Inject
    private ClientThread clientThread;
    private KphInfobox infobox;
    private NavigationButton navButton;
    private BufferedImage icon;
    private Instant startTime;
    private Instant totalSessionStart = Instant.now();
    private Instant timeoutStart;
    private Instant pauseStart;
    private Instant killTimerStart;
    final String supremeMessage = "Your Dagannoth Supreme kill count is:";
    final String rexMessage = "Your Dagannoth Rex kill count is:";
    final String primeMessage = "Your Dagannoth Prime kill count is:";
    private int delayTicks;
    private int timerOffset;
    private int pauseTime;
    private int firstKillTime;
    private int attkCount;
    private final int[] cmRegions = new int[]{13138, 13137, 13139, 13141, 13136, 13145, 13393, 13394, 13140, 13395, 13397};
    private final int[] regGauntletRegion = new int[]{7512};
    private final int[] cGauntletRegion = new int[]{7768};
    private final int[] gargBossRegion = new int[]{6727};
    private final int[] fightCaveRegion = new int[]{9551};
    private final int[] infernoRegion = new int[]{9043};
    boolean cacheHasInfo;
    private NPC lastAttackedBoss;
    private NPC currentNPC;
    NPC lastValidBoss;
    String message;
    String sessionNpc;
    String currentBoss;
    Instant primeStart;
    Instant rexStart;
    Instant supremeStart;
    Instant barrowsStart;
    Instant sireStart;
    Instant krakenStart;
    Collection<ItemStack> itemStacks;
    int lastKillTotalTime_0;
    int lastKillTotalTime_1;
    double killsPerHour;
    int totalTime;
    int averageKillTime;
    int killCount;
    int killsThisSession;
    int totalKillTime;
    int totalBossKillTime;
    int totalSessionTime;
    int timeSpentIdle;
    int primeAttkTimout = 21;
    int rexAttkTimout = 21;
    int supremeAttkTimout = 21;
    int lastAttkTimeout = 99999;
    int startKC;
    int endKC;
    int calcMode;
    boolean paused;
    String bossName;
    String kcMessage;
    String timeMessage;
    boolean autoResumed;
    int stoper = 0;
    int attkTimeout;
    private int ticks;
    boolean canRun;
    String currentBossName;
    int cachedSessionKills;
    String cachedAvgKillTime;
    String cachedKPH;
    String cachedIdleTime;
    String cachedSessionTime;
    String cachedSessionNpc;
    String cachedFastestKill;
    int lastkillnumber;
    int totalTrackedTime;
    double overallKph;
    int currentKill;
    int fastestKill = 99999999;

    @Subscribe
    public void onLootReceived(LootReceived event) {
        if (event.getType() != LootRecordType.NPC && event.getType() != LootRecordType.EVENT) {
            return;
        }
        if (this.killsThisSession == 1 && !this.fileRW.sessionItemDrops.isEmpty()) {
            this.fileRW.sessionItemDrops.clear();
        }
        this.itemStacks = event.getItems();
        this.bossName = event.getName();
        this.fileRW.lootReceived();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        switch (configChanged.getKey()) {
            case "KPH Calc Method": {
                this.panel.updateKphMethod();
                this.panel.updateBossGoalsPanel();
                break;
            }
            case "Side Panel": {
                if (this.config.showSidePanel()) {
                    this.buildSidePanel();
                    break;
                }
                this.clientToolbar.removeNavigation(this.navButton);
                break;
            }
            case "Side Panel Position": {
                if (!this.config.showSidePanel()) break;
                this.clientToolbar.removeNavigation(this.navButton);
                this.navButton = NavigationButton.builder().tooltip("Bossing Info").icon(this.icon).priority(this.config.sidePanelPosition()).panel((PluginPanel)this.panel).build();
                this.clientToolbar.addNavigation(this.navButton);
                break;
            }
            case "Dagannoth Selector": {
                if (this.sessionNpc == null || !this.sessionNpc.equals("Dagannoth Kings") && !this.sessionNpc.equals("Dagannoth Prime") && !this.sessionNpc.equals("Dagannoth Supreme") && !this.sessionNpc.equals("Dagannoth Rex")) break;
                this.sessionEnd();
                break;
            }
            case "Infobox": {
                if (this.config.renderInfobox()) {
                    this.addInfoBox();
                    break;
                }
                this.infoBoxManager.removeInfoBox((InfoBox)this.infobox);
                break;
            }
            case "Display relative kills": {
                if (this.sessionNpc == null) break;
                this.panel.updateBossGoalsPanel();
                break;
            }
            case "Display Boss Goals Panel": {
                this.panel.bossGoalsPanel.setVisible(this.config.displayBossGoalsPanel());
                break;
            }
            case "Loot Display": {
                if (this.panel.fetchedInfoPanel.isShowing()) break;
                this.clientThread.invoke(() -> this.panel.updateLootGrid(this.panel.lootDisplayMap()));
            }
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            File mainFolder = new File(RuneLite.RUNELITE_DIR, "bossing-info");
            File file = new File(mainFolder, String.valueOf(this.client.getAccountHash()));
            if (this.client.getUsername() == null && !file.exists()) {
                this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.GAMEMESSAGE).runeLiteFormattedMessage("<col=ff0000>[Bossing Info]<col=707070>Please do one boss kill on old Java client to migrate your info for Jagex Accounts<col=ffff00>").build());
            }
        }
        if (gameStateChanged.getGameState() == GameState.HOPPING || gameStateChanged.getGameState() == GameState.LOGGING_IN) {
            this.attkCount = 0;
            this.delayTicks = 0;
            this.nullStartTimesForSpecialBosses();
        }
        if (gameStateChanged.getGameState() == GameState.LOGIN_SCREEN) {
            this.sessionPause();
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        Player player = this.client.getLocalPlayer();
        if (player == null || this.delayTicks < 5) {
            return;
        }
        if (chatMessage.getType() == ChatMessageType.GAMEMESSAGE || chatMessage.getType() == ChatMessageType.FRIENDSCHATNOTIFICATION || chatMessage.getType() == ChatMessageType.SPAM) {
            this.canRun = false;
            this.message = chatMessage.getMessage();
            this.chatMessageFilter();
            this.sMethods.sireTimeClac();
            if (this.paused) {
                return;
            }
            this.bossKc();
            this.bossKillTime();
            this.chatMessageQueue();
        }
    }

    public void chatMessageQueue() {
        if (this.kcMessage != null && this.timeMessage != null) {
            this.canRun = true;
            this.chatDisplayBossMethod(this.currentBossName);
            this.chatDisplayKillTimeGetter();
            this.calcKillsPerHour();
            this.kcMessage = null;
            this.timeMessage = null;
            this.printCurrentKph();
        }
    }

    public void chatMessageFilter() {
        if (this.paused) {
            for (KphBossInfo bossIdentifier : KphBossInfo.values()) {
                if (!this.message.contains(bossIdentifier.getKcIdentifier())) continue;
                this.sessionResume();
                this.autoResumed = true;
                break;
            }
            for (String message : KphBossInfo.timeMessages) {
                if (!this.message.contains(message)) continue;
                this.sessionResume();
                this.autoResumed = true;
                break;
            }
        }
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied hitsplatApplied) {
        if (hitsplatApplied.getActor() instanceof NPC) {
            NPC npc = (NPC)hitsplatApplied.getActor();
            if (hitsplatApplied.getHitsplat().isMine()) {
                this.lastAttackedBoss = npc;
                KphBossInfo kphBossInfo = KphBossInfo.find(this.lastAttackedBoss.getName());
                if (kphBossInfo != null && kphBossInfo.getDisplayType() == 0) {
                    this.lastAttkTimeout = 0;
                    this.lastValidBoss = this.lastAttackedBoss;
                    this.sMethods.dagTimeClac();
                    ++this.attkCount;
                    if (this.attkCount == 1) {
                        this.currentNPC = this.lastValidBoss;
                        this.setAttkTimeout();
                        this.setKillTimeStart();
                    }
                    if (this.currentNPC.getName() != null && this.lastValidBoss.getName() != null && !this.currentNPC.getName().equals(this.lastValidBoss.getName()) && this.lastValidBoss.getId() != 6612) {
                        this.attkCount = 1;
                        this.setKillTimeStart();
                        this.currentNPC = this.lastValidBoss;
                        this.setAttkTimeout();
                    }
                }
            }
        }
    }

    public void setKillTimeStart() {
        if (this.sMethods.dagChecker()) {
            this.killTimerStart = this.sMethods.dagTimeClac();
            return;
        }
        if (this.sMethods.barrowsChecker()) {
            this.killTimerStart = this.sMethods.barrowsTimeClac();
            return;
        }
        if (this.sMethods.sireChecker() && this.sireStart != null) {
            this.killTimerStart = this.sireStart;
            return;
        }
        if (this.sMethods.krakenChecker()) {
            this.killTimerStart = this.sMethods.krakenTimeClac();
            return;
        }
        this.killTimerStart = Instant.now();
    }

    public void bossKilled() {
        if (this.lastValidBoss != null) {
            if (this.lastValidBoss.isDead() && this.stoper == 0) {
                if (this.lastValidBoss.getId() != 963 && this.lastValidBoss.getId() != 6612) {
                    this.sMethods.dagTimeClearTwo();
                    this.attkCount = 0;
                }
                this.stoper = 1;
            }
            if (!this.lastValidBoss.isDead() && this.stoper == 1) {
                this.stoper = 0;
            }
        }
    }

    public void setAttkTimeout() {
        KphBossInfo kphBossInfo = KphBossInfo.find(this.currentNPC.getName());
        this.attkTimeout = kphBossInfo.getAttkTimeout();
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        ++this.primeAttkTimout;
        ++this.rexAttkTimout;
        ++this.supremeAttkTimout;
        ++this.delayTicks;
        ++this.ticks;
        this.bossKilled();
        if (this.attkCount > 0 || this.timesAreNotNull()) {
            ++this.lastAttkTimeout;
            if (this.lastAttkTimeout == this.attkTimeout) {
                this.attkTimedOut();
            }
        }
        if (this.ticks == 2) {
            this.ticks = 0;
            if (this.killsThisSession > 0 && !this.paused && this.config.timeoutTime() != 0) {
                this.sessionTimeoutTimer();
            }
        }
    }

    public boolean timesAreNotNull() {
        return this.barrowsStart != null || this.sireStart != null;
    }

    public void attkTimedOut() {
        this.attkCount = 0;
        if (this.krakenStart != null) {
            this.sMethods.krakenTimeClear();
        }
        if (this.barrowsStart != null) {
            this.sMethods.barrowsTimeClear();
        }
        if (this.sireStart != null) {
            this.sMethods.sireTimeClear();
        }
    }

    public void addInfoBox() {
        if (this.config.renderInfobox() && this.sessionNpc != null) {
            KphBossInfo kphBossInfo = KphBossInfo.find(this.sessionNpc);
            this.infoBoxManager.removeInfoBox((InfoBox)this.infobox);
            AsyncBufferedImage image = this.itemManager.getImage(kphBossInfo.getIcon());
            this.infobox = new KphInfobox((BufferedImage)image, this, this.config, OverlayPosition.DETACHED);
            this.infoBoxManager.addInfoBox((InfoBox)this.infobox);
        }
    }

    private void buildSidePanel() {
        this.panel = (KphPanel)((Object)this.injector.getInstance(KphPanel.class));
        this.panel.sidePanelInitializer();
        this.icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/icon.png");
        this.navButton = NavigationButton.builder().tooltip("Bossing Info").icon(this.icon).priority(this.config.sidePanelPosition()).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
    }

    public int bossKillTime() {
        if (this.message.contains("Fight duration:")) {
            this.timeMessage = this.message = this.message.substring(this.message.indexOf("Fight duration:"));
            return 0;
        }
        if (this.message.contains("Duration:") && (Arrays.equals(this.client.getMapRegions(), this.fightCaveRegion) || Arrays.equals(this.client.getMapRegions(), this.infernoRegion))) {
            this.timeMessage = this.message;
            return 0;
        }
        if (this.message.contains("Congratulations - your raid is complete!")) {
            this.timeMessage = this.message = this.message.substring(this.message.indexOf("Duration:</col>") + 15);
            return 0;
        }
        if (this.message.contains("Corrupted challenge duration:")) {
            this.timeMessage = this.message;
            return 0;
        }
        if (this.message.contains("Challenge duration:")) {
            this.timeMessage = this.message;
            return 0;
        }
        if (this.message.contains("Theatre of Blood total completion time: ")) {
            this.timeMessage = this.message = this.message.substring(this.message.indexOf("time: ") + 5);
            return 0;
        }
        if (this.message.contains("Tombs of Amascut total completion time:") || this.message.contains("Tombs of Amascut: Expert Mode total completion time:")) {
            this.timeMessage = this.message;
            return 0;
        }
        return 0;
    }

    public void chatDisplayBossMethod(String bossName) {
        this.updateSessionInfoCache();
        this.canRun = true;
        ++this.killsThisSession;
        if (this.killsThisSession == 1) {
            this.sessionNpc = bossName;
            this.sessionInitializer();
        }
        this.currentBoss = bossName;
        this.sessionChecker();
        this.killCount = this.getKillCount();
    }

    public void nonChatDisplayBossMethod(String bossName) {
        this.updateSessionInfoCache();
        ++this.killsThisSession;
        if (this.killsThisSession == 1) {
            this.sessionNpc = bossName;
            this.sessionInitializer();
            this.firstKillTime = this.generalTimer(this.killTimerStart);
        }
        this.currentBoss = bossName;
        this.conditionalTimeClear();
        this.killCount = this.getKillCount();
        this.noDisplayKillTimeGetter();
        this.sessionChecker();
        this.canRun = true;
        this.timeMessage = null;
        this.kcMessage = null;
    }

    public void bossKc() {
        for (KphBossInfo bossIdentifier : KphBossInfo.values()) {
            if (!this.message.contains(bossIdentifier.getKcIdentifier())) continue;
            if (bossIdentifier.getDisplayType() == 1) {
                this.kcMessage = this.message;
                this.currentBossName = bossIdentifier.getName();
                break;
            }
            this.nonChatDisplayBossMethod(bossIdentifier.getName());
            this.calcKillsPerHour();
            this.printCurrentKph();
            break;
        }
        if ((this.message.contains("Your Dagannoth Rex kill count is:") || this.message.contains("Your Dagannoth Prime kill count is:") || this.message.contains("Your Dagannoth Supreme kill count is:")) && this.config.dksSelector() == KphConfig.DksSelector.Kings || this.message.contains("Your Dagannoth Rex kill count is:") && this.config.dksSelector() == KphConfig.DksSelector.Rex || this.message.contains("Your Dagannoth Prime kill count is:") && this.config.dksSelector() == KphConfig.DksSelector.Prime || this.message.contains("Your Dagannoth Supreme kill count is:") && this.config.dksSelector() == KphConfig.DksSelector.Supreme) {
            this.updateSessionInfoCache();
            ++this.killsThisSession;
            if (this.killsThisSession == 1) {
                this.sessionNpc = "Dagannoth " + this.config.dksSelector().toString();
                this.sessionInitializer();
                this.firstKillTime = this.generalTimer(this.killTimerStart);
            }
            this.currentBoss = "Dagannoth " + this.config.dksSelector().toString();
            this.sMethods.dagTimeClear();
            this.killCount = this.getKillCount();
            this.noDisplayKillTimeGetter();
            this.sessionChecker();
            this.canRun = true;
        }
    }

    private void conditionalTimeClear() {
        switch (this.currentBoss) {
            case "Barrows": {
                this.sMethods.barrowsTimeClear();
                break;
            }
            case "Kraken": {
                this.sMethods.krakenTimeClear();
                break;
            }
            case "Abyssal Sire": {
                this.sMethods.sireTimeClear();
            }
        }
    }

    private void sessionInitializer() {
        this.totalSessionStart = Instant.now();
        this.startTime = Instant.now();
        if (this.sessionNpc != null) {
            this.addInfoBox();
            this.panel.setBossIcon(this.sessionNpc);
        }
    }

    public void sessionChecker() {
        this.timeoutStart = Instant.now();
        if (!this.sessionNpc.equals(this.currentBoss)) {
            this.sessionReset();
        }
    }

    public void sessionReset() {
        if (this.config.outputOnChange()) {
            this.sessionInfoOutputMessage();
        }
        this.reset();
        this.killsThisSession = 1;
        this.sessionNpc = this.currentBoss;
        KphBossInfo kphBossInfo = KphBossInfo.find(this.sessionNpc);
        if (kphBossInfo.getDisplayType() == 0) {
            this.totalTime = this.firstKillTime = this.generalTimer(this.killTimerStart);
            this.totalKillTime = this.firstKillTime;
            this.lastKillTotalTime_0 = this.firstKillTime;
            this.fastestKill = this.firstKillTime;
            if (this.lastValidBoss.getName() == null) {
                this.killTimeMessage(this.currentBoss);
            }
        }
        if (kphBossInfo.getDisplayType() == 1) {
            this.fastestKill = 999999;
            this.totalTime = this.bossKillTime();
        }
        this.addInfoBox();
        this.panel.setBossIcon(this.sessionNpc);
        this.startTime = Instant.now();
    }

    public void sessionEnd() {
        if (this.sessionNpc != null) {
            this.updateSessionInfoCache();
            if (this.config.outputOnChange()) {
                this.sessionInfoOutputMessage();
            }
            this.reset();
            this.killsThisSession = 0;
            this.sessionNpc = null;
            this.currentBoss = null;
            this.totalTime = 0;
            this.totalBossKillTime = 0;
            this.totalKillTime = 0;
            this.killCount = 0;
            this.fastestKill = 9999999;
            this.infoBoxManager.removeInfoBox((InfoBox)this.infobox);
            this.panel.setSessionInfo();
            this.panel.progressBar.setDimmed(true);
            this.panel.progressBar.setForeground(new Color(88, 88, 88));
            this.panel.progressBar.setDimmedText("No Session");
            this.panel.progressBar.repaint();
        }
    }

    public void reset() {
        this.paused = false;
        this.calcMode = 0;
        this.pauseTime = 0;
        this.timeSpentIdle = 0;
        this.timerOffset = 0;
        this.attkCount = 0;
        this.lastkillnumber = -1;
        this.panel.switchModeButton.setText("     Actual     ");
        this.panel.pauseResumeButton.setText("      Pause     ");
        this.nullStartTimesForSpecialBosses();
        this.fileRW.resetStartAndEndKc();
        this.timeoutStart = Instant.now();
        this.totalBossKillTime = this.bossKillTime();
        this.totalSessionStart = Instant.now();
    }

    public void nullStartTimesForSpecialBosses() {
        this.sireStart = null;
        this.primeStart = null;
        this.rexStart = null;
        this.supremeStart = null;
        this.barrowsStart = null;
        this.krakenStart = null;
    }

    public void updateSessionInfoCache() {
        if (!this.fileRW.sessionItemDrops.isEmpty()) {
            this.fileRW.cachedItemDrops = this.fileRW.sessionItemDrops;
        }
        this.cacheHasInfo = true;
        this.cachedKPH = this.formatKPH();
        this.cachedSessionKills = this.killsThisSession;
        this.cachedAvgKillTime = this.avgKillTimeConverter();
        this.cachedIdleTime = this.timeConverter(this.timeSpentIdle);
        this.cachedSessionTime = this.timeConverter(this.totalSessionTime);
        this.cachedFastestKill = this.timeConverter(this.fastestKill);
        this.cachedSessionNpc = this.sessionNpc;
    }

    public void sessionInfoOutputMessage() {
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.GAMEMESSAGE).runeLiteFormattedMessage("Session Info").build());
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.GAMEMESSAGE).runeLiteFormattedMessage("-------------------------").build());
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.GAMEMESSAGE).runeLiteFormattedMessage("KPH: " + this.cachedKPH).build());
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.GAMEMESSAGE).runeLiteFormattedMessage("Kills: " + this.cachedSessionKills).build());
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.GAMEMESSAGE).runeLiteFormattedMessage("Avg Kill: " + this.cachedAvgKillTime).build());
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.GAMEMESSAGE).runeLiteFormattedMessage("Idle Time: " + this.cachedIdleTime).build());
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.GAMEMESSAGE).runeLiteFormattedMessage("Session Time: " + this.cachedSessionTime).build());
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.GAMEMESSAGE).runeLiteFormattedMessage("-------------------------").build());
    }

    public void printCurrentKph() {
        if (this.config.printKphInChat()) {
            this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "KPH: <col=ff0000>" + this.formatKPH() + "</col>", "");
        }
    }

    private void infoCommand(ChatMessage chatMessage, String message) {
        if (this.cacheHasInfo) {
            if (this.sessionNpc != null) {
                this.updateSessionInfoCache();
            }
            this.sessionInfoOutputMessage();
        }
    }

    private void endCommand(ChatMessage chatMessage, String message) {
        this.sessionEnd();
    }

    private void pauseCommand(ChatMessage chatMessage, String message) {
        this.sessionPause();
    }

    private void resumeCommand(ChatMessage chatMessage, String message) {
        this.sessionResume();
    }

    public void sessionPause() {
        if (!this.paused && this.sessionNpc != null) {
            this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.GAMEMESSAGE).runeLiteFormattedMessage("Session Paused").build());
            this.paused = true;
            this.panel.pauseResumeButton.setText("    Resume    ");
            this.pauseStart = Instant.now();
            this.panel.setBossNameColor();
            this.panel.progressBar.setForeground(new Color(167, 125, 38));
            this.panel.progressBar.setCenterLabel("Paused");
            this.panel.progressBar.repaint();
        }
    }

    public void sessionResume() {
        if (this.paused) {
            this.paused = false;
            this.panel.pauseResumeButton.setText("      Pause     ");
            this.pauseTime += this.generalTimer(this.pauseStart);
            this.timeoutStart = Instant.now();
            this.nullStartTimesForSpecialBosses();
            this.attkCount = 0;
            this.panel.currentBossNameLabel.setForeground(new Color(71, 226, 12));
            this.panel.progressBar.setForeground(new Color(91, 154, 47));
            this.panel.progressBar.setCenterLabel(this.panel.percentDone + "%");
            this.panel.updateBossGoalsPanel();
            this.panel.progressBar.repaint();
            this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.GAMEMESSAGE).runeLiteFormattedMessage("Session Resumed").build());
        }
    }

    public void calcKillsPerHour() {
        if (this.killsThisSession != 0) {
            KphBossInfo kphBossInfo = KphBossInfo.find(this.currentBoss);
            if (kphBossInfo == null) {
                return;
            }
            if (this.calcMode == 1) {
                switch (kphBossInfo.getDisplayType()) {
                    case 0: {
                        this.totalTime = this.totalKillTime;
                        break;
                    }
                    case 1: {
                        this.totalTime = this.totalBossKillTime;
                    }
                }
            }
            if (this.calcMode == 0) {
                switch (kphBossInfo.getDisplayType()) {
                    case 0: {
                        this.totalTime = this.lastKillTotalTime_0;
                        break;
                    }
                    case 1: {
                        this.totalTime = this.lastKillTotalTime_1;
                    }
                }
            }
            this.averageKillTime = this.totalTime / this.killsThisSession;
        }
        this.killsPerHour = this.averageKillTime == 0 ? 0.0 : 3600.0 / (double)this.averageKillTime;
        this.timeSpentIdle();
        this.panel.setSessionInfo();
        if (this.currentBoss != null && this.canRun) {
            this.fileRW.createAndUpdate();
            this.panel.setHistoricalInfo();
            this.panel.updateBossGoalsPanel();
            this.canRun = false;
        }
        this.lastkillnumber = this.killsThisSession;
    }

    public String formatKPH() {
        switch (this.config.kphMethod()) {
            case PRECISE: {
                DecimalFormat df = new DecimalFormat("#.#");
                this.killsPerHour = Double.parseDouble(df.format(this.killsPerHour));
                return String.valueOf(this.killsPerHour);
            }
            case ROUNDED: {
                int kph = (int)Math.round(this.killsPerHour);
                return String.valueOf(kph);
            }
            case ROUND_UP: {
                int kph = (int)Math.ceil(this.killsPerHour);
                return String.valueOf(kph);
            }
            case TRADITIONAL: {
                int kph = (int)this.killsPerHour;
                return String.valueOf(kph);
            }
        }
        return String.valueOf(this.killsPerHour);
    }

    public void timeSpentIdle() {
        if (this.sessionNpc != null) {
            KphBossInfo kphBossInfo = KphBossInfo.find(this.sessionNpc);
            if (kphBossInfo.getDisplayType() == 0) {
                this.timeSpentIdle = this.totalTime - this.totalKillTime;
            }
            if (kphBossInfo.getDisplayType() == 1) {
                this.timeSpentIdle = this.totalTime - this.totalBossKillTime;
            }
        }
    }

    public int getKillTime() {
        String seconds;
        String minutes;
        int lastOfTime;
        int startOfTime;
        String hours = "0";
        String trimmedMessage = this.timeMessage.replaceFirst("<", "");
        String sub = trimmedMessage.substring((startOfTime = trimmedMessage.indexOf(">")) + 1, lastOfTime = trimmedMessage.indexOf("<"));
        if (sub.contains(".")) {
            int endOfUsefulTime = sub.indexOf(".");
            sub = sub.substring(0, endOfUsefulTime);
        }
        sub = sub.replace(":", "");
        switch (sub.length()) {
            case 4: {
                minutes = sub.substring(0, 2);
                seconds = sub.substring(2);
                break;
            }
            case 5: {
                hours = sub.substring(0, 1);
                minutes = sub.substring(1, 2);
                seconds = sub.substring(2);
                break;
            }
            default: {
                minutes = sub.substring(0, 1);
                seconds = sub.substring(1);
            }
        }
        return Integer.parseInt(seconds) + Integer.parseInt(minutes) * 60 + Integer.parseInt(hours) * 3600;
    }

    public int getKillCount() {
        KphBossInfo kphBossInfo = KphBossInfo.find(this.currentBoss);
        String message = this.message;
        if (kphBossInfo.getDisplayType() == 1) {
            message = this.kcMessage;
        }
        String trimmedMessage = message.replace("<col=ff0000>", "");
        trimmedMessage = trimmedMessage.replaceAll("[^0-9]", "");
        return Integer.parseInt(trimmedMessage);
    }

    public void fastestKill() {
        if (this.currentKill < this.fastestKill) {
            this.fastestKill = this.currentKill;
        }
    }

    public int getTotalBossKillTime() {
        this.totalBossKillTime += this.getKillTime();
        return this.totalBossKillTime;
    }

    public int chatDisplayKillTimeGetter() {
        this.getTotalBossKillTime();
        this.currentKill = this.getKillTime();
        this.fastestKill();
        if (this.killsThisSession == 1 || this.autoResumed) {
            this.timerOffset += this.getKillTime();
            this.autoResumed = false;
        }
        this.lastKillTotalTime_1 = this.totalTime = this.generalTimer(this.startTime) + this.timerOffset - this.pauseTime;
        return this.totalTime;
    }

    public void noDisplayKillTimeGetter() {
        this.totalKillTime += this.generalTimer(this.killTimerStart);
        if (this.autoResumed && this.killsThisSession != 1) {
            this.firstKillTime += this.generalTimer(this.killTimerStart);
            this.autoResumed = false;
        }
        this.lastKillTotalTime_0 = this.totalTime = this.generalTimer(this.startTime) + this.firstKillTime - this.pauseTime;
        this.attkCount = 0;
        if (this.lastValidBoss.getName() != null || this.sessionNpc.equals("Barrows")) {
            if (this.sMethods.dagKingsCheck()) {
                this.killTimeMessage(this.currentNPC.getName());
            } else {
                this.killTimeMessage(this.currentBoss);
            }
        }
        this.currentKill = this.generalTimer(this.killTimerStart);
        this.fastestKill();
    }

    public void killTimeMessage(String boss) {
        if (this.config.displayKillTimes()) {
            this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", boss + " Fight Duration: <col=ff0000>" + this.timeConverter(this.generalTimer(this.killTimerStart)), "");
        }
    }

    public boolean isBossChatDisplay() {
        KphBossInfo kphBossInfo = KphBossInfo.find(this.currentBoss);
        return kphBossInfo.getDisplayType() == 1;
    }

    public int generalTimer(Instant start) {
        Duration elapsed = Duration.between(start, Instant.now());
        String formatString = "ss";
        String elapsedFormated = DurationFormatUtils.formatDuration((long)elapsed.toMillis(), (String)"ss", (boolean)true);
        return Integer.parseInt(elapsedFormated);
    }

    public void totalSessionTimer() {
        Duration elapsed = Duration.between(this.totalSessionStart, Instant.now());
        String formatString = "ss";
        String elapsedFormated = DurationFormatUtils.formatDuration((long)elapsed.toMillis(), (String)"ss", (boolean)true);
        KphBossInfo kphBossInfo = KphBossInfo.find(this.sessionNpc);
        this.totalSessionTime = kphBossInfo.getDisplayType() == 1 ? Integer.parseInt(elapsedFormated) + this.timerOffset - this.pauseTime : Integer.parseInt(elapsedFormated) + this.firstKillTime - this.pauseTime;
        this.panel.setSessionTimeLabel();
    }

    public void sessionTimeoutTimer() {
        int timeoutTime;
        Duration offsetTime = Duration.between(this.timeoutStart, Instant.now());
        String formatString = "mm";
        String offsetTimeFormated = DurationFormatUtils.formatDuration((long)offsetTime.toMillis(), (String)"mm", (boolean)true);
        int timeoutCount = Integer.parseInt(offsetTimeFormated);
        if (timeoutCount >= (timeoutTime = this.config.timeoutTime())) {
            this.sessionEnd();
        }
    }

    public String avgKillTimeConverter() {
        String minutes;
        String seconds;
        if (this.averageKillTime < 60) {
            seconds = String.format("%02d", this.averageKillTime);
            minutes = "00";
        } else {
            minutes = String.format("%02d", this.averageKillTime / 60);
            seconds = String.format("%02d", this.averageKillTime % 60);
        }
        return minutes + ":" + seconds;
    }

    public String timeConverter(int time) {
        String minutes;
        String seconds;
        if (time > 3600) {
            String hours = String.format("%02d", time / 3600);
            String minutes2 = String.format("%02d", time % 3600 / 60);
            String seconds2 = String.format("%02d", time % 60);
            return hours + ":" + minutes2 + ":" + seconds2;
        }
        if (time < 60) {
            seconds = String.format("%02d", time);
            minutes = "00";
        } else {
            minutes = String.format("%02d", time / 60);
            seconds = String.format("%02d", time % 60);
        }
        return minutes + ":" + seconds;
    }

    @Provides
    KphConfig provideConfig(ConfigManager configManager) {
        return (KphConfig)configManager.getConfig(KphConfig.class);
    }

    protected void startUp() throws Exception {
        this.chatCommandManager.registerCommandAsync("!Info", this::infoCommand);
        this.chatCommandManager.registerCommandAsync("!End", this::endCommand);
        this.chatCommandManager.registerCommandAsync("!Pause", this::pauseCommand);
        this.chatCommandManager.registerCommandAsync("!Resume", this::resumeCommand);
        if (this.config.showSidePanel()) {
            this.buildSidePanel();
        }
        this.calcMode = 0;
        this.paused = false;
        this.cacheHasInfo = false;
        this.overlayManager.add((Overlay)this.overlay);
        this.overlayManager.add((Overlay)this.kphBossGoalsOverlay);
    }

    protected void shutDown() throws Exception {
        this.sessionEnd();
        this.chatCommandManager.unregisterCommand("!Info");
        this.chatCommandManager.unregisterCommand("!End");
        this.chatCommandManager.unregisterCommand("!Pause");
        this.chatCommandManager.unregisterCommand("!Resume");
        this.clientToolbar.removeNavigation(this.navButton);
        this.infoBoxManager.removeInfoBox((InfoBox)this.infobox);
        this.overlayManager.remove((Overlay)this.overlay);
        this.overlayManager.remove((Overlay)this.kphBossGoalsOverlay);
    }

    public KphPanel getPanel() {
        return this.panel;
    }

    public int getCalcMode() {
        return this.calcMode;
    }

    public void setCalcMode(int calcMode) {
        this.calcMode = calcMode;
    }
}

