/*
 * Decompiled with CFR 0.152.
 */
package com.killsperhour;

import com.killsperhour.FileReadWriter;
import com.killsperhour.KphBossGoalsOverlay;
import com.killsperhour.KphBossInfo;
import com.killsperhour.KphConfig;
import com.killsperhour.KphPlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.PluginErrorPanel;
import net.runelite.client.ui.components.ProgressBar;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.QuantityFormatter;
import net.runelite.client.util.SwingUtil;

class KphPanel
extends PluginPanel {
    private static final String HTML_LABEL_TEMPLATE = "<html><body style='color:%s'>%s<span style='color:white'>%s</span></body></html>";
    private final JTextField searchField = new JTextField();
    private final JLabel historicalInfoLabel = new JLabel();
    private final JLabel totalTrackedTime = new JLabel();
    private final JLabel totalTrackedKills = new JLabel();
    private final JLabel actualTotalAverageKillTime = new JLabel();
    private final JLabel actualTotalKph = new JLabel();
    private final JLabel overallFastestKill = new JLabel();
    private final JLabel sessionTimeLabel = new JLabel(KphPanel.htmlLabel("Session Time: ", "N/A"));
    private final JLabel totalBossKillsLabel = new JLabel(KphPanel.htmlLabel("Kills: ", "N/A"));
    private final JLabel averageKillTimeLabel = new JLabel(KphPanel.htmlLabel("Average Kill: ", "N/A"));
    private final JLabel fastestKillTimeLabel = new JLabel(KphPanel.htmlLabel("Fastest Kill: ", "N/A"));
    private final JLabel killsPerHourLabel = new JLabel(KphPanel.htmlLabel("KPH: ", "N/A"));
    private final JLabel idleTimeLabel = new JLabel(KphPanel.htmlLabel("Idle Time: ", "N/A"));
    private final JLabel fetchedBossName = new JLabel("Unknown Boss");
    private final JLabel fetchedTotalTimeActual = new JLabel(KphPanel.htmlLabel("Total Session Time: ", "N/A"));
    private final JLabel fetchedTotalTimeVirtual = new JLabel(KphPanel.htmlLabel("Total Boss Time: ", "N/A"));
    private final JLabel fetchedTotalTrackedKills = new JLabel(KphPanel.htmlLabel("Tracked Kills: ", "N/A"));
    private final JLabel fetchedFastestKill = new JLabel(KphPanel.htmlLabel("Fastest Kill: ", "N/A"));
    private final JLabel fetchedKillsPerHour = new JLabel(KphPanel.htmlLabel("KPH: ", "N/A"));
    private final JLabel fetchedTotalBossKc = new JLabel(KphPanel.htmlLabel("Total KC: ", "N/A"));
    private final JLabel fetchedAverageKillTime = new JLabel(KphPanel.htmlLabel("Average Kill: ", "N/A"));
    private final JLabel estimatedTimeSpentBossing = new JLabel(KphPanel.htmlLabel("EST Bossing Time: ", "N/A"));
    private final JLabel lookupHeaderTitle = new JLabel("Boss Info Lookup");
    private final JLabel searchIcon = new JLabel(SEARCH_ICON);
    private final JLabel picLabel = new JLabel();
    private final JLabel fetchedIconLabel = new JLabel();
    private final JLabel startKcLabel = new JLabel("Start KC:");
    private final JLabel endKcLabel = new JLabel("End KC:");
    private final JLabel bossGoalsKphLabel = new JLabel(KphPanel.htmlLabel("KPH: ", "N/A"));
    private final JLabel killsDoneLabel = new JLabel(KphPanel.htmlLabel("Kills Done: ", "N/A"));
    private final JLabel killsLeftLabel = new JLabel(KphPanel.htmlLabel("Kills Left: ", "N/A"));
    private final JLabel timeToGoalLabel = new JLabel(KphPanel.htmlLabel("TTG: ", "N/A"));
    private final JLabel bossGoalsIconLabel = new JLabel();
    JLabel currentBossNameLabel = new JLabel("Unknown Boss Name");
    private final JPanel lookupPanelHeaderContents = new JPanel();
    private final JPanel historicalInfoSection = new JPanel(new GridBagLayout());
    private final JPanel buttonIconTab;
    private final JPanel icon;
    private final JPanel fetchedIcon;
    private final JPanel closeAndTrashButtonPanel;
    private final JPanel sidePanel;
    private final JPanel titlePanel;
    final JPanel fetchedInfoPanel;
    private final JPanel lootPanel;
    private final JPanel lootHeaderPanel;
    private final JPanel bossInfoPanel;
    private final JPanel historicalInfoPanel;
    private final JPanel lookupInfoPanelHeader;
    private final JPanel pauseAndResumeButtons;
    private final JPanel sessionEndButton;
    private final JPanel supportButtons;
    private final JPanel bossGoalsInputPanel = new JPanel();
    private final JPanel goalInfoPanel = new JPanel();
    private final JPanel goalInfoPanel2 = new JPanel();
    private final JPanel progressBarPanel = new JPanel(new BorderLayout());
    final JPanel bossGoalsPanel;
    private final JToggleButton dropdownButton = new JToggleButton();
    private final JButton closeButton = new JButton(CLOSE_ICON);
    private final JButton trashButton = new JButton(TRASH_ICON);
    private final JButton searchButton = new JButton();
    JButton pauseResumeButton = new JButton();
    JButton switchModeButton = new JButton();
    final SpinnerNumberModel startKcModel = new SpinnerNumberModel(0, 0, 10000000, 1);
    final SpinnerNumberModel endKcModel = new SpinnerNumberModel(0, 0, 10000000, 5);
    private final JSpinner startKcSpinner = new JSpinner(this.startKcModel);
    private final JSpinner endKcSpinner = new JSpinner(this.endKcModel);
    final ProgressBar progressBar = new ProgressBar();
    private static final ImageIcon TRASH_ICON;
    private static final ImageIcon TRASH_ICON_HOVER;
    private static final ImageIcon CLOSE_ICON;
    private static final ImageIcon CLOSE_ICON_HOVER;
    private static final ImageIcon SEARCH_ICON;
    private static final ImageIcon SEARCH_ICON_HOVER;
    private static final ImageIcon DROPDOWN_ICON;
    private static final ImageIcon DROPDOWN_HOVER;
    private static final ImageIcon DROPDOWN_FLIPPED_ICON;
    private static final ImageIcon DROPDOWN_FLIPPED_HOVER;
    private static final ImageIcon DISCORD_ICON;
    private static final ImageIcon DISCORD_HOVER;
    private static final ImageIcon GITHUB_ICON;
    private static final ImageIcon GITHUB_HOVER;
    private static final ImageIcon VISIBLE_ICON;
    private static final ImageIcon INVISABLE_ICON;
    private AsyncBufferedImage fetchedBossSprite;
    private final KphConfig config;
    private final KphPlugin plugin;
    private final FileReadWriter fileRW;
    private KphBossGoalsOverlay goalsOverlay;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ClientThread clientThread;
    JToggleButton lootHeaderButtonPanel = new JToggleButton();
    JToggleButton hideItemButton = new JToggleButton();
    JLabel gpPerHourLabel = new JLabel(KphPanel.htmlLabel("Gp/Hr: ", "N/A"));
    JLabel gpPerKill = new JLabel(KphPanel.htmlLabel("Gp/Kill: ", "N/A"));
    JLabel totalGpLabel = new JLabel(KphPanel.htmlLabel("Total Gp: ", "N/A"));
    JLabel killsTrackedLabel = new JLabel(KphPanel.htmlLabel("Kills: ", "N/A"));
    JPanel masterPanel = new JPanel();
    private static final int ITEMS_PER_ROW = 5;
    private static final Dimension ITEM_SIZE;
    JPanel containerPanel = new JPanel();
    int killsDone;
    int totalKillsToGet;
    int killsLeft;
    double TTG;
    double percentDone;
    String searchInput;
    private Map<Integer, Integer> currentLootTable = new HashMap<Integer, Integer>();
    int startKC;
    int endKC;

    @Inject
    KphPanel(KphPlugin plugin, KphConfig config, FileReadWriter fileRW) {
        this.fetchedIcon = new JPanel();
        this.fetchedInfoPanel = new JPanel();
        this.closeAndTrashButtonPanel = new JPanel();
        this.sessionEndButton = new JPanel();
        this.pauseAndResumeButtons = new JPanel();
        this.supportButtons = new JPanel();
        this.sidePanel = new JPanel();
        this.titlePanel = new JPanel();
        this.bossInfoPanel = new JPanel();
        this.historicalInfoPanel = new JPanel();
        this.lookupInfoPanelHeader = new JPanel();
        this.buttonIconTab = new JPanel();
        this.lootPanel = new JPanel();
        this.lootHeaderPanel = new JPanel();
        this.bossGoalsPanel = new JPanel();
        this.icon = new JPanel();
        this.plugin = plugin;
        this.config = config;
        this.fileRW = fileRW;
    }

    void sidePanelInitializer() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.sidePanel.setLayout(new BoxLayout(this.sidePanel, 1));
        this.sidePanel.add(this.buildTitlePanel());
        this.sidePanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.sidePanel.add(this.buildBossInfoPanel());
        this.sidePanel.add(this.buildBossGoalsPanel());
        this.sidePanel.add(this.buildButtonIconTab());
        this.sidePanel.add(this.buildGridTest());
        this.sidePanel.add(this.buildLootPanel());
        this.sidePanel.add(this.buildPauseAndResumebuttons());
        this.sidePanel.add(this.buildSessionEndButton());
        this.sidePanel.add(this.buildSupportbuttons());
        this.buildFetchedInfoPanel();
        this.buildlookupInfoPanelHeader();
        this.buildHistoricalInfoPanel();
        if (!this.config.displayBossGoalsPanel()) {
            this.bossGoalsPanel.setVisible(false);
        }
        this.add(this.sidePanel, "North");
    }

    private JPanel buildGridTest() {
        this.masterPanel.setLayout(new BorderLayout());
        this.lootHeaderPanel.setLayout(new BorderLayout());
        this.lootHeaderPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.lootHeaderPanel.setBorder(new MatteBorder(1, 1, 1, 1, new Color(57, 57, 57)));
        JPanel lootHeaderSubContainer = new JPanel();
        JPanel bottomInfo = new JPanel();
        JPanel topInfo = new JPanel();
        this.lootHeaderButtonPanel.setLayout(new GridLayout(2, 0, 0, 0));
        lootHeaderSubContainer.setLayout(new BorderLayout());
        lootHeaderSubContainer.setBorder(new MatteBorder(1, 1, 1, 1, new Color(57, 57, 57)));
        bottomInfo.setLayout(new GridLayout(0, 2, 0, 0));
        topInfo.setLayout(new BorderLayout());
        lootHeaderSubContainer.setBorder(new EmptyBorder(5, 0, 0, 0));
        this.lootHeaderButtonPanel.setPreferredSize(new Dimension(200, 35));
        this.lootHeaderButtonPanel.setBorder(new EmptyBorder(4, 5, 0, 5));
        this.hideItemButton.setIcon(INVISABLE_ICON);
        this.hideItemButton.setSelectedIcon(VISIBLE_ICON);
        this.gpPerHourLabel.setFont(FontManager.getRunescapeSmallFont());
        this.gpPerKill.setFont(FontManager.getRunescapeSmallFont());
        this.totalGpLabel.setFont(FontManager.getRunescapeSmallFont());
        this.killsTrackedLabel.setFont(FontManager.getRunescapeSmallFont());
        SwingUtil.removeButtonDecorations((AbstractButton)this.hideItemButton);
        SwingUtil.removeButtonDecorations((AbstractButton)this.lootHeaderButtonPanel);
        this.lootHeaderButtonPanel.setRolloverEnabled(false);
        this.hideItemButton.setPreferredSize(new Dimension(20, 18));
        this.hideItemButton.addActionListener(e -> this.clientThread.invoke(() -> this.updateLootGrid(this.lootDisplayMap())));
        this.lootHeaderButtonPanel.addActionListener(e -> this.collapseLoot());
        this.gpPerKill.setForeground(Color.WHITE);
        topInfo.setBorder(new EmptyBorder(0, 0, 0, 0));
        topInfo.add((Component)this.gpPerKill, "West");
        topInfo.add((Component)this.hideItemButton, "East");
        this.killsTrackedLabel.setBorder(new EmptyBorder(0, 48, 0, 0));
        topInfo.add((Component)this.killsTrackedLabel, "Center");
        bottomInfo.add(this.gpPerHourLabel);
        bottomInfo.add(this.totalGpLabel);
        topInfo.setBackground(new Color(30, 30, 30));
        bottomInfo.setBackground(new Color(30, 30, 30));
        this.lootHeaderButtonPanel.add((Component)topInfo, "North");
        this.lootHeaderButtonPanel.add((Component)bottomInfo, "South");
        this.lootHeaderButtonPanel.setBackground(new Color(30, 30, 30));
        this.lootHeaderPanel.setBackground(new Color(30, 30, 30));
        this.lootHeaderPanel.add(this.lootHeaderButtonPanel);
        this.masterPanel.add((Component)lootHeaderSubContainer, "North");
        this.masterPanel.add((Component)this.lootHeaderPanel, "South");
        return this.masterPanel;
    }

    public Map<Integer, Integer> lootDisplayMap() {
        if (this.plugin.getPanel().fetchedInfoPanel.isShowing()) {
            return this.fileRW.fetchedAllItemDrops;
        }
        if (this.fileRW.cachedItemDrops != null && this.plugin.sessionNpc == null) {
            return this.fileRW.cachedItemDrops;
        }
        if (!this.plugin.getPanel().fetchedInfoPanel.isShowing() && this.config.lootDisplay() == KphConfig.LootDisplay.ALL_TIME && this.plugin.sessionNpc != null) {
            return this.fileRW.allItemDrops;
        }
        return this.fileRW.sessionItemDrops;
    }

    static String doubleFormatNumber(double num) {
        DecimalFormat twoP = new DecimalFormat("#.##");
        DecimalFormat oneP = new DecimalFormat("#.#");
        if (num >= 1.0E9) {
            return twoP.format(num /= 1.0E9) + "B";
        }
        if (num >= 1000000.0) {
            return twoP.format(num /= 1000000.0) + "M";
        }
        if (num >= 1000.0) {
            return oneP.format(num /= 1000.0) + "K";
        }
        return oneP.format(num);
    }

    public double convertToGpPerHour(int kills, double Kph) {
        return this.fileRW.totalGp / (double)kills * Kph;
    }

    public double convertToGpPerKill(int kills) {
        return this.fileRW.totalGp / (double)kills;
    }

    public void updateLootHeaderInfo(int kills, double Kph) {
        FontMetrics fontMetrics = this.getGraphics().getFontMetrics(FontManager.getRunescapeSmallFont());
        this.totalGpLabel.setText(KphPanel.htmlLabel("Total Gp: ", KphPanel.doubleFormatNumber(this.fileRW.totalGp)));
        this.gpPerHourLabel.setText(KphPanel.htmlLabel("GP/Hr: ", KphPanel.doubleFormatNumber(this.convertToGpPerHour(kills, Kph))));
        this.gpPerKill.setText(KphPanel.htmlLabel("GP/Kill: ", KphPanel.doubleFormatNumber(this.convertToGpPerKill(kills))));
        if (this.fileRW.totalGp == 0.0) {
            kills = 0;
        }
        this.killsTrackedLabel.setText(KphPanel.htmlLabel("Kills: ", String.valueOf(kills)));
        this.killsTrackedLabel.setBorder(new EmptyBorder(0, 535 - fontMetrics.stringWidth(this.gpPerKill.getText()), 0, 0));
    }

    public void collapseLoot() {
        this.lootPanel.setVisible(!this.lootHeaderButtonPanel.isSelected());
    }

    public void updateLootGrid(Map<Integer, Integer> lootMap) {
        for (Map.Entry<Integer, Integer> entry : lootMap.entrySet()) {
            double itemPrice = this.itemManager.getItemPrice(entry.getKey().intValue());
            this.fileRW.itemAndTotalPrice.put(entry.getKey(), itemPrice *= (double)entry.getValue().intValue());
        }
        SwingUtilities.invokeLater(() -> this.lootGrid(lootMap));
    }

    /*
     * WARNING - void declaration
     */
    public void lootGrid(Map<Integer, Integer> lootMap) {
        JPanel slot;
        this.fileRW.loadIgnoredList(this.provideBossName());
        HashMap<Object, Object> sorted = new HashMap();
        if (!this.fileRW.itemAndTotalPrice.isEmpty()) {
            sorted = this.fileRW.sortByValue(this.fileRW.itemAndTotalPrice, lootMap);
        }
        JPanel containerCurrent = new JPanel();
        int totalItems = this.hideItemButton.isSelected() || this.fileRW.ignored == null ? sorted.keySet().size() : sorted.keySet().size() - this.fileRW.ignored.size();
        this.containerPanel.setBorder(new EmptyBorder(2, 2, 5, 2));
        containerCurrent.setBorder(new EmptyBorder(2, 2, 5, 2));
        int rowSize = (totalItems % 5 == 0 ? 0 : 1) + totalItems / 5;
        this.containerPanel.setLayout(new GridLayout(rowSize, 5, 1, 1));
        containerCurrent.setLayout(new GridLayout(rowSize, 5, 1, 1));
        for (Integer n : sorted.keySet()) {
            slot = new JPanel();
            slot.setLayout(new GridLayout(1, 1, 0, 0));
            slot.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            slot.setPreferredSize(ITEM_SIZE);
            JLabel itemLabel = new JLabel();
            this.clientThread.invoke(() -> itemLabel.setToolTipText(this.buildToolTip(key, lootMap)));
            itemLabel.setVerticalAlignment(0);
            itemLabel.setHorizontalAlignment(0);
            AsyncBufferedImage itemImage = this.itemManager.getImage(n.intValue(), ((Integer)sorted.get(n)).intValue(), (Integer)sorted.get(n) > 1);
            itemImage.addTo(itemLabel);
            JPopupMenu popupMenu = new JPopupMenu();
            itemLabel.setComponentPopupMenu(popupMenu);
            JMenuItem toggle = new JMenuItem("Toggle item");
            toggle.addActionListener(e -> {
                this.fileRW.loadIgnoredList(this.provideBossName());
                if (this.fileRW.ignored.contains(key)) {
                    this.fileRW.ignored.remove(key);
                } else {
                    this.fileRW.ignored.add(key);
                }
                this.fileRW.writeIgnoredListToFile(this.provideBossName());
                this.clientThread.invoke(() -> this.updateLootGrid(lootMap));
            });
            this.fileRW.loadIgnoredList(this.provideBossName());
            if (this.fileRW.ignored.contains(n) && !this.hideItemButton.isSelected()) continue;
            popupMenu.add(toggle);
            if (this.fileRW.ignored.contains(n)) {
                Runnable addTransparency = () -> {
                    BufferedImage transparentImage = ImageUtil.alphaOffset((Image)itemImage, (float)0.3f);
                    itemLabel.setIcon(new ImageIcon(transparentImage));
                };
                itemImage.onLoaded(addTransparency);
                addTransparency.run();
            }
            slot.add(itemLabel);
            containerCurrent.add(slot);
        }
        if (totalItems < 5 || totalItems % 5 != 0) {
            void var7_12;
            int extraBoxes;
            if (totalItems % 5 != 0 && totalItems >= 5) {
                void var7_10;
                int n = totalItems;
                while (var7_10 % 5 != false) {
                    ++var7_10;
                }
                extraBoxes = var7_10 - totalItems;
            } else {
                extraBoxes = 5 - totalItems;
            }
            boolean bl = false;
            while (var7_12 < extraBoxes) {
                slot = new JPanel();
                slot.setLayout(new GridLayout(1, 1, 0, 0));
                slot.setBackground(ColorScheme.DARKER_GRAY_COLOR);
                slot.setPreferredSize(ITEM_SIZE);
                containerCurrent.add(slot);
                ++var7_12;
            }
        }
        this.lootPanel.remove(this.containerPanel);
        this.containerPanel = containerCurrent;
        this.lootPanel.add(this.containerPanel);
        this.fileRW.getTotalPrice();
        if (this.plugin.getPanel().fetchedInfoPanel.isShowing()) {
            this.updateLootHeaderInfo(this.fileRW.lootKillsTracked, this.fileRW.fetchedKillsPerHour);
        }
        if (!this.plugin.getPanel().fetchedInfoPanel.isShowing() && this.config.lootDisplay() == KphConfig.LootDisplay.ALL_TIME) {
            this.fileRW.setFilename(this.plugin.currentBoss);
            this.fileRW.fetchLookupInfo();
            this.updateLootHeaderInfo(this.fileRW.lootKillsTracked, this.fileRW.fetchedKillsPerHour);
        }
        if (!this.plugin.getPanel().fetchedInfoPanel.isShowing() && this.config.lootDisplay() == KphConfig.LootDisplay.SESSION) {
            this.updateLootHeaderInfo(this.plugin.killsThisSession, Double.parseDouble(this.plugin.formatKPH()));
        }
        if (!this.plugin.getPanel().fetchedInfoPanel.isShowing() && this.plugin.sessionNpc == null && this.plugin.cacheHasInfo) {
            this.updateLootHeaderInfo(this.plugin.cachedSessionKills, Double.parseDouble(this.plugin.cachedKPH));
        }
        this.lootPanel.revalidate();
        this.lootPanel.repaint();
    }

    public String provideBossName() {
        if (this.plugin.getPanel().fetchedInfoPanel.isShowing()) {
            return this.searchInput;
        }
        return this.plugin.currentBoss;
    }

    private String buildToolTip(int key, Map<Integer, Integer> lootMap) {
        String name = this.itemManager.getItemComposition(key).getName();
        int quantity = lootMap.get(key);
        long price = this.itemManager.getItemPrice(key);
        return "<html>" + name + " x " + QuantityFormatter.formatNumber((long)quantity) + "<br/>Price: " + QuantityFormatter.quantityToStackSize((long)price) + "<br/>Total: " + QuantityFormatter.quantityToStackSize((long)((long)quantity * price)) + "</html>";
    }

    private JPanel buildLootPanel() {
        this.lootPanel.setLayout(new BorderLayout());
        this.lootPanel.setBorder(new EmptyBorder(0, 0, 8, 0));
        this.lootPanel.setBorder(new MatteBorder(0, 0, 1, 0, new Color(37, 125, 141)));
        return this.lootPanel;
    }

    public void updateBossGoalsPanel() {
        if (this.plugin.sessionNpc == null) {
            return;
        }
        if (this.fileRW.startKc == 0 && this.fileRW.endKc == 0) {
            this.bossGoalsKphLabel.setText(KphPanel.htmlLabel("KPH: ", "N/A"));
            this.killsDoneLabel.setText(KphPanel.htmlLabel("Kills Done: ", "N/A"));
            this.killsLeftLabel.setText(KphPanel.htmlLabel("Kills Left: ", "N/A"));
            this.timeToGoalLabel.setText(KphPanel.htmlLabel("TTG: ", "N/A"));
            KphBossInfo kphBossInfo = KphBossInfo.find(this.plugin.sessionNpc);
            this.itemManager.getImage(kphBossInfo.getIcon()).addTo(this.bossGoalsIconLabel);
            this.bossGoalsIconLabel.setVisible(true);
            this.goalInfoPanel.setBorder(new EmptyBorder(5, 0, 0, 17));
            this.progressBar.setLeftLabel("");
            this.progressBar.setRightLabel("");
            this.progressBar.setCenterLabel("Set a goal");
            this.progressBar.setValue(0);
            this.progressBar.setDimmed(false);
            return;
        }
        DecimalFormat df = new DecimalFormat("#.#");
        this.killsDone = this.plugin.killCount - this.fileRW.startKc;
        this.totalKillsToGet = this.fileRW.endKc - this.fileRW.startKc;
        this.killsLeft = this.totalKillsToGet - this.killsDone;
        this.TTG = (double)this.killsLeft / this.plugin.killsPerHour;
        this.percentDone = 100.0 * ((double)this.killsDone / (double)this.totalKillsToGet);
        if (this.killsLeft <= 0) {
            this.bossGoalsKphLabel.setText(KphPanel.htmlLabel("KPH: ", this.plugin.formatKPH()));
            this.killsDoneLabel.setText(KphPanel.htmlLabel("Kills Done: ", String.valueOf(this.totalKillsToGet)));
            this.killsLeftLabel.setText(KphPanel.htmlLabel("Kills Left: ", "0"));
            this.timeToGoalLabel.setText(KphPanel.htmlLabel("TTG: ", "00:00:00"));
            this.progressBar.setCenterLabel("Completed");
            this.progressBar.setValue(100);
        } else {
            this.bossGoalsKphLabel.setText(KphPanel.htmlLabel("KPH: ", this.plugin.formatKPH()));
            this.killsDoneLabel.setText(KphPanel.htmlLabel("Kills Done: ", String.valueOf(this.killsDone)));
            this.killsLeftLabel.setText(KphPanel.htmlLabel("Kills Left: ", String.valueOf(this.killsLeft)));
            this.timeToGoalLabel.setText(KphPanel.htmlLabel("TTG: ", this.plugin.timeConverter((int)(this.TTG * 3600.0))));
            this.percentDone = Double.parseDouble(df.format(this.percentDone));
            this.progressBar.setCenterLabel(this.percentDone + "%");
            this.progressBar.setValue((int)this.percentDone);
        }
        if (this.config.displayRelativeKills()) {
            this.progressBar.setLeftLabel(String.valueOf(0));
            this.progressBar.setRightLabel(String.valueOf(this.totalKillsToGet));
        } else {
            this.progressBar.setLeftLabel(String.valueOf(this.fileRW.startKc));
            this.progressBar.setRightLabel(String.valueOf(this.fileRW.endKc));
        }
        FontMetrics fontMetrics = this.getGraphics().getFontMetrics(FontManager.getRunescapeSmallFont());
        boolean killsDoneIsLonger = fontMetrics.stringWidth(this.killsLeftLabel.getText()) < fontMetrics.stringWidth(this.killsDoneLabel.getText());
        int length = killsDoneIsLonger ? fontMetrics.stringWidth(this.killsDoneLabel.getText()) : fontMetrics.stringWidth(this.killsLeftLabel.getText());
        int offset = 521 - length;
        this.goalInfoPanel.setBorder(new EmptyBorder(5, 0, 0, offset));
        KphBossInfo kphBossInfo = KphBossInfo.find(this.plugin.sessionNpc);
        this.itemManager.getImage(kphBossInfo.getIcon()).addTo(this.bossGoalsIconLabel);
        this.bossGoalsIconLabel.setVisible(true);
        this.progressBar.setForeground(new Color(91, 154, 47));
        this.progressBar.setDimmed(false);
        if (this.plugin.paused) {
            this.progressBar.setCenterLabel("Paused");
            this.progressBar.setForeground(new Color(167, 125, 38));
        }
        this.progressBar.repaint();
    }

    private JPanel buildBossGoalsPanel() {
        this.bossGoalsPanel.setLayout(new BorderLayout());
        this.bossGoalsPanel.setBorder(new EmptyBorder(0, 10, 0, 10));
        this.bossGoalsPanel.setBorder(new MatteBorder(1, 1, 1, 1, new Color(49, 49, 49)));
        this.progressBarPanel.setBorder(new EmptyBorder(5, 5, 7, 5));
        this.progressBar.setBackground(new Color(61, 56, 49));
        this.progressBar.setForeground(new Color(91, 154, 47));
        this.progressBar.setMaximumValue(100);
        this.progressBar.setCenterLabel(this.percentDone + "%");
        this.progressBar.setValue((int)this.percentDone);
        this.progressBarPanel.add((Component)this.progressBar);
        this.progressBarPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JMenuItem setBossGoalMenuItem = new JMenuItem("Set Boss Goal");
        setBossGoalMenuItem.addActionListener(e -> this.bossGoalsOptionPane());
        JMenuItem resetBossGoalMenuItem = new JMenuItem("Reset Boss Goal");
        resetBossGoalMenuItem.addActionListener(e -> this.fileRW.resetBossGoal());
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.setBorder(new EmptyBorder(5, 5, 5, 5));
        popupMenu.add(setBossGoalMenuItem);
        popupMenu.add(resetBossGoalMenuItem);
        this.bossGoalsPanel.setComponentPopupMenu(popupMenu);
        JPanel iconPanel = new JPanel(new GridBagLayout());
        iconPanel.setLayout(new GridLayout(0, 1, 0, 0));
        iconPanel.setBorder(new EmptyBorder(5, 5, 0, 0));
        this.bossGoalsKphLabel.setFont(FontManager.getRunescapeSmallFont());
        this.killsDoneLabel.setFont(FontManager.getRunescapeSmallFont());
        this.timeToGoalLabel.setFont(FontManager.getRunescapeSmallFont());
        this.killsLeftLabel.setFont(FontManager.getRunescapeSmallFont());
        this.goalInfoPanel.setLayout(new GridLayout(2, 0, 0, 0));
        this.goalInfoPanel.setBorder(new EmptyBorder(5, 0, 0, 17));
        this.goalInfoPanel2.setLayout(new GridLayout(2, 0, 0, 0));
        this.goalInfoPanel2.setBorder(new EmptyBorder(5, 3, 0, 3));
        this.bossGoalsIconLabel.setIcon(new ImageIcon((Image)this.itemManager.getImage(23757)));
        this.bossGoalsIconLabel.setVisible(false);
        iconPanel.setOpaque(false);
        this.goalInfoPanel.setOpaque(false);
        this.goalInfoPanel2.setOpaque(false);
        this.progressBarPanel.setOpaque(false);
        iconPanel.add(this.bossGoalsIconLabel);
        this.goalInfoPanel2.add(this.bossGoalsKphLabel);
        this.goalInfoPanel.add(this.killsDoneLabel);
        this.goalInfoPanel2.add(this.timeToGoalLabel);
        this.goalInfoPanel.add(this.killsLeftLabel);
        this.bossGoalsPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.bossGoalsPanel.add(this.goalInfoPanel2);
        this.bossGoalsPanel.add((Component)this.goalInfoPanel, "East");
        this.bossGoalsPanel.add((Component)iconPanel, "West");
        this.bossGoalsPanel.add((Component)this.progressBarPanel, "South");
        return this.bossGoalsPanel;
    }

    private JPanel buildlookupInfoPanelHeader() {
        this.lookupPanelHeaderContents.setLayout(new GridLayout(0, 1, 0, 5));
        this.lookupPanelHeaderContents.setBorder(new EmptyBorder(0, 0, 10, 20));
        this.searchField.setBackground(new Color(57, 57, 57));
        this.searchField.setBorder(new MatteBorder(1, 1, 1, 1, new Color(30, 30, 30)));
        this.searchField.setMaximumSize(new Dimension(167, 20));
        this.searchField.setMinimumSize(new Dimension(167, 20));
        this.searchField.setPreferredSize(new Dimension(167, 20));
        this.searchField.addActionListener(e -> this.fetchLookupInfo());
        this.lookupInfoPanelHeader.setLayout(new BorderLayout());
        this.lookupInfoPanelHeader.setBorder(new EmptyBorder(5, 0, 4, 0));
        this.lookupInfoPanelHeader.setBorder(new MatteBorder(0, 0, 1, 0, new Color(37, 125, 141)));
        this.searchIcon.setBorder(new EmptyBorder(13, 10, 0, 0));
        this.lookupHeaderTitle.setFont(FontManager.getRunescapeBoldFont());
        this.lookupHeaderTitle.setBorder(new EmptyBorder(0, 20, 0, 0));
        this.lookupPanelHeaderContents.add(this.lookupHeaderTitle);
        this.lookupPanelHeaderContents.add(this.searchField);
        this.lookupInfoPanelHeader.add((Component)this.searchIcon, "West");
        this.lookupInfoPanelHeader.add((Component)this.lookupPanelHeaderContents, "East");
        return this.lookupInfoPanelHeader;
    }

    public void fetchLookupInfo() {
        this.searchInput = this.searchField.getText();
        if (KphBossInfo.bossByWords.containsKey(this.searchInput.toLowerCase())) {
            this.searchInput = KphBossInfo.bossByWords.get(this.searchInput.toLowerCase());
        }
        this.fileRW.setFilename(this.searchInput);
        this.fileRW.fetchLookupInfo();
        for (KphBossInfo bossIconFinder : KphBossInfo.values()) {
            if (this.searchInput.toLowerCase().equals(bossIconFinder.getName().toLowerCase())) {
                KphBossInfo kphBossInfo = KphBossInfo.find(bossIconFinder.getName());
                this.fetchedBossSprite = this.itemManager.getImage(kphBossInfo.getIcon());
                this.fetchedBossName.setText(kphBossInfo.getName());
                this.fetchedBossSprite.addTo(this.fetchedIconLabel);
                this.fetchedIconLabel.setVisible(true);
                break;
            }
            this.fetchedBossName.setText("Unknown Boss");
            this.fetchedIconLabel.setVisible(false);
        }
        FontMetrics fontMetrics = this.getGraphics().getFontMetrics(FontManager.getRunescapeBoldFont());
        int offset = 180 - (fontMetrics.stringWidth(this.fetchedBossName.getText()) + 10);
        this.fetchedIcon.setBorder(new EmptyBorder(0, 0, 0, offset));
        this.updateLookupInfo();
    }

    public void updateLookupInfo() {
        if (this.fileRW.fetchedFile == null || !this.fileRW.fetchedFile.exists()) {
            this.setLookupInfoToNull();
            this.getFetchedLoot();
            return;
        }
        this.fileRW.fetchedStatConverter();
        this.fetchedFastestKill.setText(KphPanel.htmlLabel("Fastest Kill: ", this.plugin.timeConverter(this.fileRW.fetchedFastestKill)));
        this.fetchedTotalTrackedKills.setText(KphPanel.htmlLabel("Tracked Kills: ", String.valueOf(this.fileRW.fetchedTotalTrackedKills)));
        this.fetchedTotalTimeActual.setText(KphPanel.htmlLabel("Total Session Time: ", this.plugin.timeConverter(this.fileRW.fetchedTotalTimeActual)));
        this.fetchedTotalTimeVirtual.setText(KphPanel.htmlLabel("Total Boss Time: ", this.plugin.timeConverter(this.fileRW.fetchedTotalTimeVirtual)));
        this.fetchedKillsPerHour.setText(KphPanel.htmlLabel("KPH: ", String.valueOf(this.fileRW.fetchedKillsPerHour)));
        this.fetchedTotalBossKc.setText(KphPanel.htmlLabel("Total KC: ", String.valueOf(this.fileRW.fetchedTotalBossKc)));
        this.fetchedAverageKillTime.setText(KphPanel.htmlLabel("Average Kill: ", this.plugin.timeConverter(this.fileRW.fetchedAverageKillTime)));
        this.estimatedTimeSpentBossing.setText(KphPanel.htmlLabel("EST Bossing Time: ", this.plugin.timeConverter(this.fileRW.estimatedTimeSpentBossing)));
        this.getFetchedLoot();
    }

    public void getFetchedLoot() {
        this.fileRW.lootDirectory = new File(this.fileRW.file, "boss-loot");
        this.fileRW.subDirectory = new File(this.fileRW.lootDirectory, this.searchInput + ".json");
        this.fileRW.loadFetchedDropsFromMap();
        if (this.fileRW.fetchedFile == null || !this.fileRW.fetchedFile.exists()) {
            this.fileRW.fetchedAllItemDrops = new HashMap<Integer, Integer>();
            this.fileRW.ignored = new ArrayList();
        }
        this.fileRW.itemAndTotalPrice = new HashMap();
        this.fileRW.loadIgnoredList(this.provideBossName());
        this.clientThread.invoke(() -> this.updateLootGrid(this.lootDisplayMap()));
    }

    public void setLookupInfoToNull() {
        this.fetchedFastestKill.setText(KphPanel.htmlLabel("Fastest Kill: ", "N/A"));
        this.fetchedTotalTrackedKills.setText(KphPanel.htmlLabel("Tracked Kills: ", "N/A"));
        this.fetchedTotalTimeActual.setText(KphPanel.htmlLabel("Total Session Time: ", "N/A"));
        this.fetchedTotalTimeVirtual.setText(KphPanel.htmlLabel("Total Boss Time: ", "N/A"));
        this.fetchedKillsPerHour.setText(KphPanel.htmlLabel("KPH: ", "N/A"));
        this.fetchedTotalBossKc.setText(KphPanel.htmlLabel("Total KC: ", "N/A"));
        this.fetchedAverageKillTime.setText(KphPanel.htmlLabel("Average Kill: ", "N/A"));
        this.estimatedTimeSpentBossing.setText(KphPanel.htmlLabel("EST Bossing Time: ", "N/A"));
    }

    private JPanel buildFetchedInfoPanel() {
        this.fetchedInfoPanel.setLayout(new BorderLayout());
        this.fetchedInfoPanel.setBorder(new EmptyBorder(0, 0, 0, 10));
        JPanel fetchedInfoSection = new JPanel();
        fetchedInfoSection.setLayout(new GridLayout(9, 0, 0, 10));
        fetchedInfoSection.setBorder(new EmptyBorder(15, 5, 3, 0));
        this.closeButton.setMaximumSize(new Dimension(30, 25));
        this.closeButton.setPreferredSize(new Dimension(30, 25));
        this.closeButton.setMinimumSize(new Dimension(30, 25));
        this.closeButton.setBorder(new EmptyBorder(0, 0, 0, 7));
        this.closeButton.setRolloverIcon(CLOSE_ICON_HOVER);
        this.closeButton.setToolTipText("Exit to Main Panel");
        this.closeButton.addActionListener(e -> this.closeBossLookupPanels());
        SwingUtil.removeButtonDecorations((AbstractButton)this.closeButton);
        this.closeAndTrashButtonPanel.setLayout(new BorderLayout());
        this.closeAndTrashButtonPanel.add((Component)this.closeButton, "East");
        this.trashButton.setMaximumSize(new Dimension(30, 25));
        this.trashButton.setPreferredSize(new Dimension(30, 25));
        this.trashButton.setMinimumSize(new Dimension(30, 25));
        this.trashButton.setBorder(new EmptyBorder(0, 0, 2, 0));
        this.trashButton.setRolloverIcon(TRASH_ICON_HOVER);
        this.trashButton.setToolTipText("Delete Boss Info");
        this.trashButton.addActionListener(e -> this.deleteFile());
        SwingUtil.removeButtonDecorations((AbstractButton)this.trashButton);
        this.closeAndTrashButtonPanel.add((Component)this.trashButton, "West");
        this.fetchedBossName.setFont(FontManager.getRunescapeBoldFont());
        this.fetchedBossName.setForeground(new Color(219, 219, 219));
        this.fetchedIcon.add(this.fetchedIconLabel);
        fetchedInfoSection.add(this.fetchedBossName);
        fetchedInfoSection.add(this.fetchedKillsPerHour);
        fetchedInfoSection.add(this.fetchedTotalTrackedKills);
        fetchedInfoSection.add(this.fetchedTotalBossKc);
        fetchedInfoSection.add(this.fetchedAverageKillTime);
        fetchedInfoSection.add(this.fetchedFastestKill);
        fetchedInfoSection.add(this.fetchedTotalTimeVirtual);
        fetchedInfoSection.add(this.fetchedTotalTimeActual);
        fetchedInfoSection.add(this.estimatedTimeSpentBossing);
        this.fetchedInfoPanel.setBorder(new MatteBorder(0, 0, 1, 0, new Color(37, 125, 141)));
        this.fetchedIcon.setOpaque(false);
        fetchedInfoSection.setOpaque(false);
        this.fetchedInfoPanel.add((Component)this.closeAndTrashButtonPanel, "South");
        this.fetchedInfoPanel.add((Component)this.fetchedIcon, "East");
        this.fetchedInfoPanel.add((Component)fetchedInfoSection, "West");
        return this.fetchedInfoPanel;
    }

    public static BufferedImage resizeImage(BufferedImage image, int newWidth, int newHeight) {
        BufferedImage scaledImage = new BufferedImage(newWidth, newHeight, 2);
        Graphics2D g = scaledImage.createGraphics();
        g.drawImage(image, 0, 0, newWidth, newHeight, null);
        g.dispose();
        return scaledImage;
    }

    public void bossGoalsOptionPane() {
        this.fileRW.getCurrentBossKCGoal();
        this.startKcSpinner.setBounds(0, 0, 50, 20);
        this.startKcSpinner.setMaximumSize(new Dimension(100, 20));
        this.startKcSpinner.setPreferredSize(new Dimension(100, 20));
        this.startKcSpinner.setMinimumSize(new Dimension(100, 20));
        this.endKcSpinner.setMaximumSize(new Dimension(100, 20));
        this.endKcSpinner.setPreferredSize(new Dimension(100, 20));
        this.endKcSpinner.setMinimumSize(new Dimension(100, 20));
        this.endKcSpinner.addChangeListener(e -> this.getRelativeGoal());
        this.bossGoalsInputPanel.setBorder(new EmptyBorder(0, 0, 5, 0));
        this.bossGoalsInputPanel.setLayout(new GridLayout(0, 2, 0, 5));
        this.bossGoalsInputPanel.setMaximumSize(new Dimension(100, 20));
        this.bossGoalsInputPanel.setPreferredSize(new Dimension(100, 20));
        this.bossGoalsInputPanel.setMinimumSize(new Dimension(100, 20));
        this.startKcLabel.setMaximumSize(new Dimension(120, 20));
        this.startKcLabel.setPreferredSize(new Dimension(120, 20));
        this.startKcLabel.setMinimumSize(new Dimension(120, 20));
        this.endKcLabel.setMaximumSize(new Dimension(120, 20));
        this.endKcLabel.setPreferredSize(new Dimension(120, 20));
        this.endKcLabel.setMinimumSize(new Dimension(120, 20));
        this.endKcLabel.setBorder(new EmptyBorder(0, 0, 0, 20));
        this.startKcLabel.setBorder(new EmptyBorder(0, 0, 0, 20));
        this.bossGoalsInputPanel.add(this.startKcLabel);
        this.bossGoalsInputPanel.add(this.startKcSpinner);
        this.bossGoalsInputPanel.add(this.endKcLabel);
        this.bossGoalsInputPanel.add(this.endKcSpinner);
        KphBossInfo kphBossInfo = KphBossInfo.find(this.plugin.sessionNpc);
        AsyncBufferedImage bossSprite = this.itemManager.getImage(kphBossInfo.getIcon());
        ImageIcon imageIcon = new ImageIcon(KphPanel.resizeImage((BufferedImage)bossSprite, 50, 44));
        UIManager.put("OptionPane.minimumSize", new Dimension(250, 100));
        int option = JOptionPane.showOptionDialog(null, this.bossGoalsInputPanel, "Set Boss KC Goal", 2, 3, imageIcon, null, null);
        if (option == 0) {
            this.startKC = (Integer)this.startKcSpinner.getValue();
            this.endKC = (Integer)this.endKcSpinner.getValue();
            this.fileRW.updateBossKCGoal();
            this.updateBossGoalsPanel();
        }
    }

    public void getRelativeGoal() {
        this.endKcSpinner.setToolTipText("+" + ((Integer)this.endKcSpinner.getValue() - (Integer)this.startKcSpinner.getValue()));
    }

    public void deleteFile() {
        int confirm;
        if (this.fileRW.fetchedFile.exists() && (confirm = JOptionPane.showConfirmDialog((Component)((Object)this), "Are you sure you want to permanently delete these files", "Warning", 2)) == 0) {
            this.deleteTest();
        }
    }

    public void deleteTest() {
        try {
            FileWriter writer;
            Files.delete(this.fileRW.lookupPath);
            this.fileRW.fetchedAllItemDrops = new HashMap<Integer, Integer>();
            this.fileRW.ignored = new ArrayList();
            try {
                writer = new FileWriter(this.fileRW.subDirectory);
                writer.write("[]");
                ((Writer)writer).close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            try {
                writer = new FileWriter(this.fileRW.ignoreDirectory);
                writer.write("[]");
                ((Writer)writer).close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        catch (Exception Io) {
            Io.printStackTrace();
        }
    }

    public void closeBossLookupPanels() {
        this.sidePanel.remove(this.fetchedInfoPanel);
        this.sidePanel.remove(this.lookupInfoPanelHeader);
        this.sidePanel.add(this.bossInfoPanel);
        this.sidePanel.add(this.buttonIconTab);
        this.sidePanel.add(this.bossGoalsPanel);
        this.sidePanel.setComponentZOrder(this.bossInfoPanel, 2);
        this.sidePanel.setComponentZOrder(this.bossGoalsPanel, 3);
        this.sidePanel.setComponentZOrder(this.buttonIconTab, 4);
        this.sidePanel.setComponentZOrder(this.lootHeaderPanel, 5);
        this.sidePanel.setComponentZOrder(this.lootPanel, 6);
        this.sidePanel.revalidate();
        this.fileRW.loadIgnoredList(this.plugin.currentBoss);
        this.clientThread.invoke(() -> this.updateLootGrid(this.lootDisplayMap()));
    }

    public void openBossLookupPanels() {
        this.sidePanel.remove(this.buttonIconTab);
        this.sidePanel.remove(this.bossInfoPanel);
        this.sidePanel.remove(this.historicalInfoPanel);
        this.sidePanel.remove(this.bossGoalsPanel);
        this.sidePanel.add(this.lookupInfoPanelHeader);
        this.sidePanel.add(this.fetchedInfoPanel);
        this.sidePanel.setComponentZOrder(this.lookupInfoPanelHeader, 2);
        this.sidePanel.setComponentZOrder(this.fetchedInfoPanel, 3);
        this.sidePanel.setComponentZOrder(this.lootHeaderPanel, 4);
        this.sidePanel.setComponentZOrder(this.lootPanel, 5);
        this.sidePanel.setComponentZOrder(this.pauseAndResumeButtons, 6);
        this.sidePanel.setComponentZOrder(this.sessionEndButton, 7);
        this.dropdownButton.setSelected(false);
        this.sidePanel.revalidate();
        this.fetchLookupInfo();
    }

    public void openCurrentHistoricalData() {
        this.sidePanel.add(this.historicalInfoPanel);
        this.sidePanel.setComponentZOrder(this.buttonIconTab, 4);
        this.sidePanel.setComponentZOrder(this.historicalInfoPanel, 5);
        this.sidePanel.revalidate();
        this.fillHistoricalData();
    }

    public void fillHistoricalData() {
        this.historicalInfoLabel.setText("Historical Information");
        this.totalTrackedTime.setText(KphPanel.htmlLabel("Time Tracked: ", this.plugin.timeConverter(this.fileRW.overallTime)));
        this.totalTrackedKills.setText(KphPanel.htmlLabel("Kills Tracked: ", String.valueOf(this.fileRW.newTotalKills)));
        this.actualTotalAverageKillTime.setText(KphPanel.htmlLabel("Average Kill: ", this.plugin.timeConverter(this.fileRW.averageKillTime)));
        this.actualTotalKph.setText(KphPanel.htmlLabel("KPH: ", String.valueOf(this.fileRW.killsPerHour)));
        this.overallFastestKill.setText(KphPanel.htmlLabel("Fastest Kill: ", this.plugin.timeConverter(this.fileRW.newFastestKill)));
    }

    public void closeCurrentHistoricalData() {
        this.sidePanel.remove(this.historicalInfoPanel);
        this.sidePanel.revalidate();
    }

    private JPanel buildHistoricalInfoPanel() {
        this.historicalInfoPanel.setLayout(new BorderLayout());
        this.historicalInfoPanel.setBorder(new EmptyBorder(0, 10, 8, 10));
        this.historicalInfoPanel.setBorder(new MatteBorder(0, 0, 1, 0, new Color(37, 125, 141)));
        this.historicalInfoSection.setLayout(new GridLayout(6, 0, 0, 10));
        this.historicalInfoSection.setBorder(new EmptyBorder(10, 5, 10, 0));
        this.historicalInfoLabel.setFont(FontManager.getRunescapeBoldFont());
        this.historicalInfoSection.setOpaque(false);
        this.historicalInfoSection.add(this.historicalInfoLabel);
        this.historicalInfoSection.add(this.actualTotalKph);
        this.historicalInfoSection.add(this.totalTrackedKills);
        this.historicalInfoSection.add(this.actualTotalAverageKillTime);
        this.historicalInfoSection.add(this.totalTrackedTime);
        this.historicalInfoSection.add(this.overallFastestKill);
        this.historicalInfoPanel.add((Component)this.historicalInfoSection, "West");
        return this.historicalInfoPanel;
    }

    public void setHistoricalInfo() {
        if (this.dropdownButton.isSelected()) {
            this.fillHistoricalData();
        }
    }

    private JPanel buildTitlePanel() {
        this.titlePanel.setBorder(new CompoundBorder(new EmptyBorder(5, 0, 0, 0), new MatteBorder(0, 0, 1, 0, new Color(37, 125, 141))));
        this.titlePanel.setLayout(new BorderLayout());
        PluginErrorPanel errorPanel = new PluginErrorPanel();
        errorPanel.setBorder((Border)new EmptyBorder(2, 0, 3, 0));
        errorPanel.setContent("Bossing Info", "Provides various bossing statistics & utilities");
        this.titlePanel.add((Component)errorPanel, "Center");
        return this.titlePanel;
    }

    private JPanel buildBossInfoPanel() {
        this.bossInfoPanel.setLayout(new BorderLayout());
        this.bossInfoPanel.setBorder(new EmptyBorder(0, 0, 4, 0));
        JPanel sessionInfoSection = new JPanel(new GridBagLayout());
        sessionInfoSection.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        sessionInfoSection.setLayout(new GridLayout(7, 1, 0, 10));
        sessionInfoSection.setBorder(new EmptyBorder(10, 5, 3, 0));
        this.currentBossNameLabel.setFont(FontManager.getRunescapeBoldFont());
        this.icon.setLayout(new GridLayout(0, 2, 0, 0));
        this.icon.setBorder(new EmptyBorder(0, 0, 180, 150));
        this.icon.setOpaque(false);
        sessionInfoSection.setOpaque(false);
        this.icon.add(this.picLabel);
        sessionInfoSection.add(this.currentBossNameLabel);
        sessionInfoSection.add(this.killsPerHourLabel);
        sessionInfoSection.add(this.totalBossKillsLabel);
        sessionInfoSection.add(this.averageKillTimeLabel);
        sessionInfoSection.add(this.fastestKillTimeLabel);
        sessionInfoSection.add(this.idleTimeLabel);
        sessionInfoSection.add(this.sessionTimeLabel);
        this.bossInfoPanel.add((Component)this.icon, "East");
        this.bossInfoPanel.add((Component)sessionInfoSection, "West");
        return this.bossInfoPanel;
    }

    public void setBossIcon(String bossName) {
        if (this.plugin.sessionNpc != null) {
            KphBossInfo kphBossInfo = KphBossInfo.find(bossName);
            AsyncBufferedImage bossSprite = this.itemManager.getImage(kphBossInfo.getIcon());
            FontMetrics fontMetrics = this.getGraphics().getFontMetrics(FontManager.getRunescapeBoldFont());
            int offset = 150 - (fontMetrics.stringWidth(this.plugin.sessionNpc) + 10);
            this.icon.setBorder(new EmptyBorder(0, 0, 153, offset));
            bossSprite.addTo(this.picLabel);
        }
    }

    private JPanel buildButtonIconTab() {
        this.searchButton.setIcon(SEARCH_ICON);
        this.searchButton.setRolloverIcon(SEARCH_ICON_HOVER);
        this.dropdownButton.setIcon(DROPDOWN_ICON);
        this.dropdownButton.setRolloverIcon(DROPDOWN_HOVER);
        this.dropdownButton.setSelectedIcon(DROPDOWN_FLIPPED_ICON);
        this.dropdownButton.setRolloverSelectedIcon(DROPDOWN_FLIPPED_HOVER);
        this.dropdownButton.setPreferredSize(new Dimension(35, 20));
        this.dropdownButton.setMaximumSize(new Dimension(35, 20));
        this.dropdownButton.setMinimumSize(new Dimension(35, 20));
        this.dropdownButton.setToolTipText("Opens Historical Info");
        SwingUtil.removeButtonDecorations((AbstractButton)this.dropdownButton);
        SwingUtil.removeButtonDecorations((AbstractButton)this.searchButton);
        this.dropdownButton.addActionListener(e -> {
            if (this.dropdownButton.isSelected()) {
                this.openCurrentHistoricalData();
            } else if (!this.dropdownButton.isSelected()) {
                this.closeCurrentHistoricalData();
            }
        });
        this.searchButton.addActionListener(e -> this.openBossLookupPanels());
        this.searchButton.setToolTipText("Open Boss Lookup");
        this.buttonIconTab.setLayout(new BorderLayout());
        this.buttonIconTab.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.buttonIconTab.setBorder(new MatteBorder(0, 0, 1, 0, new Color(37, 125, 141)));
        this.buttonIconTab.setOpaque(false);
        this.buttonIconTab.add((Component)this.dropdownButton, "West");
        this.buttonIconTab.add((Component)this.searchButton, "East");
        return this.buttonIconTab;
    }

    private JPanel buildPauseAndResumebuttons() {
        this.pauseAndResumeButtons.setLayout(new BorderLayout());
        this.pauseAndResumeButtons.setBorder(new EmptyBorder(4, 5, 0, 10));
        JPanel myButtons = new JPanel(new GridBagLayout());
        myButtons.setLayout(new GridLayout(1, 2, 5, 0));
        myButtons.setBorder(new EmptyBorder(5, 5, 0, 0));
        this.switchModeButton = new JButton("     Actual     ");
        this.switchModeButton.setToolTipText("Switches your information display mode");
        this.pauseResumeButton = new JButton("      Pause     ");
        this.pauseResumeButton.addActionListener(e -> {
            if (this.plugin.paused) {
                this.plugin.sessionResume();
            } else {
                this.plugin.sessionPause();
            }
        });
        this.switchModeButton.addActionListener(e -> {
            switch (this.plugin.getCalcMode()) {
                case 0: {
                    this.plugin.setCalcMode(1);
                    this.switchModeButton.setText("    Virtual     ");
                    this.plugin.calcKillsPerHour();
                    this.switchHistoricalInfo();
                    this.updateLookupInfo();
                    this.updateBossGoalsPanel();
                    break;
                }
                case 1: {
                    this.plugin.setCalcMode(0);
                    this.switchModeButton.setText("     Actual     ");
                    this.plugin.calcKillsPerHour();
                    this.switchHistoricalInfo();
                    this.updateLookupInfo();
                    this.updateBossGoalsPanel();
                }
            }
        });
        myButtons.add(this.pauseResumeButton);
        myButtons.add(this.switchModeButton);
        this.pauseAndResumeButtons.add((Component)myButtons, "West");
        return this.pauseAndResumeButtons;
    }

    public void switchHistoricalInfo() {
        if (this.plugin.sessionNpc != null) {
            this.fileRW.statConverter();
            this.setHistoricalInfo();
        }
    }

    public void discordLink() {
        try {
            Desktop.getDesktop().browse(new URI("https://discord.gg/ATXSsbbXQV"));
        }
        catch (IOException | URISyntaxException e1) {
            e1.printStackTrace();
        }
    }

    public void githubLink() {
        try {
            Desktop.getDesktop().browse(new URI("https://github.com/Mrnice98/KillsPerHour"));
        }
        catch (IOException | URISyntaxException e1) {
            e1.printStackTrace();
        }
    }

    private JPanel buildSessionEndButton() {
        this.sessionEndButton.setLayout(new BorderLayout());
        this.sessionEndButton.setBorder(new EmptyBorder(0, 5, 8, 10));
        this.sessionEndButton.setBorder(new MatteBorder(0, 0, 1, 0, new Color(37, 125, 141)));
        JPanel myButton = new JPanel(new GridBagLayout());
        myButton.setLayout(new GridLayout(1, 2, 5, 5));
        myButton.setBorder(new EmptyBorder(3, 10, 8, 0));
        JButton endButton = new JButton("                 End Session                  ");
        endButton.addActionListener(e -> this.plugin.sessionEnd());
        myButton.add(endButton);
        this.sessionEndButton.add((Component)myButton, "West");
        return this.sessionEndButton;
    }

    private JPanel buildSupportbuttons() {
        this.supportButtons.setLayout(new BorderLayout());
        this.supportButtons.setBorder(new EmptyBorder(4, 5, 0, 10));
        JPanel myButtons = new JPanel(new GridBagLayout());
        myButtons.setLayout(new GridLayout(1, 2, 8, 0));
        myButtons.setBorder(new EmptyBorder(10, 5, 0, 0));
        JButton discordButton = new JButton(DISCORD_ICON);
        JButton githubButton = new JButton(GITHUB_ICON);
        discordButton.setRolloverIcon(DISCORD_HOVER);
        githubButton.setRolloverIcon(GITHUB_HOVER);
        discordButton.setPreferredSize(new Dimension(23, 25));
        githubButton.setPreferredSize(new Dimension(20, 23));
        SwingUtil.removeButtonDecorations((AbstractButton)githubButton);
        SwingUtil.removeButtonDecorations((AbstractButton)discordButton);
        githubButton.addActionListener(e -> this.githubLink());
        discordButton.addActionListener(e -> this.discordLink());
        myButtons.add(githubButton);
        myButtons.add(discordButton);
        this.supportButtons.add((Component)myButtons, "East");
        return this.supportButtons;
    }

    public void setSessionTimeLabel() {
        SwingUtilities.invokeLater(() -> this.sessionTimeLabel.setText(KphPanel.htmlLabel("Session time: ", this.plugin.timeConverter(this.plugin.totalSessionTime))));
    }

    public void setSessionInfo() {
        if (this.plugin.sessionNpc != null) {
            this.killsPerHourLabel.setText(KphPanel.htmlLabel("KPH: ", this.plugin.formatKPH()));
            this.averageKillTimeLabel.setText(KphPanel.htmlLabel("Average Kill: ", this.plugin.avgKillTimeConverter()));
            this.totalBossKillsLabel.setText(KphPanel.htmlLabel("Kills: ", String.valueOf(this.plugin.killsThisSession)));
            this.idleTimeLabel.setText(KphPanel.htmlLabel("Idle Time: ", this.plugin.timeConverter(this.plugin.timeSpentIdle)));
            this.currentBossNameLabel.setText(this.plugin.sessionNpc);
            this.fastestKillTimeLabel.setText(KphPanel.htmlLabel("Fastest Kill: ", this.plugin.timeConverter(this.plugin.fastestKill)));
            if (!this.plugin.paused) {
                this.currentBossNameLabel.setForeground(new Color(71, 226, 12));
            }
        }
        if (this.plugin.sessionNpc == null && this.plugin.cacheHasInfo) {
            this.killsPerHourLabel.setText(KphPanel.htmlLabel("KPH: ", this.plugin.cachedKPH));
            this.averageKillTimeLabel.setText(KphPanel.htmlLabel("Average Kill: ", this.plugin.cachedAvgKillTime));
            this.totalBossKillsLabel.setText(KphPanel.htmlLabel("Kills: ", String.valueOf(this.plugin.cachedSessionKills)));
            this.idleTimeLabel.setText(KphPanel.htmlLabel("Idle Time: ", this.plugin.cachedIdleTime));
            this.currentBossNameLabel.setText(this.plugin.cachedSessionNpc);
            this.fastestKillTimeLabel.setText(KphPanel.htmlLabel("Fastest Kill: ", this.plugin.cachedFastestKill));
            this.currentBossNameLabel.setForeground(new Color(187, 187, 187));
        }
    }

    public void updateKphMethod() {
        this.killsPerHourLabel.setText("KPH: " + this.plugin.formatKPH());
    }

    public void setBossNameColor() {
        this.currentBossNameLabel.setForeground(new Color(227, 160, 27));
    }

    static String htmlLabel(String key, String valueStr) {
        return String.format(HTML_LABEL_TEMPLATE, ColorUtil.toHexColor((Color)ColorScheme.LIGHT_GRAY_COLOR), key, valueStr);
    }

    static {
        ITEM_SIZE = new Dimension(40, 40);
        BufferedImage trashPNG = ImageUtil.loadImageResource(KphPlugin.class, (String)"/trash_icon.png");
        BufferedImage closePNG = ImageUtil.loadImageResource(KphPlugin.class, (String)"/close_icon.png");
        BufferedImage searchPNG = ImageUtil.loadImageResource(KphPlugin.class, (String)"/search_icon.png");
        BufferedImage dropdownFlippedPNG = ImageUtil.loadImageResource(KphPlugin.class, (String)"/dropdown_flipped_icon.png");
        BufferedImage dropdownPNG = ImageUtil.loadImageResource(KphPlugin.class, (String)"/dropdown_icon.png");
        BufferedImage discordPNG = ImageUtil.loadImageResource(KphPlugin.class, (String)"/discord_icon.png");
        BufferedImage githubPNG = ImageUtil.loadImageResource(KphPlugin.class, (String)"/github_icon.png");
        BufferedImage visiblePNG = ImageUtil.loadImageResource(KphPlugin.class, (String)"/visible_icon.png");
        BufferedImage invisiblePNG = ImageUtil.loadImageResource(KphPlugin.class, (String)"/invisible_icon.png");
        VISIBLE_ICON = new ImageIcon(visiblePNG);
        INVISABLE_ICON = new ImageIcon(invisiblePNG);
        TRASH_ICON = new ImageIcon(trashPNG);
        TRASH_ICON_HOVER = new ImageIcon(ImageUtil.luminanceOffset((Image)trashPNG, (int)-80));
        CLOSE_ICON = new ImageIcon(closePNG);
        CLOSE_ICON_HOVER = new ImageIcon(ImageUtil.luminanceOffset((Image)closePNG, (int)-80));
        SEARCH_ICON = new ImageIcon(searchPNG);
        SEARCH_ICON_HOVER = new ImageIcon(ImageUtil.luminanceOffset((Image)searchPNG, (int)-80));
        DROPDOWN_FLIPPED_ICON = new ImageIcon(dropdownFlippedPNG);
        DROPDOWN_FLIPPED_HOVER = new ImageIcon(ImageUtil.luminanceOffset((Image)dropdownFlippedPNG, (int)-80));
        DROPDOWN_ICON = new ImageIcon(dropdownPNG);
        DROPDOWN_HOVER = new ImageIcon(ImageUtil.luminanceOffset((Image)dropdownPNG, (int)-80));
        DISCORD_ICON = new ImageIcon(discordPNG);
        DISCORD_HOVER = new ImageIcon(ImageUtil.luminanceOffset((Image)discordPNG, (int)-80));
        GITHUB_ICON = new ImageIcon(githubPNG);
        GITHUB_HOVER = new ImageIcon(ImageUtil.luminanceOffset((Image)githubPNG, (int)-80));
    }
}

