/*
 * Decompiled with CFR 0.152.
 */
package com.killsperhour;

import com.killsperhour.KphConfig;
import com.killsperhour.KphPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

class KphOverlay
extends Overlay {
    private final Client client;
    private final KphConfig config;
    private final KphPlugin kphPlugin;
    private final PanelComponent panelComponent = new PanelComponent();

    @Inject
    private KphOverlay(Client client, KphConfig config, KphPlugin kphPlugin) {
        this.setPosition(OverlayPosition.ABOVE_CHATBOX_RIGHT);
        this.client = client;
        this.config = config;
        this.kphPlugin = kphPlugin;
    }

    public Dimension render(Graphics2D graphics) {
        this.panelComponent.getChildren().clear();
        String overlayTitle = this.kphPlugin.currentBoss;
        if (!this.kphPlugin.paused) {
            this.panelComponent.getChildren().add(TitleComponent.builder().text(overlayTitle).color(Color.GREEN).build());
        } else {
            this.panelComponent.getChildren().add(TitleComponent.builder().text(overlayTitle).color(new Color(227, 160, 27)).build());
        }
        this.panelComponent.setPreferredSize(new Dimension(150, 0));
        this.panelComponent.getChildren().add(LineComponent.builder().left("KPH:").right(this.kphPlugin.formatKPH()).build());
        if (this.config.killsThisSession()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Kills:").right(Integer.toString(this.kphPlugin.killsThisSession)).build());
        }
        if (this.config.averageKillTime()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Average Kill:").right(this.kphPlugin.avgKillTimeConverter()).build());
        }
        if (this.config.fastestKill()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Fastest Kill:").right(this.kphPlugin.timeConverter(this.kphPlugin.fastestKill)).build());
        }
        if (this.config.displayIdleTime()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Idle Time:").right(this.kphPlugin.timeConverter(this.kphPlugin.timeSpentIdle)).build());
        }
        if (this.config.displayTotalTime()) {
            if (!this.kphPlugin.paused && this.kphPlugin.sessionNpc != null) {
                this.kphPlugin.totalSessionTimer();
            }
            this.panelComponent.getChildren().add(LineComponent.builder().left("Session Time:").right(this.kphPlugin.timeConverter(this.kphPlugin.totalSessionTime)).build());
        }
        if (this.kphPlugin.killsThisSession >= 1 && this.config.enableOverlay() && this.kphPlugin.sessionNpc != null) {
            return this.panelComponent.render(graphics);
        }
        return null;
    }
}

