/*
 * Decompiled with CFR 0.152.
 */
package com.killsperhour;

import com.killsperhour.KphConfig;
import com.killsperhour.KphPlugin;
import java.awt.Color;
import java.awt.image.BufferedImage;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.infobox.InfoBox;

class KphInfobox
extends InfoBox {
    private final KphConfig config;
    private final KphPlugin plugin;
    private final BufferedImage image;
    private final OverlayPosition position;
    private String Kph;

    KphInfobox(BufferedImage image, KphPlugin plugin, KphConfig config, OverlayPosition position) {
        super(image, (Plugin)plugin);
        this.image = image;
        this.plugin = plugin;
        this.config = config;
        this.position = position;
    }

    public String getText() {
        return this.plugin.formatKPH();
    }

    public Color getTextColor() {
        return Color.WHITE;
    }

    public String getTooltip() {
        StringBuilder toolTip = new StringBuilder();
        toolTip.append(this.plugin.sessionNpc);
        toolTip.append("</br>KPH: ");
        toolTip.append(this.plugin.formatKPH());
        if (this.config.averageKillTime()) {
            toolTip.append("</br>Kills: ");
            toolTip.append(this.plugin.killsThisSession);
        }
        if (this.config.averageKillTime()) {
            toolTip.append("</br>Avg Kill: ");
            toolTip.append(this.plugin.timeConverter(this.plugin.averageKillTime));
        }
        if (this.config.fastestKill()) {
            toolTip.append("</br>Fastest Kill: ");
            toolTip.append(this.plugin.timeConverter(this.plugin.fastestKill));
        }
        if (this.config.displayIdleTime()) {
            toolTip.append("</br>Idle time: ");
            toolTip.append(this.plugin.timeConverter(this.plugin.timeSpentIdle));
        }
        if (this.config.displayTotalTime()) {
            toolTip.append("</br>Session Time: ");
            toolTip.append(this.plugin.timeConverter(this.plugin.totalSessionTime));
        }
        return toolTip.toString();
    }

    public String toString() {
        return "KphInfobox(config=" + this.config + ", plugin=" + this.plugin + ", image=" + this.image + ", position=" + this.position + ", Kph=" + this.getKph() + ")";
    }

    public String getKph() {
        return this.Kph;
    }

    public void setKph(String Kph) {
        this.Kph = Kph;
    }
}

