/*
 * Decompiled with CFR 0.152.
 */
package com.killsperhour;

import com.killsperhour.FileReadWriter;
import com.killsperhour.KphBossInfo;
import com.killsperhour.KphConfig;
import com.killsperhour.KphPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.ComponentOrientation;
import net.runelite.client.ui.overlay.components.ImageComponent;
import net.runelite.client.ui.overlay.components.LayoutableRenderableEntity;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.components.ProgressBarComponent;
import net.runelite.client.ui.overlay.components.SplitComponent;

class KphBossGoalsOverlay
extends OverlayPanel {
    private final Client client;
    private final KphConfig config;
    private final KphPlugin plugin;
    private final FileReadWriter fileRW;
    private static final int BORDER_SIZE = 2;
    private static final int XP_AND_PROGRESS_BAR_GAP = 0;
    private static final int ICON_AND_INFO_GAP = 2;
    private static final Rectangle ICON_AND_INFO_COMPONENT_BORDER = new Rectangle(2, 1, 4, 0);
    private final PanelComponent iconAndInfoPanel = new PanelComponent();
    private final ItemManager itemManager;
    private LineComponent topLine;
    private LineComponent bottomLine;
    private SplitComponent splitLineComponent;
    private ImageComponent imageComponent;
    private SplitComponent iconComponentSplitter;
    private ProgressBarComponent progressBarComponent;
    int killsDone;
    int killsLeft;
    int totalKillsToGet;
    double percentDone;
    double TTG;
    String timeTillGoal;

    @Inject
    private KphBossGoalsOverlay(Client client, KphConfig config, KphPlugin plugin, ItemManager itemManager, FileReadWriter fileRW) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.client = client;
        this.config = config;
        this.plugin = plugin;
        this.itemManager = itemManager;
        this.fileRW = fileRW;
        this.panelComponent.setBorder(new Rectangle(2, 2, 2, 2));
        this.iconAndInfoPanel.setBorder(ICON_AND_INFO_COMPONENT_BORDER);
        this.iconAndInfoPanel.setBackgroundColor(null);
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Bossing info overlay"));
        this.createPanels();
    }

    public static BufferedImage resizeImage(BufferedImage image, int newWidth, int newHeight) {
        BufferedImage scaledImage = new BufferedImage(newWidth, newHeight, 2);
        Graphics2D g = scaledImage.createGraphics();
        g.drawImage(image, 0, 0, newWidth, newHeight, null);
        g.dispose();
        return scaledImage;
    }

    public void converter() {
        this.killsDone = this.plugin.killCount - this.fileRW.startKc;
        this.totalKillsToGet = this.fileRW.endKc - this.fileRW.startKc;
        this.killsLeft = this.totalKillsToGet - this.killsDone;
        this.TTG = (double)this.killsLeft / this.plugin.killsPerHour;
        this.percentDone = 100.0 * ((double)this.killsDone / (double)this.totalKillsToGet);
        this.timeTillGoal = this.plugin.timeConverter((int)(this.TTG * 3600.0));
    }

    private void createPanels() {
        String bottomRightNum;
        String bottomLeftStr;
        String rightNum;
        String leftStr;
        this.converter();
        boolean goalComplete = this.killsLeft <= 0;
        switch (this.config.topGoalOverlay()) {
            case TTG: {
                leftStr = "TTG:";
                if (goalComplete) {
                    rightNum = "00:00:00";
                    break;
                }
                rightNum = this.timeTillGoal;
                break;
            }
            case KILLS_DONE: {
                leftStr = "Kills Done:";
                if (goalComplete) {
                    rightNum = String.valueOf(this.totalKillsToGet);
                    break;
                }
                rightNum = String.valueOf(this.killsDone);
                break;
            }
            case KILLS_LEFT: {
                leftStr = "Kills Left:";
                if (goalComplete) {
                    rightNum = "0";
                    break;
                }
                rightNum = String.valueOf(this.killsLeft);
                break;
            }
            default: {
                leftStr = "KPH:";
                rightNum = String.valueOf(this.plugin.formatKPH());
            }
        }
        switch (this.config.bottomGoalOverlay()) {
            case KPH: {
                bottomLeftStr = "KPH:";
                bottomRightNum = String.valueOf(this.plugin.formatKPH());
                break;
            }
            case TTG: {
                bottomLeftStr = "TTG:";
                if (goalComplete) {
                    bottomRightNum = "00:00:00";
                    break;
                }
                bottomRightNum = this.timeTillGoal;
                break;
            }
            case KILLS_DONE: {
                bottomLeftStr = "Kills Done:";
                if (goalComplete) {
                    bottomRightNum = String.valueOf(this.totalKillsToGet);
                    break;
                }
                bottomRightNum = String.valueOf(this.killsDone);
                break;
            }
            default: {
                bottomLeftStr = "Kills Left:";
                bottomRightNum = goalComplete ? "0" : String.valueOf(this.killsLeft);
            }
        }
        this.topLine = LineComponent.builder().left(leftStr).right(rightNum).build();
        this.bottomLine = LineComponent.builder().left(bottomLeftStr).right(bottomRightNum).build();
        this.splitLineComponent = SplitComponent.builder().first((LayoutableRenderableEntity)this.topLine).second((LayoutableRenderableEntity)this.bottomLine).orientation(ComponentOrientation.VERTICAL).build();
        KphBossInfo kphBossInfo = KphBossInfo.find(this.plugin.sessionNpc);
        this.imageComponent = kphBossInfo != null ? new ImageComponent(KphBossGoalsOverlay.resizeImage((BufferedImage)this.itemManager.getImage(kphBossInfo.getIcon()), 32, 28)) : new ImageComponent(KphBossGoalsOverlay.resizeImage((BufferedImage)this.itemManager.getImage(1965), 32, 28));
        this.iconComponentSplitter = SplitComponent.builder().first((LayoutableRenderableEntity)this.imageComponent).second((LayoutableRenderableEntity)this.splitLineComponent).orientation(ComponentOrientation.HORIZONTAL).gap(new Point(2, 0)).build();
        this.iconAndInfoPanel.getChildren().add(this.iconComponentSplitter);
        this.progressBarComponent = new ProgressBarComponent();
        this.progressBarComponent.setBackgroundColor(new Color(61, 56, 49));
        if (this.plugin.paused) {
            this.progressBarComponent.setLabelDisplayMode(ProgressBarComponent.LabelDisplayMode.TEXT_ONLY);
            this.progressBarComponent.setCenterLabel("Paused");
            this.progressBarComponent.setForegroundColor(new Color(173, 128, 29));
        } else {
            this.progressBarComponent.setLabelDisplayMode(ProgressBarComponent.LabelDisplayMode.PERCENTAGE);
            this.progressBarComponent.setForegroundColor(new Color(91, 154, 47));
        }
        if (this.config.displayRelativeKills()) {
            this.progressBarComponent.setLeftLabel(String.valueOf(0));
            this.progressBarComponent.setRightLabel(String.valueOf(this.totalKillsToGet));
        } else {
            this.progressBarComponent.setLeftLabel(String.valueOf(this.fileRW.startKc));
            this.progressBarComponent.setRightLabel(String.valueOf(this.fileRW.endKc));
        }
        if (goalComplete) {
            this.progressBarComponent.setValue(100.0);
            this.progressBarComponent.setLabelDisplayMode(ProgressBarComponent.LabelDisplayMode.TEXT_ONLY);
            if (this.plugin.paused) {
                this.progressBarComponent.setCenterLabel("Paused");
            } else {
                this.progressBarComponent.setCenterLabel("Completed");
            }
        } else {
            if (!this.plugin.paused) {
                this.progressBarComponent.setLabelDisplayMode(ProgressBarComponent.LabelDisplayMode.PERCENTAGE);
            }
            this.progressBarComponent.setValue(this.percentDone);
        }
    }

    public Dimension render(Graphics2D graphics) {
        if (this.plugin.killsThisSession == 0 || this.fileRW.startKc == 0 && this.fileRW.endKc == 0 || !this.config.displayBossGoalsOverlay()) {
            return null;
        }
        this.iconAndInfoPanel.getChildren().clear();
        this.createPanels();
        graphics.setFont(FontManager.getRunescapeSmallFont());
        this.panelComponent.getChildren().add(this.iconAndInfoPanel);
        this.panelComponent.getChildren().add(this.progressBarComponent);
        return super.render(graphics);
    }
}

