/*
 * Decompiled with CFR 0.152.
 */
package com.killsperhour;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.killsperhour.KphBossGoalsOverlay;
import com.killsperhour.KphBossInfo;
import com.killsperhour.KphPlugin;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.client.RuneLite;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.ItemManager;

@Singleton
public class FileReadWriter {
    KphPlugin plugin;
    Client client;
    KphBossGoalsOverlay goalsOverlay;
    @Inject
    ItemManager itemManager;
    @Inject
    private ClientThread clientThread;
    @Inject
    private Gson gson;
    File file;
    String boss;
    String fileName;
    Path path;
    Path lookupPath;
    int oldTotalTime;
    int oldTotalKills;
    int timeOffset;
    int newTotalTimeActual;
    int virtualTimeOffset;
    int oldTotalVirtualTime;
    int newTotalVirtualTime;
    int oldFastestKill;
    int newFastestKill;
    int lastKillTimeActual;
    int lastKillTimeVirtual;
    int newTotalKills;
    String filename;
    int fetchedTotalTimeActual;
    int fetchedTotalTimeVirtual;
    int fetchedTotalTrackedKills;
    int fetchedFastestKill;
    int fetchedTotalBossKc;
    double fetchedKillsPerHour;
    int fetchedAverageKillTime;
    int estimatedTimeSpentBossing;
    File fetchedFile;
    Map<Integer, Integer> drops = new HashMap<Integer, Integer>();
    Map<Integer, Integer> allItemDrops = new HashMap<Integer, Integer>();
    Map<Integer, Integer> fetchedAllItemDrops = new HashMap<Integer, Integer>();
    Map<Integer, Integer> sessionItemDrops = new HashMap<Integer, Integer>();
    Map<Integer, Integer> cachedItemDrops = new HashMap<Integer, Integer>();
    File lootDirectory;
    File subDirectory;
    File ignoreDirectory;
    boolean bossNameMatch;
    HashMap<Integer, Double> itemAndTotalPrice;
    double totalGp = 0.0;
    ArrayList<Integer> ignored;
    int lootKillsTracked;
    int totalBossKc;
    int startKc;
    int endKc;
    List<String> list;
    int averageKillTime;
    double killsPerHour;
    int virtualAverageKillTime;
    double virtualKillsPerHour;
    int overallTime;

    @Inject
    private FileReadWriter(KphPlugin plugin, Client client) {
        this.plugin = plugin;
        this.client = client;
    }

    public void createAndUpdate() {
        this.createDirectory();
        this.createFileForBoss();
        this.replaceAndUpdate();
        this.statConverter();
    }

    public int idNormalizer(int itemId) {
        switch (this.itemManager.getItemComposition(itemId).getName()) {
            case "Clue Scroll (beginner)": {
                return 23182;
            }
            case "Clue Scroll (easy)": {
                return 2677;
            }
            case "Clue scroll (medium)": {
                return 2801;
            }
            case "Clue scroll (hard)": {
                return 2722;
            }
            case "Clue scroll (elite)": {
                return 12073;
            }
            case "Clue scroll (master)": {
                return 19835;
            }
        }
        return itemId;
    }

    public void buildLootMaps(List<Integer> itemIds, List<Integer> itemQuants, Map<Integer, Integer> lootMap) {
        for (int i = 0; i < itemIds.size(); ++i) {
            int itemId = this.idNormalizer(itemIds.get(i));
            this.drops.put(itemId, itemQuants.get(i));
            if (lootMap.containsKey(itemId)) {
                int quantity = lootMap.get(itemId);
                lootMap.replace(itemId, quantity += this.drops.get(itemId).intValue());
            } else {
                lootMap.putAll(this.drops);
            }
            this.drops.clear();
        }
    }

    public void bossNameMatcher() {
        if (this.plugin.bossName.equals(this.plugin.currentBoss)) {
            this.bossNameMatch = true;
        } else if ("Theatre of Blood HM".equals(this.plugin.currentBoss) && "Theatre of Blood".equals(this.plugin.bossName)) {
            this.bossNameMatch = true;
        } else if ("TOA Expert".equals(this.plugin.currentBoss) && "Tombs of Amascut".equals(this.plugin.bossName)) {
            this.bossNameMatch = true;
        } else if ("TOA Normal".equals(this.plugin.currentBoss) && "Tombs of Amascut".equals(this.plugin.bossName)) {
            this.bossNameMatch = true;
        } else if ("CM Chambers".equals(this.plugin.currentBoss) && "Chambers of Xeric".equals(this.plugin.bossName)) {
            this.bossNameMatch = true;
        } else if ("Corrupted Gauntlet".equals(this.plugin.currentBoss) && "The Gauntlet".equals(this.plugin.bossName)) {
            this.bossNameMatch = true;
        } else if ("Dagannoth Kings".equals(this.plugin.currentBoss) && ("Dagannoth Rex".equals(this.plugin.bossName) || "Dagannoth Prime".equals(this.plugin.bossName) || "Dagannoth Supreme".equals(this.plugin.bossName))) {
            this.bossNameMatch = true;
        } else if (KphBossInfo.bossByWordsLoot.containsKey(this.plugin.bossName)) {
            this.plugin.bossName = KphBossInfo.bossByWordsLoot.get(this.plugin.bossName);
            if (this.plugin.bossName.equals(this.plugin.currentBoss)) {
                this.bossNameMatch = true;
            }
        } else {
            this.bossNameMatch = false;
        }
    }

    public void lootReceived() {
        this.lootDirectory = new File(this.file, "boss-loot");
        this.subDirectory = new File(this.lootDirectory, this.plugin.currentBoss + ".json");
        this.bossNameMatcher();
        if (!this.bossNameMatch) {
            return;
        }
        this.loadDropsFromMap();
        if (!this.plugin.getPanel().fetchedInfoPanel.isShowing()) {
            this.loadIgnoredList(this.plugin.currentBoss);
        }
        List<Integer> id = this.plugin.itemStacks.stream().map(itemStack -> itemStack.getId()).collect(Collectors.toList());
        List<Integer> quant = this.plugin.itemStacks.stream().map(itemStack -> itemStack.getQuantity()).collect(Collectors.toList());
        this.buildLootMaps(id, quant, this.allItemDrops);
        this.buildLootMaps(id, quant, this.sessionItemDrops);
        this.writeDropsToMap();
        this.itemAndTotalPrice = new HashMap();
        if (this.plugin.getPanel().fetchedInfoPanel.isShowing()) {
            return;
        }
        this.plugin.getPanel().updateLootGrid(this.plugin.getPanel().lootDisplayMap());
    }

    public void getTotalPrice() {
        double totalGpLast = this.totalGp;
        for (Integer entry : this.itemAndTotalPrice.keySet()) {
            if (this.ignored != null && this.ignored.contains(entry) && !this.plugin.getPanel().hideItemButton.isSelected()) continue;
            this.totalGp += this.itemAndTotalPrice.get(entry).doubleValue();
        }
        this.itemAndTotalPrice.clear();
        this.totalGp -= totalGpLast;
    }

    public void loadFetchedDropsFromMap() {
        block4: {
            try {
                Type IntegerMap = new TypeToken<Map<Integer, Integer>>(){}.getType();
                this.fetchedAllItemDrops = (Map)this.gson.fromJson((Reader)new FileReader(this.subDirectory), IntegerMap);
            }
            catch (FileNotFoundException e) {
                this.fetchedAllItemDrops = new HashMap<Integer, Integer>();
                if (this.plugin.getPanel().fetchedInfoPanel.isShowing()) break block4;
                try {
                    this.lootDirectory.mkdirs();
                    this.subDirectory.createNewFile();
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public void loadDropsFromMap() {
        try {
            Type IntegerMap = new TypeToken<Map<Integer, Integer>>(){}.getType();
            this.allItemDrops = (Map)this.gson.fromJson((Reader)new FileReader(this.subDirectory), IntegerMap);
        }
        catch (FileNotFoundException e) {
            try {
                this.lootDirectory.mkdirs();
                this.subDirectory.createNewFile();
                this.allItemDrops = new HashMap<Integer, Integer>();
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
    }

    public void loadIgnoredList(String bossName) {
        block4: {
            try {
                Type IntegerList = new TypeToken<ArrayList<Integer>>(){}.getType();
                this.ignoreDirectory = new File(this.lootDirectory, bossName + "-ignored.json");
                this.ignored = (ArrayList)this.gson.fromJson((Reader)new FileReader(this.ignoreDirectory), IntegerList);
            }
            catch (FileNotFoundException e) {
                this.ignored = new ArrayList();
                if (this.plugin.getPanel().fetchedInfoPanel.isShowing()) break block4;
                try {
                    this.ignoreDirectory.createNewFile();
                    this.writeIgnoredListToFile(this.plugin.currentBoss);
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public void writeDropsToMap() {
        try {
            FileWriter writer = new FileWriter(this.subDirectory);
            this.gson.toJson(this.allItemDrops, (Appendable)writer);
            ((Writer)writer).close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void writeIgnoredListToFile(String bossName) {
        try {
            this.ignoreDirectory = new File(this.lootDirectory, bossName + "-ignored.json");
            FileWriter writer = new FileWriter(this.ignoreDirectory);
            this.gson.toJson(this.ignored, (Appendable)writer);
            ((Writer)writer).close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public HashMap<Integer, Integer> sortByValue(HashMap<Integer, Double> hm, Map<Integer, Integer> lootMap) {
        LinkedList<Map.Entry<Integer, Double>> list = new LinkedList<Map.Entry<Integer, Double>>(hm.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<Integer, Double>>(){

            @Override
            public int compare(Map.Entry<Integer, Double> o1, Map.Entry<Integer, Double> o2) {
                return o2.getValue().compareTo(o1.getValue());
            }
        });
        LinkedHashMap<Integer, Integer> sorted = new LinkedHashMap<Integer, Integer>();
        for (Map.Entry entry : list) {
            sorted.put((Integer)entry.getKey(), lootMap.get(entry.getKey()));
        }
        return sorted;
    }

    public void fetchLookupInfo() {
        File mainFolder = new File(RuneLite.RUNELITE_DIR, "bossing-info");
        this.file = new File(mainFolder, this.client.getUsername());
        if (this.file.exists() && this.client.getUsername() != null) {
            this.file.renameTo(new File(mainFolder, String.valueOf(this.client.getAccountHash())));
            this.file = new File(mainFolder, String.valueOf(this.client.getAccountHash()));
        } else {
            this.file = new File(mainFolder, String.valueOf(this.client.getAccountHash()));
            if (!this.file.exists()) {
                this.file.mkdirs();
            }
        }
        this.filename = this.filename + ".txt";
        this.lookupPath = Paths.get(this.file.getPath(), this.filename);
        this.fetchedFile = new File(String.valueOf(this.lookupPath));
        if (!this.fetchedFile.exists()) {
            return;
        }
        try {
            List<String> list = Files.readAllLines(this.lookupPath);
            list.forEach(line -> list.toArray());
            this.fetchedTotalTimeActual = Integer.parseInt(list.get(0).replaceAll("[^0-9]", ""));
            this.fetchedTotalTimeVirtual = Integer.parseInt(list.get(1).replaceAll("[^0-9]", ""));
            this.fetchedTotalTrackedKills = Integer.parseInt(list.get(2).replaceAll("[^0-9]", ""));
            this.fetchedFastestKill = Integer.parseInt(list.get(3).replaceAll("[^0-9]", ""));
            this.fetchedTotalBossKc = Integer.parseInt(list.get(4).replaceAll("[^0-9]", ""));
            if (list.size() == 8) {
                this.lootKillsTracked = Integer.parseInt(list.get(7).replaceAll("[^0-9]", ""));
            }
            this.fetchedStatConverter();
        }
        catch (IOException e) {
            e.getCause();
        }
    }

    public void getCurrentBossKCGoal() {
        try {
            List<String> list = Files.readAllLines(this.path);
            list.forEach(line -> list.toArray());
            int totalBossKc = Integer.parseInt(list.get(4).replaceAll("[^0-9]", ""));
            this.startKc = Integer.parseInt(list.get(5).replaceAll("[^0-9]", ""));
            this.endKc = Integer.parseInt(list.get(6).replaceAll("[^0-9]", ""));
            this.plugin.getPanel().startKcModel.setMaximum(Integer.valueOf(totalBossKc));
            this.plugin.getPanel().startKcModel.setValue(totalBossKc);
            this.plugin.getPanel().endKcModel.setMinimum(Integer.valueOf(totalBossKc));
            this.plugin.getPanel().endKcModel.setValue(totalBossKc);
            this.plugin.getPanel().endKcModel.setStepSize(5);
        }
        catch (IOException e) {
            e.getCause();
        }
    }

    public void updateBossKCGoal() {
        try {
            List<String> list = Files.readAllLines(this.path);
            list.forEach(line -> list.toArray());
            this.startKc = this.plugin.getPanel().startKC;
            this.endKc = this.plugin.getPanel().endKC;
            list.set(5, this.plugin.getPanel().startKC + " Start Kc");
            list.set(6, this.plugin.getPanel().endKC + " End Kc");
            Files.delete(this.path);
            Files.write(this.path, list, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            e.getCause();
        }
    }

    public void resetBossGoal() {
        try {
            List<String> list = Files.readAllLines(this.path);
            list.forEach(line -> list.toArray());
            list.set(5, "0 Start Kc");
            list.set(6, "0 End Kc");
            this.startKc = 0;
            this.endKc = 0;
            Files.delete(this.path);
            Files.write(this.path, list, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            this.plugin.getPanel().updateBossGoalsPanel();
        }
        catch (IOException e) {
            e.getCause();
        }
    }

    public void createDirectory() {
        File mainFolder = new File(RuneLite.RUNELITE_DIR, "bossing-info");
        this.file = new File(mainFolder, this.client.getUsername());
        if (this.file.exists() && this.client.getUsername() != null) {
            this.file.renameTo(new File(mainFolder, String.valueOf(this.client.getAccountHash())));
            this.file = new File(mainFolder, String.valueOf(this.client.getAccountHash()));
        } else {
            this.file = new File(mainFolder, String.valueOf(this.client.getAccountHash()));
            if (!this.file.exists()) {
                this.file.mkdirs();
            }
        }
    }

    public void resetStartAndEndKc() {
        this.startKc = 0;
        this.endKc = 0;
    }

    public void populateNewDataFields() {
        try {
            StringBuilder contentBuilder = new StringBuilder();
            if (this.list.size() < 7) {
                contentBuilder.append(0);
                contentBuilder.append(" Start Kc\n");
                contentBuilder.append(0);
                contentBuilder.append(" End Kc\n");
            }
            contentBuilder.append(0);
            contentBuilder.append(" Loot Kills Tracked\n");
            String content = contentBuilder.toString();
            Files.write(this.path, content.getBytes(), StandardOpenOption.APPEND);
            this.list = Files.readAllLines(this.path);
            this.list.forEach(line -> this.list.toArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void createFileForBoss() {
        this.boss = this.plugin.currentBoss;
        this.fileName = this.boss + ".txt";
        this.path = Paths.get(this.file.getPath(), this.fileName);
        try {
            this.list = Files.readAllLines(this.path);
            this.list.forEach(line -> this.list.toArray());
            if (this.list.size() < 8) {
                this.populateNewDataFields();
            }
            this.oldTotalTime = Integer.parseInt(this.list.get(0).replaceAll("[^0-9]", ""));
            this.oldTotalVirtualTime = Integer.parseInt(this.list.get(1).replaceAll("[^0-9]", ""));
            this.oldTotalKills = Integer.parseInt(this.list.get(2).replaceAll("[^0-9]", ""));
            this.oldFastestKill = Integer.parseInt(this.list.get(3).replaceAll("[^0-9]", ""));
            this.totalBossKc = Integer.parseInt(this.list.get(4).replaceAll("[^0-9]", ""));
            this.startKc = Integer.parseInt(this.list.get(5).replaceAll("[^0-9]", ""));
            this.endKc = Integer.parseInt(this.list.get(6).replaceAll("[^0-9]", ""));
            this.lootKillsTracked = Integer.parseInt(this.list.get(7).replaceAll("[^0-9]", ""));
        }
        catch (IOException e) {
            try {
                StringBuilder contentBuilder = new StringBuilder();
                contentBuilder.append(this.plugin.totalTime);
                contentBuilder.append(" Total Time Actual\n");
                contentBuilder.append(this.plugin.totalTime);
                contentBuilder.append(" Total Time Virtual\n");
                contentBuilder.append(this.plugin.killsThisSession);
                contentBuilder.append(" Kills Tracked\n");
                contentBuilder.append(this.plugin.fastestKill);
                contentBuilder.append(" Fastest Kill\n");
                contentBuilder.append(this.plugin.killCount);
                contentBuilder.append(" Total Kc\n");
                contentBuilder.append(0);
                contentBuilder.append(" Start Kc\n");
                contentBuilder.append(0);
                contentBuilder.append(" End Kc\n");
                contentBuilder.append(1);
                contentBuilder.append(" Loot Kills Tracked\n");
                String content = contentBuilder.toString();
                Files.write(this.path, content.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
                this.nullValuesForFileCreation();
            }
            catch (IOException ioException) {
                ioException.getCause();
            }
        }
    }

    public void nullValuesForFileCreation() {
        this.boss = this.plugin.currentBoss;
        this.fileName = this.boss + ".txt";
        this.oldTotalTime = 0;
        this.oldTotalKills = 0;
        this.timeOffset = 0;
        this.newTotalTimeActual = 0;
        this.lastKillTimeActual = 0;
        this.virtualTimeOffset = 0;
        this.oldTotalVirtualTime = 0;
        this.newTotalVirtualTime = 0;
        this.virtualAverageKillTime = 0;
        this.virtualKillsPerHour = 0.0;
        this.oldFastestKill = 99999999;
        this.newFastestKill = 99999999;
        this.lastKillTimeVirtual = 0;
        this.lootKillsTracked = 0;
    }

    public void replaceAndUpdate() {
        if (this.plugin.isBossChatDisplay()) {
            if (this.plugin.killsThisSession == 1) {
                this.newTotalVirtualTime = this.oldTotalVirtualTime + this.plugin.totalBossKillTime;
                this.newTotalTimeActual = this.oldTotalTime + this.plugin.lastKillTotalTime_1;
            } else {
                this.virtualTimeOffset = this.plugin.totalBossKillTime - this.lastKillTimeVirtual;
                this.timeOffset = this.plugin.lastKillTotalTime_1 - this.lastKillTimeActual;
                this.newTotalTimeActual += this.timeOffset;
                this.newTotalVirtualTime += this.virtualTimeOffset;
            }
            this.newTotalKills = this.oldTotalKills + 1;
            this.lastKillTimeActual = this.plugin.lastKillTotalTime_1;
            this.lastKillTimeVirtual = this.plugin.totalBossKillTime;
        } else {
            if (this.plugin.killsThisSession == 1) {
                this.newTotalVirtualTime = this.oldTotalVirtualTime + this.plugin.totalKillTime;
                this.newTotalTimeActual = this.oldTotalTime + this.plugin.lastKillTotalTime_0;
            } else {
                this.virtualTimeOffset = this.plugin.totalKillTime - this.lastKillTimeVirtual;
                this.timeOffset = this.plugin.lastKillTotalTime_0 - this.lastKillTimeActual;
                this.newTotalTimeActual += this.timeOffset;
                this.newTotalVirtualTime += this.virtualTimeOffset;
            }
            this.newTotalKills = this.oldTotalKills + 1;
            this.lastKillTimeActual = this.plugin.lastKillTotalTime_0;
            this.lastKillTimeVirtual = this.plugin.totalKillTime;
        }
        this.newFastestKill = this.plugin.fastestKill < this.oldFastestKill && this.oldFastestKill != 0 ? this.plugin.fastestKill : this.oldFastestKill;
        ++this.lootKillsTracked;
        try {
            Files.delete(this.path);
            StringBuilder contentBuilder = new StringBuilder();
            contentBuilder.append(this.newTotalTimeActual);
            contentBuilder.append(" Total Time Actual\n");
            contentBuilder.append(this.newTotalVirtualTime);
            contentBuilder.append(" Total Time Virtual\n");
            contentBuilder.append(this.newTotalKills);
            contentBuilder.append(" Kills Tracked\n");
            contentBuilder.append(this.newFastestKill);
            contentBuilder.append(" Fastest Kill\n");
            contentBuilder.append(this.plugin.killCount);
            contentBuilder.append(" Total Kc\n");
            contentBuilder.append(this.startKc);
            contentBuilder.append(" Start Kc\n");
            contentBuilder.append(this.endKc);
            contentBuilder.append(" End Kc\n");
            contentBuilder.append(this.lootKillsTracked);
            contentBuilder.append(" Loot Kills Tracked\n");
            String content = contentBuilder.toString();
            Files.write(this.path, content.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void statConverter() {
        this.overallTime = this.plugin.calcMode == 0 ? this.newTotalTimeActual : this.newTotalVirtualTime;
        this.averageKillTime = this.overallTime / this.newTotalKills;
        if (this.averageKillTime == 0) {
            this.killsPerHour = 0.0;
        } else {
            this.virtualKillsPerHour = 3600.0 / (double)this.virtualAverageKillTime;
            this.killsPerHour = 3600.0 / (double)this.averageKillTime;
        }
        DecimalFormat df = new DecimalFormat("#.#");
        this.killsPerHour = Double.parseDouble(df.format(this.killsPerHour));
    }

    public void fetchedStatConverter() {
        int newTime = this.plugin.calcMode == 0 ? this.fetchedTotalTimeActual : this.fetchedTotalTimeVirtual;
        this.fetchedAverageKillTime = newTime / this.fetchedTotalTrackedKills;
        this.fetchedKillsPerHour = this.fetchedAverageKillTime == 0 ? 0.0 : 3600.0 / (double)this.fetchedAverageKillTime;
        DecimalFormat df = new DecimalFormat("#.#");
        this.fetchedKillsPerHour = Double.parseDouble(df.format(this.fetchedKillsPerHour));
        this.estimatedTimeSpentBossing = (int)((double)this.fetchedTotalBossKc / (this.fetchedKillsPerHour / 3600.0));
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }
}

