/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.plugin.ui.util;

import com.duckblade.osrs.dpscalc.plugin.ui.util.AutoCompletion;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CustomJComboBox<T>
extends JPanel {
    private static final int HEIGHT_WITH_TITLE = 40;
    private static final int HEIGHT_WITHOUT_TITLE = 25;
    private final JLabel titleLabel;
    private final JComboBox<String> comboBox;
    private List<T> items;
    private final Function<T, String> displayMapper;
    private boolean allowNull = true;
    private boolean nullLast = false;
    private String nullText = "";
    private int bottomPadding;
    private boolean callbackEnabled = true;
    private final List<Runnable> callbacks = new ArrayList<Runnable>();

    public CustomJComboBox(List<T> items, Function<T, String> displayMapper, String title) {
        this.displayMapper = displayMapper;
        this.setLayout(new BorderLayout());
        this.titleLabel = new JLabel();
        this.titleLabel.setVisible(false);
        this.add((Component)this.titleLabel, "North");
        this.setTitle(title);
        this.comboBox = new JComboBox();
        this.comboBox.setPrototypeDisplayValue("");
        this.comboBox.addActionListener(e -> {
            if (this.callbackEnabled) {
                this.invokeCallbacks();
            }
        });
        this.items = items;
        this.updateInternalComboBox();
        this.add(this.comboBox, "Center");
        this.updateSizes();
    }

    public void setTitle(String title) {
        if (title != null) {
            this.titleLabel.setText(title);
            this.titleLabel.setVisible(true);
        } else {
            this.titleLabel.setVisible(false);
        }
        this.updateSizes();
    }

    public void setItems(List<T> newItems) {
        if (newItems != this.items) {
            this.items = newItems;
            this.updateInternalComboBox();
        }
    }

    public void setAllowNull(boolean newValue) {
        if (this.allowNull != newValue) {
            this.allowNull = newValue;
            if (this.items.isEmpty()) {
                throw new IllegalStateException("Must provide non-empty items before disabling null");
            }
            this.updateInternalComboBox();
        }
    }

    public void setNullLast(boolean newValue) {
        if (this.nullLast != newValue) {
            this.nullLast = newValue;
            this.updateInternalComboBox();
        }
    }

    public void setNullText(String newValue) {
        String string = newValue = newValue == null ? "" : newValue;
        if (!newValue.equals(this.nullText)) {
            this.nullText = newValue;
            this.updateInternalComboBox();
        }
    }

    private void updateInternalComboBox() {
        this.callbackEnabled = false;
        this.comboBox.removeAllItems();
        if (this.allowNull && !this.nullLast) {
            this.comboBox.addItem(this.nullText);
        }
        this.items.stream().map(this.displayMapper).forEach(this.comboBox::addItem);
        if (this.allowNull && this.nullLast) {
            this.comboBox.addItem(this.nullText);
        }
        this.callbackEnabled = true;
    }

    public T getValue() {
        int nullIx;
        if (!this.allowNull) {
            return this.items.get(this.comboBox.getSelectedIndex());
        }
        int n = nullIx = this.nullLast ? this.items.size() : 0;
        if (this.comboBox.getSelectedIndex() == nullIx) {
            return null;
        }
        int nullOffset = this.nullLast ? 0 : 1;
        return this.items.get(this.comboBox.getSelectedIndex() - nullOffset);
    }

    public void setValue(T newValue) {
        this.callbackEnabled = false;
        if (newValue == null) {
            if (!this.allowNull) {
                this.callbackEnabled = true;
                throw new IllegalArgumentException(newValue + " does not exist in items");
            }
            int nullIx = this.nullLast ? this.items.size() : 0;
            this.comboBox.setSelectedIndex(nullIx);
        } else {
            int nullOffset = this.allowNull && !this.nullLast ? 1 : 0;
            this.comboBox.setSelectedIndex(this.items.indexOf(newValue) + nullOffset);
        }
        this.callbackEnabled = true;
    }

    public void addBottomPadding(int height) {
        this.bottomPadding = height;
        this.add(Box.createVerticalStrut(height), "South");
        this.updateSizes();
    }

    private void updateSizes() {
        int height = this.bottomPadding + (this.titleLabel.isVisible() ? 40 : 25);
        this.setMinimumSize(new Dimension(0, height));
        this.setMaximumSize(new Dimension(225, height));
    }

    public void addCallback(Runnable r) {
        this.callbacks.add(r);
    }

    protected void invokeCallbacks() {
        this.callbacks.forEach(Runnable::run);
    }

    public void enableAutocomplete() {
        AutoCompletion.enable(this.comboBox);
    }
}

