/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.plugin.ui.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.runelite.client.ui.ColorScheme;

public class CustomJCheckBox
extends JPanel {
    JCheckBox checkBox;
    JLabel label;
    private final List<Runnable> callbacks = new ArrayList<Runnable>();

    public CustomJCheckBox(String text) {
        this.setLayout(new BorderLayout());
        this.setMaximumSize(new Dimension(225, 25));
        this.checkBox = new JCheckBox();
        this.checkBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 3));
        this.checkBox.addActionListener(e -> this.invokeCallback());
        this.add((Component)this.checkBox, "West");
        this.label = new JLabel(text);
        this.label.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        this.add((Component)this.label, "Center");
        MouseAdapter clickListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (CustomJCheckBox.this.checkBox.isEnabled()) {
                    CustomJCheckBox.this.setValue(!CustomJCheckBox.this.getValue());
                    CustomJCheckBox.this.invokeCallback();
                }
            }
        };
        this.label.addMouseListener(clickListener);
        this.addMouseListener(clickListener);
    }

    private void invokeCallback() {
        this.callbacks.forEach(Runnable::run);
    }

    public boolean getValue() {
        return this.isVisible() && this.checkBox.isSelected();
    }

    public void setValue(boolean newValue) {
        this.checkBox.setSelected(newValue);
        this.invokeCallback();
    }

    public void setEditable(boolean editable) {
        this.checkBox.setEnabled(editable);
    }

    public void addCallback(Runnable r) {
        this.callbacks.add(r);
    }
}

