/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.plugin.ui.util;

import com.duckblade.osrs.dpscalc.calc.exceptions.DpsComputeException;
import com.duckblade.osrs.dpscalc.calc.exceptions.MissingInputException;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ComputeUtil {
    private static final Logger log = LoggerFactory.getLogger(ComputeUtil.class);

    public static void computeSilent(Runnable compute) {
        block2: {
            try {
                compute.run();
            }
            catch (DpsComputeException e) {
                if (e.getCause() instanceof MissingInputException) break block2;
                throw e;
            }
        }
    }

    public static <T> T tryCompute(Supplier<T> compute) {
        try {
            return compute.get();
        }
        catch (DpsComputeException e) {
            if (!(e.getCause() instanceof MissingInputException)) {
                throw e;
            }
            return null;
        }
    }

    private ComputeUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

