/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.plugin.ui.state.component;

import com.duckblade.osrs.dpscalc.plugin.ui.state.PanelState;
import com.duckblade.osrs.dpscalc.plugin.ui.state.PanelStateManager;
import com.duckblade.osrs.dpscalc.plugin.ui.state.StateBoundComponent;
import com.duckblade.osrs.dpscalc.plugin.ui.util.CustomJComboBox;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class StateBoundJComboBox<T>
extends CustomJComboBox<T>
implements StateBoundComponent {
    private final PanelStateManager manager;
    private final BiConsumer<PanelState, T> stateWriter;
    private final Function<PanelState, T> stateReader;

    public StateBoundJComboBox(List<T> items, Function<T, String> displayMapper, String title, PanelStateManager manager, BiConsumer<PanelState, T> stateWriter, Function<PanelState, T> stateReader) {
        super(items, displayMapper, title);
        this.manager = manager;
        this.stateWriter = stateWriter;
        this.stateReader = stateReader;
        this.addCallback(this::toState);
    }

    @Override
    public void setItems(List<T> newItems) {
        Object prev = this.getValue();
        super.setItems(newItems);
        if (!Objects.equals(prev, this.getValue())) {
            this.toState();
        }
    }

    @Override
    public void toState() {
        if (this.stateWriter != null) {
            this.stateWriter.accept(this.getState(), (PanelState)this.getValue());
        }
    }

    @Override
    public void fromState() {
        this.setValue(this.stateReader.apply(this.getState()));
    }

    @Override
    public PanelStateManager getManager() {
        return this.manager;
    }
}

