/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.plugin.ui.state;

import com.duckblade.osrs.dpscalc.plugin.ui.state.PanelInputSet;
import com.duckblade.osrs.dpscalc.plugin.ui.state.PanelState;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class PanelStateManager {
    private final List<PanelInputSet> sets;
    private PanelInputSet currentSet;
    private final List<Runnable> onSetChangedCallbacks = new ArrayList<Runnable>();

    @Inject
    public PanelStateManager() {
        this.sets = new ArrayList<PanelInputSet>();
        this.createNewSet("Set 1");
    }

    public void createNewSet(String name) {
        PanelInputSet newSet = PanelInputSet.builder().name(name).build();
        this.sets.add(newSet);
        this.selectSet(newSet);
    }

    public PanelInputSet currentSet() {
        return this.currentSet;
    }

    public PanelState currentState() {
        return this.currentSet.getState();
    }

    public List<PanelInputSet> getInputSets() {
        return ImmutableList.copyOf(this.sets);
    }

    public void selectSet(PanelInputSet set) {
        this.currentSet = this.sets.contains(set) ? set : null;
        this.invokeCallbacks();
    }

    public void deleteSet(PanelInputSet set) {
        this.sets.remove(set);
        if (this.sets.isEmpty()) {
            this.createNewSet("Set 1");
        } else {
            this.selectSet(this.sets.get(0));
        }
    }

    private void invokeCallbacks() {
        this.onSetChangedCallbacks.forEach(Runnable::run);
    }

    public void addOnSetChangedListener(Runnable r) {
        this.onSetChangedCallbacks.add(r);
    }

    public PanelInputSet getCurrentSet() {
        return this.currentSet;
    }
}

