/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.plugin.ui.state;

import com.duckblade.osrs.dpscalc.calc.model.AttackStyle;
import com.duckblade.osrs.dpscalc.calc.model.ComputeInput;
import com.duckblade.osrs.dpscalc.calc.model.DefenderAttributes;
import com.duckblade.osrs.dpscalc.calc.model.DefensiveBonuses;
import com.duckblade.osrs.dpscalc.calc.model.ItemStats;
import com.duckblade.osrs.dpscalc.calc.model.Prayer;
import com.duckblade.osrs.dpscalc.calc.model.Skills;
import com.duckblade.osrs.dpscalc.calc.model.Spell;
import com.duckblade.osrs.dpscalc.plugin.osdata.wiki.NpcData;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.Skill;

public class PanelState {
    private Map<Skill, Integer> attackerSkills = new HashMap<Skill, Integer>();
    private Map<Skill, Integer> attackerBoosts = new HashMap<Skill, Integer>();
    private Map<EquipmentInventorySlot, ItemStats> attackerItems = new HashMap<EquipmentInventorySlot, ItemStats>();
    private Set<Prayer> attackerPrayers = new HashSet<Prayer>();
    private AttackStyle attackStyle = null;
    private Spell spell = null;
    private ItemStats blowpipeDarts = null;
    private int attackerDistance = 1;
    private Map<Skill, Integer> defenderSkills = new HashMap<Skill, Integer>();
    private MutableDefensiveBonuses defenderBonuses = new MutableDefensiveBonuses();
    private MutableDefenderAttributes defenderAttributes = new MutableDefenderAttributes();
    private boolean onSlayerTask = false;
    private boolean usingChargeSpell = false;
    private boolean usingMarkOfDarkness = false;
    private boolean inWilderness = false;
    private int raidPartySize = 1;

    public void loadNpcData(NpcData npc) {
        if (npc == null) {
            this.defenderSkills = new HashMap<Skill, Integer>();
            this.defenderBonuses = new MutableDefensiveBonuses();
            this.defenderAttributes = new MutableDefenderAttributes();
        } else {
            this.defenderSkills = npc.getSkills() == null ? new HashMap<Skill, Integer>() : new HashMap<Skill, Integer>(npc.getSkills().getTotals());
            this.defenderBonuses = MutableDefensiveBonuses.fromImmutable(npc.getDefensiveBonuses());
            this.defenderAttributes = MutableDefenderAttributes.fromImmutable(npc.getAttributes());
        }
    }

    public ComputeInput toComputeInput() {
        return ComputeInput.builder().attackerSkills(Skills.builder().levels(new HashMap<Skill, Integer>(this.attackerSkills)).boosts(new HashMap<Skill, Integer>(this.attackerBoosts)).build()).attackerItems(new HashMap<EquipmentInventorySlot, ItemStats>(this.attackerItems)).attackerPrayers(new HashSet<Prayer>(this.attackerPrayers)).attackStyle(this.attackStyle.toBuilder().build()).spell(this.spell).blowpipeDarts(this.blowpipeDarts).attackerDistance(this.attackerDistance).defenderSkills(Skills.builder().levels(new HashMap<Skill, Integer>(this.defenderSkills)).build()).defenderBonuses(this.defenderBonuses.toImmutable()).defenderAttributes(this.defenderAttributes.toImmutable()).onSlayerTask(this.onSlayerTask).usingChargeSpell(this.usingChargeSpell).usingMarkOfDarkness(this.usingMarkOfDarkness).inWilderness(this.inWilderness).raidPartySize(this.raidPartySize).build();
    }

    public Map<Skill, Integer> getAttackerSkills() {
        return this.attackerSkills;
    }

    public Map<Skill, Integer> getAttackerBoosts() {
        return this.attackerBoosts;
    }

    public Map<EquipmentInventorySlot, ItemStats> getAttackerItems() {
        return this.attackerItems;
    }

    public Set<Prayer> getAttackerPrayers() {
        return this.attackerPrayers;
    }

    public AttackStyle getAttackStyle() {
        return this.attackStyle;
    }

    public Spell getSpell() {
        return this.spell;
    }

    public ItemStats getBlowpipeDarts() {
        return this.blowpipeDarts;
    }

    public int getAttackerDistance() {
        return this.attackerDistance;
    }

    public Map<Skill, Integer> getDefenderSkills() {
        return this.defenderSkills;
    }

    public MutableDefensiveBonuses getDefenderBonuses() {
        return this.defenderBonuses;
    }

    public MutableDefenderAttributes getDefenderAttributes() {
        return this.defenderAttributes;
    }

    public boolean isOnSlayerTask() {
        return this.onSlayerTask;
    }

    public boolean isUsingChargeSpell() {
        return this.usingChargeSpell;
    }

    public boolean isUsingMarkOfDarkness() {
        return this.usingMarkOfDarkness;
    }

    public boolean isInWilderness() {
        return this.inWilderness;
    }

    public int getRaidPartySize() {
        return this.raidPartySize;
    }

    public void setAttackerSkills(Map<Skill, Integer> attackerSkills) {
        this.attackerSkills = attackerSkills;
    }

    public void setAttackerBoosts(Map<Skill, Integer> attackerBoosts) {
        this.attackerBoosts = attackerBoosts;
    }

    public void setAttackerItems(Map<EquipmentInventorySlot, ItemStats> attackerItems) {
        this.attackerItems = attackerItems;
    }

    public void setAttackerPrayers(Set<Prayer> attackerPrayers) {
        this.attackerPrayers = attackerPrayers;
    }

    public void setAttackStyle(AttackStyle attackStyle) {
        this.attackStyle = attackStyle;
    }

    public void setSpell(Spell spell) {
        this.spell = spell;
    }

    public void setBlowpipeDarts(ItemStats blowpipeDarts) {
        this.blowpipeDarts = blowpipeDarts;
    }

    public void setAttackerDistance(int attackerDistance) {
        this.attackerDistance = attackerDistance;
    }

    public void setDefenderSkills(Map<Skill, Integer> defenderSkills) {
        this.defenderSkills = defenderSkills;
    }

    public void setDefenderBonuses(MutableDefensiveBonuses defenderBonuses) {
        this.defenderBonuses = defenderBonuses;
    }

    public void setDefenderAttributes(MutableDefenderAttributes defenderAttributes) {
        this.defenderAttributes = defenderAttributes;
    }

    public void setOnSlayerTask(boolean onSlayerTask) {
        this.onSlayerTask = onSlayerTask;
    }

    public void setUsingChargeSpell(boolean usingChargeSpell) {
        this.usingChargeSpell = usingChargeSpell;
    }

    public void setUsingMarkOfDarkness(boolean usingMarkOfDarkness) {
        this.usingMarkOfDarkness = usingMarkOfDarkness;
    }

    public void setInWilderness(boolean inWilderness) {
        this.inWilderness = inWilderness;
    }

    public void setRaidPartySize(int raidPartySize) {
        this.raidPartySize = raidPartySize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PanelState)) {
            return false;
        }
        PanelState other = (PanelState)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getAttackerDistance() != other.getAttackerDistance()) {
            return false;
        }
        if (this.isOnSlayerTask() != other.isOnSlayerTask()) {
            return false;
        }
        if (this.isUsingChargeSpell() != other.isUsingChargeSpell()) {
            return false;
        }
        if (this.isUsingMarkOfDarkness() != other.isUsingMarkOfDarkness()) {
            return false;
        }
        if (this.isInWilderness() != other.isInWilderness()) {
            return false;
        }
        if (this.getRaidPartySize() != other.getRaidPartySize()) {
            return false;
        }
        Map<Skill, Integer> this$attackerSkills = this.getAttackerSkills();
        Map<Skill, Integer> other$attackerSkills = other.getAttackerSkills();
        if (this$attackerSkills == null ? other$attackerSkills != null : !((Object)this$attackerSkills).equals(other$attackerSkills)) {
            return false;
        }
        Map<Skill, Integer> this$attackerBoosts = this.getAttackerBoosts();
        Map<Skill, Integer> other$attackerBoosts = other.getAttackerBoosts();
        if (this$attackerBoosts == null ? other$attackerBoosts != null : !((Object)this$attackerBoosts).equals(other$attackerBoosts)) {
            return false;
        }
        Map<EquipmentInventorySlot, ItemStats> this$attackerItems = this.getAttackerItems();
        Map<EquipmentInventorySlot, ItemStats> other$attackerItems = other.getAttackerItems();
        if (this$attackerItems == null ? other$attackerItems != null : !((Object)this$attackerItems).equals(other$attackerItems)) {
            return false;
        }
        Set<Prayer> this$attackerPrayers = this.getAttackerPrayers();
        Set<Prayer> other$attackerPrayers = other.getAttackerPrayers();
        if (this$attackerPrayers == null ? other$attackerPrayers != null : !((Object)this$attackerPrayers).equals(other$attackerPrayers)) {
            return false;
        }
        AttackStyle this$attackStyle = this.getAttackStyle();
        AttackStyle other$attackStyle = other.getAttackStyle();
        if (this$attackStyle == null ? other$attackStyle != null : !((Object)this$attackStyle).equals(other$attackStyle)) {
            return false;
        }
        Spell this$spell = this.getSpell();
        Spell other$spell = other.getSpell();
        if (this$spell == null ? other$spell != null : !((Object)((Object)this$spell)).equals((Object)other$spell)) {
            return false;
        }
        ItemStats this$blowpipeDarts = this.getBlowpipeDarts();
        ItemStats other$blowpipeDarts = other.getBlowpipeDarts();
        if (this$blowpipeDarts == null ? other$blowpipeDarts != null : !((Object)this$blowpipeDarts).equals(other$blowpipeDarts)) {
            return false;
        }
        Map<Skill, Integer> this$defenderSkills = this.getDefenderSkills();
        Map<Skill, Integer> other$defenderSkills = other.getDefenderSkills();
        if (this$defenderSkills == null ? other$defenderSkills != null : !((Object)this$defenderSkills).equals(other$defenderSkills)) {
            return false;
        }
        MutableDefensiveBonuses this$defenderBonuses = this.getDefenderBonuses();
        MutableDefensiveBonuses other$defenderBonuses = other.getDefenderBonuses();
        if (this$defenderBonuses == null ? other$defenderBonuses != null : !((Object)this$defenderBonuses).equals(other$defenderBonuses)) {
            return false;
        }
        MutableDefenderAttributes this$defenderAttributes = this.getDefenderAttributes();
        MutableDefenderAttributes other$defenderAttributes = other.getDefenderAttributes();
        return !(this$defenderAttributes == null ? other$defenderAttributes != null : !((Object)this$defenderAttributes).equals(other$defenderAttributes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PanelState;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getAttackerDistance();
        result = result * 59 + (this.isOnSlayerTask() ? 79 : 97);
        result = result * 59 + (this.isUsingChargeSpell() ? 79 : 97);
        result = result * 59 + (this.isUsingMarkOfDarkness() ? 79 : 97);
        result = result * 59 + (this.isInWilderness() ? 79 : 97);
        result = result * 59 + this.getRaidPartySize();
        Map<Skill, Integer> $attackerSkills = this.getAttackerSkills();
        result = result * 59 + ($attackerSkills == null ? 43 : ((Object)$attackerSkills).hashCode());
        Map<Skill, Integer> $attackerBoosts = this.getAttackerBoosts();
        result = result * 59 + ($attackerBoosts == null ? 43 : ((Object)$attackerBoosts).hashCode());
        Map<EquipmentInventorySlot, ItemStats> $attackerItems = this.getAttackerItems();
        result = result * 59 + ($attackerItems == null ? 43 : ((Object)$attackerItems).hashCode());
        Set<Prayer> $attackerPrayers = this.getAttackerPrayers();
        result = result * 59 + ($attackerPrayers == null ? 43 : ((Object)$attackerPrayers).hashCode());
        AttackStyle $attackStyle = this.getAttackStyle();
        result = result * 59 + ($attackStyle == null ? 43 : ((Object)$attackStyle).hashCode());
        Spell $spell = this.getSpell();
        result = result * 59 + ($spell == null ? 43 : ((Object)((Object)$spell)).hashCode());
        ItemStats $blowpipeDarts = this.getBlowpipeDarts();
        result = result * 59 + ($blowpipeDarts == null ? 43 : ((Object)$blowpipeDarts).hashCode());
        Map<Skill, Integer> $defenderSkills = this.getDefenderSkills();
        result = result * 59 + ($defenderSkills == null ? 43 : ((Object)$defenderSkills).hashCode());
        MutableDefensiveBonuses $defenderBonuses = this.getDefenderBonuses();
        result = result * 59 + ($defenderBonuses == null ? 43 : ((Object)$defenderBonuses).hashCode());
        MutableDefenderAttributes $defenderAttributes = this.getDefenderAttributes();
        result = result * 59 + ($defenderAttributes == null ? 43 : ((Object)$defenderAttributes).hashCode());
        return result;
    }

    public String toString() {
        return "PanelState(attackerSkills=" + this.getAttackerSkills() + ", attackerBoosts=" + this.getAttackerBoosts() + ", attackerItems=" + this.getAttackerItems() + ", attackerPrayers=" + this.getAttackerPrayers() + ", attackStyle=" + this.getAttackStyle() + ", spell=" + this.getSpell() + ", blowpipeDarts=" + this.getBlowpipeDarts() + ", attackerDistance=" + this.getAttackerDistance() + ", defenderSkills=" + this.getDefenderSkills() + ", defenderBonuses=" + this.getDefenderBonuses() + ", defenderAttributes=" + this.getDefenderAttributes() + ", onSlayerTask=" + this.isOnSlayerTask() + ", usingChargeSpell=" + this.isUsingChargeSpell() + ", usingMarkOfDarkness=" + this.isUsingMarkOfDarkness() + ", inWilderness=" + this.isInWilderness() + ", raidPartySize=" + this.getRaidPartySize() + ")";
    }

    public static class MutableDefenderAttributes {
        private int npcId = -1;
        private String name = null;
        private boolean isDemon = false;
        private boolean isDragon = false;
        private boolean isKalphite = false;
        private boolean isLeafy = false;
        private boolean isUndead = false;
        private boolean isVampyre1 = false;
        private boolean isVampyre2 = false;
        private boolean isVampyre3 = false;
        private int size = 1;
        private int accuracyMagic = 0;
        private int raidPartySize = 0;

        public DefenderAttributes toImmutable() {
            return DefenderAttributes.builder().npcId(this.npcId).name(this.name).isDemon(this.isDemon).isDragon(this.isDragon).isKalphite(this.isKalphite).isLeafy(this.isLeafy).isUndead(this.isUndead).isVampyre1(this.isVampyre1).isVampyre2(this.isVampyre2).isVampyre3(this.isVampyre3).size(this.size).accuracyMagic(this.accuracyMagic).build();
        }

        public static MutableDefenderAttributes fromImmutable(DefenderAttributes immutable) {
            MutableDefenderAttributes mda = new MutableDefenderAttributes();
            if (immutable != null) {
                mda.npcId = immutable.getNpcId();
                mda.name = immutable.getName();
                mda.isDemon = immutable.isDemon();
                mda.isDragon = immutable.isDragon();
                mda.isKalphite = immutable.isKalphite();
                mda.isLeafy = immutable.isLeafy();
                mda.isUndead = immutable.isUndead();
                mda.isVampyre1 = immutable.isVampyre1();
                mda.isVampyre2 = immutable.isVampyre2();
                mda.isVampyre3 = immutable.isVampyre3();
                mda.size = immutable.getSize();
                mda.accuracyMagic = immutable.getAccuracyMagic();
            }
            return mda;
        }

        public int getNpcId() {
            return this.npcId;
        }

        public String getName() {
            return this.name;
        }

        public boolean isDemon() {
            return this.isDemon;
        }

        public boolean isDragon() {
            return this.isDragon;
        }

        public boolean isKalphite() {
            return this.isKalphite;
        }

        public boolean isLeafy() {
            return this.isLeafy;
        }

        public boolean isUndead() {
            return this.isUndead;
        }

        public boolean isVampyre1() {
            return this.isVampyre1;
        }

        public boolean isVampyre2() {
            return this.isVampyre2;
        }

        public boolean isVampyre3() {
            return this.isVampyre3;
        }

        public int getSize() {
            return this.size;
        }

        public int getAccuracyMagic() {
            return this.accuracyMagic;
        }

        public int getRaidPartySize() {
            return this.raidPartySize;
        }

        public void setNpcId(int npcId) {
            this.npcId = npcId;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setDemon(boolean isDemon) {
            this.isDemon = isDemon;
        }

        public void setDragon(boolean isDragon) {
            this.isDragon = isDragon;
        }

        public void setKalphite(boolean isKalphite) {
            this.isKalphite = isKalphite;
        }

        public void setLeafy(boolean isLeafy) {
            this.isLeafy = isLeafy;
        }

        public void setUndead(boolean isUndead) {
            this.isUndead = isUndead;
        }

        public void setVampyre1(boolean isVampyre1) {
            this.isVampyre1 = isVampyre1;
        }

        public void setVampyre2(boolean isVampyre2) {
            this.isVampyre2 = isVampyre2;
        }

        public void setVampyre3(boolean isVampyre3) {
            this.isVampyre3 = isVampyre3;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public void setAccuracyMagic(int accuracyMagic) {
            this.accuracyMagic = accuracyMagic;
        }

        public void setRaidPartySize(int raidPartySize) {
            this.raidPartySize = raidPartySize;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MutableDefenderAttributes)) {
                return false;
            }
            MutableDefenderAttributes other = (MutableDefenderAttributes)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getNpcId() != other.getNpcId()) {
                return false;
            }
            if (this.isDemon() != other.isDemon()) {
                return false;
            }
            if (this.isDragon() != other.isDragon()) {
                return false;
            }
            if (this.isKalphite() != other.isKalphite()) {
                return false;
            }
            if (this.isLeafy() != other.isLeafy()) {
                return false;
            }
            if (this.isUndead() != other.isUndead()) {
                return false;
            }
            if (this.isVampyre1() != other.isVampyre1()) {
                return false;
            }
            if (this.isVampyre2() != other.isVampyre2()) {
                return false;
            }
            if (this.isVampyre3() != other.isVampyre3()) {
                return false;
            }
            if (this.getSize() != other.getSize()) {
                return false;
            }
            if (this.getAccuracyMagic() != other.getAccuracyMagic()) {
                return false;
            }
            if (this.getRaidPartySize() != other.getRaidPartySize()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MutableDefenderAttributes;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getNpcId();
            result = result * 59 + (this.isDemon() ? 79 : 97);
            result = result * 59 + (this.isDragon() ? 79 : 97);
            result = result * 59 + (this.isKalphite() ? 79 : 97);
            result = result * 59 + (this.isLeafy() ? 79 : 97);
            result = result * 59 + (this.isUndead() ? 79 : 97);
            result = result * 59 + (this.isVampyre1() ? 79 : 97);
            result = result * 59 + (this.isVampyre2() ? 79 : 97);
            result = result * 59 + (this.isVampyre3() ? 79 : 97);
            result = result * 59 + this.getSize();
            result = result * 59 + this.getAccuracyMagic();
            result = result * 59 + this.getRaidPartySize();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "PanelState.MutableDefenderAttributes(npcId=" + this.getNpcId() + ", name=" + this.getName() + ", isDemon=" + this.isDemon() + ", isDragon=" + this.isDragon() + ", isKalphite=" + this.isKalphite() + ", isLeafy=" + this.isLeafy() + ", isUndead=" + this.isUndead() + ", isVampyre1=" + this.isVampyre1() + ", isVampyre2=" + this.isVampyre2() + ", isVampyre3=" + this.isVampyre3() + ", size=" + this.getSize() + ", accuracyMagic=" + this.getAccuracyMagic() + ", raidPartySize=" + this.getRaidPartySize() + ")";
        }

        public MutableDefenderAttributes() {
        }

        public MutableDefenderAttributes(int npcId, String name, boolean isDemon, boolean isDragon, boolean isKalphite, boolean isLeafy, boolean isUndead, boolean isVampyre1, boolean isVampyre2, boolean isVampyre3, int size, int accuracyMagic, int raidPartySize) {
            this.npcId = npcId;
            this.name = name;
            this.isDemon = isDemon;
            this.isDragon = isDragon;
            this.isKalphite = isKalphite;
            this.isLeafy = isLeafy;
            this.isUndead = isUndead;
            this.isVampyre1 = isVampyre1;
            this.isVampyre2 = isVampyre2;
            this.isVampyre3 = isVampyre3;
            this.size = size;
            this.accuracyMagic = accuracyMagic;
            this.raidPartySize = raidPartySize;
        }
    }

    public static class MutableDefensiveBonuses {
        private int defenseStab = 0;
        private int defenseSlash = 0;
        private int defenseCrush = 0;
        private int defenseRanged = 0;
        private int defenseMagic = 0;

        public DefensiveBonuses toImmutable() {
            return DefensiveBonuses.builder().defenseStab(this.defenseStab).defenseSlash(this.defenseSlash).defenseCrush(this.defenseCrush).defenseRanged(this.defenseRanged).defenseMagic(this.defenseMagic).build();
        }

        public static MutableDefensiveBonuses fromImmutable(DefensiveBonuses immutable) {
            MutableDefensiveBonuses mbd = new MutableDefensiveBonuses();
            if (immutable != null) {
                mbd.defenseStab = immutable.getDefenseStab();
                mbd.defenseSlash = immutable.getDefenseSlash();
                mbd.defenseCrush = immutable.getDefenseCrush();
                mbd.defenseRanged = immutable.getDefenseRanged();
                mbd.defenseMagic = immutable.getDefenseMagic();
            }
            return mbd;
        }

        public int getDefenseStab() {
            return this.defenseStab;
        }

        public int getDefenseSlash() {
            return this.defenseSlash;
        }

        public int getDefenseCrush() {
            return this.defenseCrush;
        }

        public int getDefenseRanged() {
            return this.defenseRanged;
        }

        public int getDefenseMagic() {
            return this.defenseMagic;
        }

        public void setDefenseStab(int defenseStab) {
            this.defenseStab = defenseStab;
        }

        public void setDefenseSlash(int defenseSlash) {
            this.defenseSlash = defenseSlash;
        }

        public void setDefenseCrush(int defenseCrush) {
            this.defenseCrush = defenseCrush;
        }

        public void setDefenseRanged(int defenseRanged) {
            this.defenseRanged = defenseRanged;
        }

        public void setDefenseMagic(int defenseMagic) {
            this.defenseMagic = defenseMagic;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MutableDefensiveBonuses)) {
                return false;
            }
            MutableDefensiveBonuses other = (MutableDefensiveBonuses)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getDefenseStab() != other.getDefenseStab()) {
                return false;
            }
            if (this.getDefenseSlash() != other.getDefenseSlash()) {
                return false;
            }
            if (this.getDefenseCrush() != other.getDefenseCrush()) {
                return false;
            }
            if (this.getDefenseRanged() != other.getDefenseRanged()) {
                return false;
            }
            return this.getDefenseMagic() == other.getDefenseMagic();
        }

        protected boolean canEqual(Object other) {
            return other instanceof MutableDefensiveBonuses;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getDefenseStab();
            result = result * 59 + this.getDefenseSlash();
            result = result * 59 + this.getDefenseCrush();
            result = result * 59 + this.getDefenseRanged();
            result = result * 59 + this.getDefenseMagic();
            return result;
        }

        public String toString() {
            return "PanelState.MutableDefensiveBonuses(defenseStab=" + this.getDefenseStab() + ", defenseSlash=" + this.getDefenseSlash() + ", defenseCrush=" + this.getDefenseCrush() + ", defenseRanged=" + this.getDefenseRanged() + ", defenseMagic=" + this.getDefenseMagic() + ")";
        }
    }
}

