/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.plugin.ui.skills;

import com.duckblade.osrs.dpscalc.plugin.ui.skills.StatBox;
import java.awt.Dimension;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.runelite.client.ui.ColorScheme;

public class StatCategory
extends JPanel {
    private static JPanel buildSubPanel(List<? extends StatBox> elements) {
        JPanel subPanel = new JPanel();
        subPanel.setLayout(new BoxLayout(subPanel, 0));
        elements.forEach(subPanel::add);
        return subPanel;
    }

    public StatCategory(String title, List<? extends StatBox> innerStats) {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createLineBorder(ColorScheme.DARKER_GRAY_COLOR, 5));
        int rows = (int)Math.ceil((double)innerStats.size() / 3.0);
        this.setPreferredSize(new Dimension(200, 24 + 70 * rows));
        this.setMaximumSize(new Dimension(200, 24 + 70 * rows));
        JLabel titleLabel = new JLabel(title);
        titleLabel.setAlignmentX(0.5f);
        this.add(titleLabel);
        for (int i = 0; i < innerStats.size(); i += 3) {
            List<? extends StatBox> rowStats = innerStats.subList(i, Math.min(i + 3, innerStats.size()));
            JPanel rowPanel = StatCategory.buildSubPanel(rowStats);
            if (i + 3 < innerStats.size()) {
                rowPanel.setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 0));
            }
            this.add(rowPanel);
        }
    }
}

