/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.plugin.ui.skills;

import com.duckblade.osrs.dpscalc.plugin.ui.util.FocusLostAdapter;
import com.duckblade.osrs.dpscalc.plugin.ui.util.JTextFieldIntOnlyKeyAdapter;
import com.duckblade.osrs.dpscalc.plugin.ui.util.SelectAllFocusListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.runelite.client.util.ImageUtil;

public class StatBox
extends JPanel {
    private final JTextField valueField;
    private final List<Runnable> callbacks = new ArrayList<Runnable>();

    public StatBox(String iconName, String title, boolean editable) {
        BufferedImage icon;
        this.setLayout(new BoxLayout(this, 1));
        try {
            icon = ImageUtil.loadImageResource(StatBox.class, (String)("icon_" + iconName + ".png"));
            icon = ImageUtil.resizeCanvas((BufferedImage)icon, (int)25, (int)25);
        }
        catch (IllegalArgumentException e2) {
            icon = new BufferedImage(25, 25, 2);
        }
        JLabel iconLabel = new JLabel(new ImageIcon(icon));
        iconLabel.setAlignmentX(0.5f);
        this.add(iconLabel);
        JLabel titleLabel = new JLabel(title);
        titleLabel.setAlignmentX(0.5f);
        this.add(titleLabel);
        this.valueField = new JTextField("0", 3);
        this.valueField.setAlignmentX(0.5f);
        this.valueField.setHorizontalAlignment(0);
        this.valueField.addFocusListener(new SelectAllFocusListener(this.valueField));
        this.valueField.addKeyListener(new JTextFieldIntOnlyKeyAdapter());
        this.valueField.setEditable(editable);
        this.valueField.addFocusListener(new FocusLostAdapter(e -> this.callbacks.forEach(Runnable::run)));
        this.add(this.valueField);
    }

    public void setValue(int value) {
        SwingUtilities.invokeLater(() -> this.valueField.setText(Integer.toString(value)));
    }

    public int getValue() {
        if (this.valueField.getText().isEmpty()) {
            return 0;
        }
        return Integer.parseInt(this.valueField.getText());
    }

    public void setEditable(boolean editable) {
        this.valueField.setEditable(editable);
    }

    public void addCallback(Runnable r) {
        this.callbacks.add(r);
    }
}

