/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.dpscalc.plugin.ui.skills;

import com.duckblade.osrs.dpscalc.calc.model.Skills;
import com.duckblade.osrs.dpscalc.plugin.osdata.clientdata.ClientDataProviderThreadProxy;
import com.duckblade.osrs.dpscalc.plugin.ui.skills.SkillBoostPreset;
import com.duckblade.osrs.dpscalc.plugin.ui.skills.SkillBoostPresetButton;
import com.duckblade.osrs.dpscalc.plugin.ui.skills.StatCategory;
import com.duckblade.osrs.dpscalc.plugin.ui.state.PanelState;
import com.duckblade.osrs.dpscalc.plugin.ui.state.PanelStateManager;
import com.duckblade.osrs.dpscalc.plugin.ui.state.StateBoundComponent;
import com.duckblade.osrs.dpscalc.plugin.ui.state.component.StateBoundStatBox;
import com.duckblade.osrs.dpscalc.plugin.ui.util.CustomJComboBox;
import com.duckblade.osrs.dpscalc.plugin.ui.util.LoadFromClientButton;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.ObjIntConsumer;
import java.util.function.ToIntFunction;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.runelite.api.Skill;

@Singleton
public class SkillsPanel
extends JPanel
implements StateBoundComponent {
    private final PanelStateManager manager;
    private final ClientDataProviderThreadProxy clientDataProviderThreadProxy;
    private final List<StateBoundStatBox> statBoxes;
    private final List<StateBoundStatBox> boostBoxes;

    private static ObjIntConsumer<PanelState> writer(Function<PanelState, Map<Skill, Integer>> mapSelector, Skill skill) {
        return (state, lvl) -> ((Map)mapSelector.apply((PanelState)state)).put(skill, lvl);
    }

    private static ToIntFunction<PanelState> reader(Function<PanelState, Map<Skill, Integer>> mapSelector, Skill skill) {
        return state -> ((Map)mapSelector.apply((PanelState)state)).getOrDefault(skill, 0);
    }

    @Inject
    public SkillsPanel(PanelStateManager manager, ClientDataProviderThreadProxy clientDataProviderThreadProxy) {
        this.manager = manager;
        this.clientDataProviderThreadProxy = clientDataProviderThreadProxy;
        this.setLayout(new BoxLayout(this, 1));
        this.add(new LoadFromClientButton(this::loadFromClient));
        this.statBoxes = Arrays.asList(new StateBoundStatBox(manager, "att", "Attack", true, SkillsPanel.writer(PanelState::getAttackerSkills, Skill.ATTACK), SkillsPanel.reader(PanelState::getAttackerSkills, Skill.ATTACK)), new StateBoundStatBox(manager, "str", "Strength", true, SkillsPanel.writer(PanelState::getAttackerSkills, Skill.STRENGTH), SkillsPanel.reader(PanelState::getAttackerSkills, Skill.STRENGTH)), new StateBoundStatBox(manager, "def", "Defence", true, SkillsPanel.writer(PanelState::getAttackerSkills, Skill.DEFENCE), SkillsPanel.reader(PanelState::getAttackerSkills, Skill.DEFENCE)), new StateBoundStatBox(manager, "mage", "Magic", true, SkillsPanel.writer(PanelState::getAttackerSkills, Skill.MAGIC), SkillsPanel.reader(PanelState::getAttackerSkills, Skill.MAGIC)), new StateBoundStatBox(manager, "range", "Ranged", true, SkillsPanel.writer(PanelState::getAttackerSkills, Skill.RANGED), SkillsPanel.reader(PanelState::getAttackerSkills, Skill.RANGED)), new StateBoundStatBox(manager, "prayer", "Prayer", true, SkillsPanel.writer(PanelState::getAttackerSkills, Skill.PRAYER), SkillsPanel.reader(PanelState::getAttackerSkills, Skill.PRAYER)));
        this.add(new StatCategory("Player Stats", this.statBoxes));
        this.add(Box.createVerticalStrut(10));
        this.boostBoxes = Arrays.asList(new StateBoundStatBox(manager, "att", "Attack", true, SkillsPanel.writer(PanelState::getAttackerBoosts, Skill.ATTACK), SkillsPanel.reader(PanelState::getAttackerBoosts, Skill.ATTACK)), new StateBoundStatBox(manager, "str", "Strength", true, SkillsPanel.writer(PanelState::getAttackerBoosts, Skill.STRENGTH), SkillsPanel.reader(PanelState::getAttackerBoosts, Skill.STRENGTH)), new StateBoundStatBox(manager, "def", "Defence", true, SkillsPanel.writer(PanelState::getAttackerBoosts, Skill.DEFENCE), SkillsPanel.reader(PanelState::getAttackerBoosts, Skill.DEFENCE)), new StateBoundStatBox(manager, "mage", "Magic", true, SkillsPanel.writer(PanelState::getAttackerBoosts, Skill.MAGIC), SkillsPanel.reader(PanelState::getAttackerBoosts, Skill.MAGIC)), new StateBoundStatBox(manager, "range", "Ranged", true, SkillsPanel.writer(PanelState::getAttackerBoosts, Skill.RANGED), SkillsPanel.reader(PanelState::getAttackerBoosts, Skill.RANGED)), new StateBoundStatBox(manager, "prayer", "Prayer", true, SkillsPanel.writer(PanelState::getAttackerBoosts, Skill.PRAYER), SkillsPanel.reader(PanelState::getAttackerBoosts, Skill.PRAYER)));
        this.add(new StatCategory("Boosts", this.boostBoxes));
        this.add(Box.createVerticalStrut(10));
        JPanel commonBoostsPanel = new JPanel();
        commonBoostsPanel.setMaximumSize(new Dimension(200, 40));
        commonBoostsPanel.setLayout(new GridLayout(1, 3));
        commonBoostsPanel.add(new SkillBoostPresetButton(this, SkillBoostPreset.SUPER_COMBAT_POTION, "boost_super_combat_potion.png"));
        commonBoostsPanel.add(new SkillBoostPresetButton(this, SkillBoostPreset.RANGING_POTION, "boost_ranging_potion.png"));
        commonBoostsPanel.add(new SkillBoostPresetButton(this, SkillBoostPreset.IMBUED_HEART, "boost_imbued_heart.png"));
        this.add(commonBoostsPanel);
        this.add(Box.createVerticalStrut(10));
        List<SkillBoostPreset> presets = Arrays.asList(SkillBoostPreset.values());
        presets.sort(Comparator.comparing(SkillBoostPreset::getDisplayName));
        CustomJComboBox<SkillBoostPreset> presetSelect = new CustomJComboBox<SkillBoostPreset>(presets, SkillBoostPreset::getDisplayName, null);
        this.add(presetSelect);
        JButton applyPresetButton = new JButton("Apply");
        applyPresetButton.setAlignmentX(0.5f);
        applyPresetButton.setMinimumSize(new Dimension(0, 35));
        applyPresetButton.setMaximumSize(new Dimension(225, 30));
        applyPresetButton.addActionListener(e -> {
            SkillBoostPreset preset = (SkillBoostPreset)((Object)((Object)presetSelect.getValue()));
            this.applyBoostPreset(preset);
        });
        this.add(applyPresetButton);
    }

    public void loadFromClient() {
        this.clientDataProviderThreadProxy.tryAcquire(clientDataProvider -> {
            Skills playerSkills = clientDataProvider.getPlayerSkills();
            for (Skill s : new Skill[]{Skill.ATTACK, Skill.STRENGTH, Skill.DEFENCE, Skill.MAGIC, Skill.RANGED, Skill.PRAYER}) {
                this.getState().getAttackerSkills().put(s, playerSkills.getLevels().getOrDefault(s, 0));
                this.getState().getAttackerBoosts().put(s, playerSkills.getBoosts().getOrDefault(s, 0));
            }
            SwingUtilities.invokeLater(this::fromState);
        });
    }

    @Override
    public void toState() {
        this.statBoxes.forEach(StateBoundStatBox::toState);
        this.boostBoxes.forEach(StateBoundStatBox::toState);
    }

    @Override
    public void fromState() {
        this.statBoxes.forEach(StateBoundStatBox::fromState);
        this.boostBoxes.forEach(StateBoundStatBox::fromState);
    }

    public boolean isReady() {
        return this.getState().getAttackerSkills().values().stream().anyMatch(i -> i != 0);
    }

    public String getSummary() {
        if (this.isReady()) {
            return "Set";
        }
        return "Not Set";
    }

    public void applyBoostPreset(SkillBoostPreset boostPreset) {
        if (boostPreset != null) {
            boostPreset.apply(this.getState());
            this.boostBoxes.forEach(StateBoundStatBox::fromState);
        }
    }

    @Override
    public PanelStateManager getManager() {
        return this.manager;
    }
}

